/*
* **************************************************************************
 * This file is part of the LibreCAD project, a 2D CAD program
 *
 * Copyright (C) 2025 LibreCAD.org
 * Copyright (C) 2025 sand1024
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * *********************************************************************
 *
 */
#include "lc_dockwidget.h"

LC_DockWidget::LC_DockWidget(QWidget* parent, const QString& title, const QString& m_vertical_title, const Qt::WindowFlags& flags)
    : QDockWidget{title, parent, flags},
              m_verticalTitle{m_vertical_title},
              m_horizontalTitle{title} {
        }

void LC_DockWidget::updateTitle() {
    DockWidgetFeatures currentFeatures = features();
    auto verticalTitleBar = currentFeatures & QDockWidget::DockWidgetVerticalTitleBar;
    if (verticalTitleBar) {
        setWindowTitle(m_verticalTitle);
    }
    else {
        setWindowTitle(m_horizontalTitle);
    }
}
