//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsuseractivitypersistentidentifier?language=objc)
#[cfg(feature = "NSString")]
pub type NSUserActivityPersistentIdentifier = NSString;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsuseractivity?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSUserActivity;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSUserActivity {}
);

impl NSUserActivity {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithActivityType:))]
        #[unsafe(method_family = init)]
        pub fn initWithActivityType(
            this: Allocated<Self>,
            activity_type: &NSString,
        ) -> Retained<Self>;

        #[deprecated = "Use initWithActivityType: with a specific activity type string"]
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(activityType))]
        #[unsafe(method_family = none)]
        pub fn activityType(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub fn title(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub fn setTitle(&self, title: Option<&NSString>);

        #[cfg(feature = "NSDictionary")]
        #[unsafe(method(userInfo))]
        #[unsafe(method_family = none)]
        pub fn userInfo(&self) -> Option<Retained<NSDictionary>>;

        #[cfg(feature = "NSDictionary")]
        /// Setter for [`userInfo`][Self::userInfo].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `user_info` generic should be of the correct type.
        #[unsafe(method(setUserInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserInfo(&self, user_info: Option<&NSDictionary>);

        #[cfg(feature = "NSDictionary")]
        /// # Safety
        ///
        /// `other_dictionary` generic should be of the correct type.
        #[unsafe(method(addUserInfoEntriesFromDictionary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addUserInfoEntriesFromDictionary(&self, other_dictionary: &NSDictionary);

        #[cfg(all(feature = "NSSet", feature = "NSString"))]
        #[unsafe(method(requiredUserInfoKeys))]
        #[unsafe(method_family = none)]
        pub fn requiredUserInfoKeys(&self) -> Option<Retained<NSSet<NSString>>>;

        #[cfg(all(feature = "NSSet", feature = "NSString"))]
        /// Setter for [`requiredUserInfoKeys`][Self::requiredUserInfoKeys].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setRequiredUserInfoKeys:))]
        #[unsafe(method_family = none)]
        pub fn setRequiredUserInfoKeys(&self, required_user_info_keys: Option<&NSSet<NSString>>);

        #[unsafe(method(needsSave))]
        #[unsafe(method_family = none)]
        pub fn needsSave(&self) -> bool;

        /// Setter for [`needsSave`][Self::needsSave].
        #[unsafe(method(setNeedsSave:))]
        #[unsafe(method_family = none)]
        pub fn setNeedsSave(&self, needs_save: bool);

        #[cfg(feature = "NSURL")]
        #[unsafe(method(webpageURL))]
        #[unsafe(method_family = none)]
        pub fn webpageURL(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSURL")]
        /// Setter for [`webpageURL`][Self::webpageURL].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setWebpageURL:))]
        #[unsafe(method_family = none)]
        pub fn setWebpageURL(&self, webpage_url: Option<&NSURL>);

        #[cfg(feature = "NSURL")]
        #[unsafe(method(referrerURL))]
        #[unsafe(method_family = none)]
        pub fn referrerURL(&self) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSURL")]
        /// Setter for [`referrerURL`][Self::referrerURL].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setReferrerURL:))]
        #[unsafe(method_family = none)]
        pub fn setReferrerURL(&self, referrer_url: Option<&NSURL>);

        #[cfg(feature = "NSDate")]
        #[unsafe(method(expirationDate))]
        #[unsafe(method_family = none)]
        pub fn expirationDate(&self) -> Option<Retained<NSDate>>;

        #[cfg(feature = "NSDate")]
        /// Setter for [`expirationDate`][Self::expirationDate].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setExpirationDate:))]
        #[unsafe(method_family = none)]
        pub fn setExpirationDate(&self, expiration_date: Option<&NSDate>);

        #[cfg(all(feature = "NSSet", feature = "NSString"))]
        #[unsafe(method(keywords))]
        #[unsafe(method_family = none)]
        pub fn keywords(&self) -> Retained<NSSet<NSString>>;

        #[cfg(all(feature = "NSSet", feature = "NSString"))]
        /// Setter for [`keywords`][Self::keywords].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setKeywords:))]
        #[unsafe(method_family = none)]
        pub fn setKeywords(&self, keywords: &NSSet<NSString>);

        #[unsafe(method(supportsContinuationStreams))]
        #[unsafe(method_family = none)]
        pub fn supportsContinuationStreams(&self) -> bool;

        /// Setter for [`supportsContinuationStreams`][Self::supportsContinuationStreams].
        #[unsafe(method(setSupportsContinuationStreams:))]
        #[unsafe(method_family = none)]
        pub fn setSupportsContinuationStreams(&self, supports_continuation_streams: bool);

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSUserActivityDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSUserActivityDelegate>>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(targetContentIdentifier))]
        #[unsafe(method_family = none)]
        pub fn targetContentIdentifier(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`targetContentIdentifier`][Self::targetContentIdentifier].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setTargetContentIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn setTargetContentIdentifier(&self, target_content_identifier: Option<&NSString>);

        #[unsafe(method(becomeCurrent))]
        #[unsafe(method_family = none)]
        pub fn becomeCurrent(&self);

        #[unsafe(method(resignCurrent))]
        #[unsafe(method_family = none)]
        pub fn resignCurrent(&self);

        #[unsafe(method(invalidate))]
        #[unsafe(method_family = none)]
        pub fn invalidate(&self);

        #[cfg(all(feature = "NSError", feature = "NSStream", feature = "block2"))]
        /// # Safety
        ///
        /// `completion_handler` block must be sendable.
        #[unsafe(method(getContinuationStreamsWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getContinuationStreamsWithCompletionHandler(
            &self,
            completion_handler: &block2::DynBlock<
                dyn Fn(*mut NSInputStream, *mut NSOutputStream, *mut NSError),
            >,
        );

        #[unsafe(method(isEligibleForHandoff))]
        #[unsafe(method_family = none)]
        pub fn isEligibleForHandoff(&self) -> bool;

        /// Setter for [`isEligibleForHandoff`][Self::isEligibleForHandoff].
        #[unsafe(method(setEligibleForHandoff:))]
        #[unsafe(method_family = none)]
        pub fn setEligibleForHandoff(&self, eligible_for_handoff: bool);

        #[unsafe(method(isEligibleForSearch))]
        #[unsafe(method_family = none)]
        pub fn isEligibleForSearch(&self) -> bool;

        /// Setter for [`isEligibleForSearch`][Self::isEligibleForSearch].
        #[unsafe(method(setEligibleForSearch:))]
        #[unsafe(method_family = none)]
        pub fn setEligibleForSearch(&self, eligible_for_search: bool);

        #[unsafe(method(isEligibleForPublicIndexing))]
        #[unsafe(method_family = none)]
        pub fn isEligibleForPublicIndexing(&self) -> bool;

        /// Setter for [`isEligibleForPublicIndexing`][Self::isEligibleForPublicIndexing].
        #[unsafe(method(setEligibleForPublicIndexing:))]
        #[unsafe(method_family = none)]
        pub fn setEligibleForPublicIndexing(&self, eligible_for_public_indexing: bool);

        #[unsafe(method(isEligibleForPrediction))]
        #[unsafe(method_family = none)]
        pub fn isEligibleForPrediction(&self) -> bool;

        /// Setter for [`isEligibleForPrediction`][Self::isEligibleForPrediction].
        #[unsafe(method(setEligibleForPrediction:))]
        #[unsafe(method_family = none)]
        pub fn setEligibleForPrediction(&self, eligible_for_prediction: bool);

        #[cfg(feature = "NSString")]
        #[unsafe(method(persistentIdentifier))]
        #[unsafe(method_family = none)]
        pub fn persistentIdentifier(&self) -> Option<Retained<NSUserActivityPersistentIdentifier>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`persistentIdentifier`][Self::persistentIdentifier].
        ///
        /// This is [copied][crate::NSCopying::copy] when set.
        #[unsafe(method(setPersistentIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn setPersistentIdentifier(
            &self,
            persistent_identifier: Option<&NSUserActivityPersistentIdentifier>,
        );

        #[cfg(all(feature = "NSArray", feature = "NSString", feature = "block2"))]
        /// # Safety
        ///
        /// `handler` block must be sendable.
        #[unsafe(method(deleteSavedUserActivitiesWithPersistentIdentifiers:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deleteSavedUserActivitiesWithPersistentIdentifiers_completionHandler(
            persistent_identifiers: &NSArray<NSUserActivityPersistentIdentifier>,
            handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(feature = "block2")]
        /// # Safety
        ///
        /// `handler` block must be sendable.
        #[unsafe(method(deleteAllSavedUserActivitiesWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn deleteAllSavedUserActivitiesWithCompletionHandler(
            handler: &block2::DynBlock<dyn Fn()>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl NSUserActivity {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSUserActivity {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsuseractivitytypebrowsingweb?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSUserActivityTypeBrowsingWeb: &'static NSString;
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsuseractivitydelegate?language=objc)
    pub unsafe trait NSUserActivityDelegate: NSObjectProtocol {
        #[optional]
        #[unsafe(method(userActivityWillSave:))]
        #[unsafe(method_family = none)]
        fn userActivityWillSave(&self, user_activity: &NSUserActivity);

        #[optional]
        #[unsafe(method(userActivityWasContinued:))]
        #[unsafe(method_family = none)]
        fn userActivityWasContinued(&self, user_activity: &NSUserActivity);

        #[cfg(feature = "NSStream")]
        #[optional]
        #[unsafe(method(userActivity:didReceiveInputStream:outputStream:))]
        #[unsafe(method_family = none)]
        fn userActivity_didReceiveInputStream_outputStream(
            &self,
            user_activity: &NSUserActivity,
            input_stream: &NSInputStream,
            output_stream: &NSOutputStream,
        );
    }
);
