"use strict";(self.webpackChunkinfluxdb_ui=self.webpackChunkinfluxdb_ui||[]).push([[89],{88428:(e,t,n)=>{n.d(t,{n:()=>d});var r=n(67294),a=n(70651),l=n(32797),i=n(3837),o=n(9935),s=n(97465);const u=()=>{(0,o.B)("firstMile.arduinoWizard.executeAggregateQuery.code.copied")},c=()=>{(0,o.B)("firstMile.arduinoWizard.executeAggregateQuery.docs.opened")},d=e=>{const{bucket:t}=e,n=t===l.Wo?"sample-bucket":t,o=`void loop() {\n    // ... code from Write Data step\n    \n    // Query will find the min RSSI value for last minute for each connected WiFi network with this device\n      String aggregate_query = "from(bucket: \\"${n}\\")\\n\\\n    |> range(start: -1m)\\n\\\n    |> filter(fn: (r) => r._measurement == \\"wifi_status\\")\\n\\\n    |> min()";\n    \n      // Print composed query\n      Serial.println("Querying for the mean RSSI value written to the \\"${n}\\" bucket in the last 1 min... ");\n      Serial.println(aggregate_query);\n    \n      // Send query to the server and get result\n      FluxQueryResult aggregate_result = client.query(aggregate_query);\n    \n      Serial.println("Result : ");\n      // Iterate over rows.\n      while (aggregate_result.next()) {\n        // Get converted value for flux result column 'SSID'\n        String ssid = aggregate_result.getValueByName("SSID").getString();\n        Serial.print("SSID '");\n        Serial.print(ssid);\n    \n        Serial.print("' with RSSI ");\n        // Get value of column named '_value'\n        long value = aggregate_result.getValueByName("_value").getLong();\n        Serial.print(value);\n    \n        // Get value for the _time column\n        FluxDateTime time = aggregate_result.getValueByName("_time").getDateTime();\n    \n        String timeStr = time.format("%F %T");\n    \n        Serial.print(" at ");\n        Serial.print(timeStr);\n    \n        Serial.println();\n      }\n    \n      // Report any error\n      if (aggregate_result.getError() != "") {\n        Serial.print("Query result error: ");\n        Serial.println(aggregate_result.getError());\n      }\n    \n      // Close the result\n      aggregate_result.close();\n    \n      Serial.println("==========");\n    \n      delay(5000);\n    \n    }`;return(0,r.useEffect)((()=>{const e=e=>{(0,s.LO)(e)&&(0,s.Ug)().includes("influx query")&&u()};return document.addEventListener("keydown",e),()=>document.removeEventListener("keydown",e)}),[]),r.createElement(r.Fragment,null,r.createElement("h1",null,"Execute a Flux Aggregate Query"),r.createElement("p",null,r.createElement(i.Q,{href:"https://docs.influxdata.com/flux/v0.x/function-types/#aggregates",onClick:c},"Aggregate functions")," ","take the values of all rows in a table and use them to perform an aggregate operation. The result is output as a new value in a single-row table."),r.createElement("p",null,"An aggregation is applied after the time range and filters, as seen in the example below."),r.createElement(a.ZP,{text:'from(bucket: "weather-data")\n  |> range(start: -10m)\n  |> filter(fn: (r) => r.measurement == "temperature")\n  |> mean()',showCopyControl:!1,onCopy:u,language:"properties"}),r.createElement("p",{className:"small-margins"},"In this example, we use the"," ",r.createElement("code",{className:"homepage-wizard--code-highlight"},"mean()")," function to calculate the average value of data points in the last 1 minute."),r.createElement(a.ZP,{text:o,onCopy:u,language:"arduino"}))}},13375:(e,t,n)=>{n.d(t,{c:()=>c});var r=n(67294),a=n(70651),l=n(32797),i=n(3837),o=n(9935),s=n(97465);const u=()=>{(0,o.B)("firstMile.arduinoWizard.executeQuery.code.copied")},c=e=>{const{bucket:t}=e,n=t===l.Wo?"sample-bucket":t,c=`void loop() {\n    // ... code from Write Data step \n    \n    // Query will find the RSSI values for last minute for each connected WiFi network with this device\n     String query = "from(bucket: \\"${n}\\")\\n\\\n   |> range(start: -1m)\\n\\\n   |> filter(fn: (r) => r._measurement == \\"wifi_status\\" and r._field == \\"rssi\\")";\n   \n     // Print composed query\n     Serial.println("Querying for RSSI values written to the \\"${n}\\" bucket in the last 1 min... ");\n     Serial.println(query);\n   \n     // Send query to the server and get result\n     FluxQueryResult result = client.query(query);\n   \n     Serial.println("Results : ");\n     // Iterate over rows.\n     while (result.next()) {\n       // Get converted value for flux result column 'SSID'\n       String ssid = result.getValueByName("SSID").getString();\n       Serial.print("SSID '");\n       Serial.print(ssid);\n   \n       Serial.print("' with RSSI ");\n       // Get value of column named '_value'\n       long value = result.getValueByName("_value").getLong();\n       Serial.print(value);\n   \n       // Get value for the _time column\n       FluxDateTime time = result.getValueByName("_time").getDateTime();\n   \n       String timeStr = time.format("%F %T");\n   \n       Serial.print(" at ");\n       Serial.print(timeStr);\n   \n       Serial.println();\n     }\n   \n     // Report any error\n     if (result.getError() != "") {\n       Serial.print("Query result error: ");\n       Serial.println(result.getError());\n     }\n   \n     // Close the result\n     result.close();\n   \n     Serial.println("==========");\n   \n     delay(5000);\n   }`;return(0,r.useEffect)((()=>{const e=e=>{(0,s.LO)(e)&&(0,s.Ug)().includes("influx query")&&u()};return document.addEventListener("keydown",e),()=>document.removeEventListener("keydown",e)}),[]),r.createElement(r.Fragment,null,r.createElement("h1",null,"Execute a Flux Query"),r.createElement("p",null,"Now let's query the data we wrote into the database. We use the Flux scripting language to query data."," ",r.createElement(i.Q,{href:"https://docs.influxdata.com/influxdb/latest/reference/syntax/flux/",onClick:()=>(0,o.B)("firstMile.arduinoWizard.documentation.link.clicked")},"Flux")," ","is designed for querying, analyzing, and acting on data.",r.createElement("br",null),r.createElement("br",null),"Here's an example of a basic Flux script:"),r.createElement(a.ZP,{text:"from(bucket: “weather-data”)\n  |> range(start: -10m)\n  |> filter(fn: (r) => r._measurement == “temperature”)",showCopyControl:!1,language:"properties"}),r.createElement("p",{className:"small-margins"},"In this query, we are looking for data points within the last 1 minute with a measurement of"," ",r.createElement("code",{className:"homepage-wizard--code-highlight"},'"wifi_status"'),"."),r.createElement(a.ZP,{text:c,onCopy:u,language:"arduino"}))}},2486:(e,t,n)=>{n.a(e,(async(e,r)=>{try{n.d(t,{K:()=>C});var a=n(67294),l=n(46458),i=n(74006),o=n(98532),s=n(70651),u=n(98555),c=n(23557),d=n(32797),m=n(23915),p=n(41515),g=n(16603),h=n(61072),f=n(12254),S=n(9935),E=n(97465),w=n(46939),v=n(62165),y=n(12197),k=e([o]);o=(k.then?(await k)():k)[0];const b=new Intl.Collator(navigator.language||"en-US"),C=({setTokenValue:e,tokenValue:t,onSelectBucket:n})=>{const r=(0,l.v9)(m.tn),k=(0,l.v9)(p.jo),{org:C}=(0,l.v9)(g.WV),x=(0,l.v9)(h.qf),I=(0,l.I0)(),F=C.clusterHost||window.location.origin,P=(0,l.v9)((e=>e.resources.tokens.currentAuth.item)),B=P.token,D=(0,a.useMemo)((()=>x.sort(((e,t)=>b.compare(e,t)))),[x]),{bucket:W}=(0,a.useContext)(d.ii);(0,a.useEffect)((()=>{I((0,o.So)())}),[I]),(0,a.useEffect)((()=>{try{I((0,i.tw)())}catch(e){I((0,v.h4)((0,y.yjZ)("all access token")))}}),[I]),(0,a.useEffect)((()=>{n(W.name)}),[W.name,n]),(0,a.useEffect)((()=>{if(D.length&&null===t){const e={orgID:r.id,description:`onboarding-arduinoWizard-token-${Date.now()}`,permissions:(0,f.MW)(D,r.id,k.id)};I((0,i.By)(e)),(0,S.B)("firstMile.arduinoWizard.tokens.tokenCreated")}}),[I,null==k?void 0:k.id,null==r?void 0:r.id,D,t]),(0,a.useEffect)((()=>{P.token&&e(P.token)}),[P.token,e]),(0,a.useEffect)((()=>{const e=e=>{(0,E.LO)(e)&&(0,E.Ug)().includes("#define")&&_()};return document.addEventListener("keydown",e),()=>document.removeEventListener("keydown",e)}),[]);const N=`#if defined(ESP32)\n  #include <WiFiMulti.h>\n  WiFiMulti wifiMulti;\n  #define DEVICE "ESP32"\n  #elif defined(ESP8266)\n  #include <ESP8266WiFiMulti.h>\n  ESP8266WiFiMulti wifiMulti;\n  #define DEVICE "ESP8266"\n  #endif\n  \n  #include <InfluxDbClient.h>\n  #include <InfluxDbCloud.h>\n  \n  // WiFi AP SSID\n  #define WIFI_SSID "YOUR_WIFI_SSID"\n  // WiFi password\n  #define WIFI_PASSWORD "YOUR_WIFI_PASSWORD"\n  \n  #define INFLUXDB_URL "${F}"\n  #define INFLUXDB_TOKEN "${B}"\n  #define INFLUXDB_ORG "${r.id}"\n  #define INFLUXDB_BUCKET "${"<BUCKET>"===W.name?"YOUR_BUCKET":W.name}"\n  \n  // Time zone info\n  #define TZ_INFO "UTC${-(0,w.p)()/60}"\n  \n  // Declare InfluxDB client instance with preconfigured InfluxCloud certificate\n  InfluxDBClient client(INFLUXDB_URL, INFLUXDB_ORG, INFLUXDB_BUCKET, INFLUXDB_TOKEN, InfluxDbCloud2CACert);\n  \n  // Declare Data point\n  Point sensor("wifi_status");\n  \n  void setup() {\n    Serial.begin(115200);\n  \n    // Setup wifi\n    WiFi.mode(WIFI_STA);\n    wifiMulti.addAP(WIFI_SSID, WIFI_PASSWORD);\n  \n    Serial.print("Connecting to wifi");\n    while (wifiMulti.run() != WL_CONNECTED) {\n      Serial.print(".");\n      delay(100);\n    }\n    Serial.println();\n  \n    // Accurate time is necessary for certificate validation and writing in batches\n    // We use the NTP servers in your area as provided by: https://www.pool.ntp.org/zone/\n    // Syncing progress and the time will be printed to Serial.\n    timeSync(TZ_INFO, "pool.ntp.org", "time.nis.gov");\n  \n  \n    // Check server connection\n    if (client.validateConnection()) {\n      Serial.print("Connected to InfluxDB: ");\n      Serial.println(client.getServerUrl());\n    } else {\n      Serial.print("InfluxDB connection failed: ");\n      Serial.println(client.getLastErrorMessage());\n    }\n  }\n  void loop() {}\n`,_=()=>{(0,S.B)("firstMile.arduinoWizard.initializeClient.code.copied")};return a.createElement(a.Fragment,null,a.createElement("h1",null,"Initialize Client"),a.createElement("h2",{className:"large-margins"},"Select or Create a bucket"),a.createElement("p",{className:"small-margins"},"A ",a.createElement("b",null,"bucket")," is used to store time-series data. Here is a list of your existing buckets. You can select one to use for the rest of the tutorial, or create one below."),a.createElement(u.Panel,{backgroundColor:u.InfluxColors.Grey15},a.createElement(u.Panel.Body,{size:u.ComponentSize.ExtraSmall},a.createElement(u.Grid,null,a.createElement(u.Grid.Row,null,a.createElement(u.Grid.Column,{widthSM:u.Columns.Twelve},a.createElement(c.Z,{useSimplifiedBucketForm:!0})))))),a.createElement("h2",null,"Configure an InfluxDB profile"),a.createElement("p",{className:"small-margins"},"Next we'll need to configure the client and its initial connection to InfluxDB. InfluxDB Cloud uses Tokens to authenticate API access. We've created an all-access token for you for this set up process."),a.createElement("p",{className:"small-margins"},"Paste the following snippet into a blank Arduino sketch file."),a.createElement(s.ZP,{text:N,onCopy:_,language:"arduino"}),a.createElement("p",{style:{marginBottom:"48px"}},"Note: you will need to set the"," ",a.createElement("code",{className:"homepage-wizard--code-highlight"},"WIFI_SSID")," and"," ",a.createElement("code",{className:"homepage-wizard--code-highlight"},"WIFI_PASSWORD")," ","variables to the correct values for your wifi router."))};r()}catch(e){r(e)}}))},68872:(e,t,n)=>{n.d(t,{a:()=>l});var r=n(67294),a=n(3837);const l=()=>r.createElement(r.Fragment,null,r.createElement("h1",null,"Install Dependencies"),r.createElement("p",null,"You can install the required InfluxDB Client for Arduino library from the library manager"),r.createElement("ol",{style:{fontSize:"16px",fontWeight:"normal"}},r.createElement("li",null,"Under Sketch → Include Libraries, click on Manage Libraries."),r.createElement("li",null,"Search for"," ",r.createElement("code",{className:"homepage-wizard--code-highlight"},"'influxdb'")," in the search box."),r.createElement("li",null,"Install"," ",r.createElement("code",{className:"homepage-wizard--code-highlight"},"'InfluxDB Client for Arduino'")," ","library.")),r.createElement("p",null,"You'll need to have"," ",r.createElement(a.Q,{href:"https://www.arduino.cc/en/software"},"Arduino")," ","installed."))},67750:(e,t,n)=>{n.d(t,{E:()=>i});var r=n(67294),a=n(98555);const l={fontSize:"16px",fontWeight:"normal"},i=()=>{const[e,t]=(0,r.useState)("ESP8266");return r.createElement(r.Fragment,null,r.createElement("h1",null,"Prepare Arduino IDE"),r.createElement("p",null,"The easiest way to get started with the InfluxDB Arduino client is with the ESP8266 or ESP32 board."),r.createElement("p",null,"If you haven't already, add the board you wish to use (ESP8266 or ESP32) to the Arduino IDE by following these steps:"),r.createElement(a.ButtonGroup,{orientation:a.Orientation.Horizontal,style:{margin:"32px 0px"}},r.createElement(a.Button,{text:"ESP8266",color:"ESP8266"===e?a.ComponentColor.Primary:a.ComponentColor.Default,onClick:()=>{t("ESP8266")}}),r.createElement(a.Button,{text:"ESP32",color:"ESP32"===e?a.ComponentColor.Primary:a.ComponentColor.Default,onClick:()=>{t("ESP32")}})),"ESP8266"===e&&r.createElement(r.Fragment,null,r.createElement("p",null,r.createElement("b",null,"For ESP8266:")),r.createElement("ol",{style:l},r.createElement("li",null,"Open the Arduino Preferences (Arduino → Preferences) "),r.createElement("li",null,'Look for "Additional Boards Manager URLs" input box and paste'," ",r.createElement("code",{className:"homepage-wizard--code-highlight"},"http://arduino.esp8266.com/stable/package_esp8266com_index.json")," ","in it."),r.createElement("li",null,"Click OK."),r.createElement("li",null,"Then under Tools → Boards: , click on Boards Manager."),r.createElement("li",null,"Search for ESP8266 in the boards."),r.createElement("li",null,"Install the ESP8266 board by ESP8266 Community."))),"ESP32"===e&&r.createElement(r.Fragment,null,r.createElement("p",null,r.createElement("b",null,"For ESP32:")),r.createElement("ol",{style:l},r.createElement("li",null,"Open the Arduino Preferences (Arduino → Preferences) "),r.createElement("li",null,'Look for "Additional Boards Manager URLs" input box and paste'," ",r.createElement("code",{className:"homepage-wizard--code-highlight"},"https://raw.githubusercontent.com/espressif/arduino-esp32/gh-pages/package_esp32_index.json")," ","in it."),r.createElement("li",null,"Click OK."),r.createElement("li",null,"Then under Tools → Boards: , click on Boards Manager."),r.createElement("li",null,"Search for ESP32 in the boards."),r.createElement("li",null,"Install the ESP32 board by ESP32 Community."))))}},25379:(e,t,n)=>{n.d(t,{F:()=>u});var r=n(67294),a=n(70651),l=n(38413),i=n(98555),o=n(32797),s=n(9935);const u=e=>{const{bucket:t}=e,n=t===o.Wo?"sample-bucket":t,u=()=>{(0,s.B)("firstMile.arduinoWizard.buckets.code.copied")};return r.createElement(r.Fragment,null,r.createElement("h1",null,"Write Data"),r.createElement("p",{className:"small-margins"},"To start writing data, append the lines of code to add tags to the Point at the end of the"," ",r.createElement("code",{className:"homepage-wizard--code-highlight"},"void setup()")," ","function."),r.createElement(a.ZP,{text:'void setup() {\n    // ... code in setup() from Initialize Client\n   \n    // Add tags to the data point\n    sensor.addTag("device", DEVICE);\n    sensor.addTag("SSID", WiFi.SSID());\n   }',onCopy:u,language:"arduino"}),r.createElement("p",null,"Add the following"," ",r.createElement("code",{className:"homepage-wizard--code-highlight"},"loop()")," code snippet to your sketch"),r.createElement(a.ZP,{text:'void loop() {\n    // Clear fields for reusing the point. Tags will remain the same as set above.\n    sensor.clearFields();\n  \n    // Store measured value into point\n    // Report RSSI of currently connected network\n    sensor.addField("rssi", WiFi.RSSI());\n  \n    // Print what are we exactly writing\n    Serial.print("Writing: ");\n    Serial.println(sensor.toLineProtocol());\n  \n    // Check WiFi connection and reconnect if needed\n    if (wifiMulti.run() != WL_CONNECTED) {\n      Serial.println("Wifi connection lost");\n    }\n  \n    // Write point\n    if (!client.writePoint(sensor)) {\n      Serial.print("InfluxDB write failed: ");\n      Serial.println(client.getLastErrorMessage());\n    }\n  \n    Serial.println("Waiting 1 second");\n    delay(1000);\n    }',onCopy:u,language:"arduino"}),r.createElement("p",null,"In the above code snippet, we retrive the RSSI (Received Signal Strength Indicator) of your wifi connection and write it to InfluxDB using the client."),r.createElement("p",null,"Once the data is finished writing, you will see a confirmation below."),r.createElement(i.Panel,{backgroundColor:i.InfluxColors.Grey15},r.createElement(i.Panel.Body,null,r.createElement(l.Z,{bucket:n}))),r.createElement("h2",null,"Review data concepts"),r.createElement("p",null,r.createElement("b",null,"Field (required)")," ",r.createElement("br",null),"Key-value pair for storing time-series data. For example, insect name and its count. You can have one field per record (row of data), and many fields per bucket. ",r.createElement("br",null),r.createElement("i",null,"key data type: string")," ",r.createElement("br",null),r.createElement("i",null,"value data type: float, integer, string, or boolean"),r.createElement("br",null)),r.createElement("p",null,r.createElement("b",null,"Measurement (required)")," ",r.createElement("br",null),"A category for your fields. In our example, it is census. You can have one measurement per record (row of data), and many measurements per bucket. ",r.createElement("br",null),r.createElement("i",null,"data type: string")," ",r.createElement("br",null)),r.createElement("p",{style:{marginBottom:"48px"}},r.createElement("b",null,"Tag (optional)")," ",r.createElement("br",null),"Key-value pair for field metadata. For example, census location. You can have many tags per record (row of data) and per bucket.",r.createElement("br",null),r.createElement("i",null,"key data type: string")," ",r.createElement("br",null),r.createElement("i",null,"value data type: float, integer, string, or boolean")))}},31347:(e,t,n)=>{n.a(e,(async(e,r)=>{try{n.r(t),n.d(t,{ArduinoWizard:()=>y});var a=n(67294),l=n(94184),i=n.n(l),o=n(98555),s=n(33043),u=n(88428),c=n(13375),d=n(25595),m=n(2486),p=n(68872),g=n(39128),h=n(67750),f=n(25379),S=n(32797),E=n(9935),w=n(48928),v=e([m]);m=(v.then?(await v)():v)[0];class y extends a.PureComponent{constructor(){super(...arguments),this.state={currentStep:1,selectedBucket:"sample-bucket",finishStepCompleted:!1,tokenValue:null,finalFeedback:null},this.handleSelectBucket=e=>{this.setState({selectedBucket:e})},this.handleMarkStepAsCompleted=()=>{this.setState({finishStepCompleted:!0})},this.setTokenValue=e=>{this.setState({tokenValue:e})},this.setFinalFeedback=e=>{this.setState({finalFeedback:e})},this.handleNextClick=()=>{this.setState({currentStep:Math.min(this.state.currentStep+1,w.KT.length)},(()=>{(0,E.B)("firstMile.arduinoWizard.next.clicked",{},{clickedButtonAtStep:(0,E.Zo)(w.KT[this.state.currentStep-2].name),currentStep:(0,E.Zo)(w.KT[this.state.currentStep-1].name)}),(0,w.a1)()}))},this.handlePreviousClick=()=>{this.setState({currentStep:Math.max(this.state.currentStep-1,1)},(()=>{(0,E.B)("firstMile.arduinoWizard.previous.clicked",{},{clickedButtonAtStep:(0,E.Zo)(w.KT[this.state.currentStep].name),currentStep:(0,E.Zo)(w.KT[this.state.currentStep-1].name)}),(0,w.a1)()}))},this.handleNavClick=e=>{this.setState({currentStep:e}),(0,E.B)("firstMile.arduinoWizard.subNav.clicked",{},{currentStep:(0,E.Zo)(w.KT[e-1].name)}),(0,w.a1)()},this.renderStep=()=>{switch(this.state.currentStep){case 1:default:return a.createElement(g.g,{wizard:"arduinoWizard"});case 2:return a.createElement(h.E,null);case 3:return a.createElement(p.a,null);case 4:return a.createElement(m.K,{setTokenValue:this.setTokenValue,tokenValue:this.state.tokenValue,onSelectBucket:this.handleSelectBucket});case 5:return a.createElement(f.F,{bucket:this.state.selectedBucket});case 6:return a.createElement(c.c,{bucket:this.state.selectedBucket});case 7:return a.createElement(u.n,{bucket:this.state.selectedBucket});case 8:return a.createElement(d.p,{wizardEventName:"arduinoWizard",markStepAsCompleted:this.handleMarkStepAsCompleted,finishStepCompleted:this.state.finishStepCompleted,finalFeedback:this.state.finalFeedback,setFinalFeedback:this.setFinalFeedback})}}}render(){return a.createElement(o.Page,null,a.createElement(o.Page.Header,{fullWidth:!1}),a.createElement(o.Page.Contents,{scrollable:!0},a.createElement("div",{className:"homepage-wizard-container"},a.createElement("aside",{className:"homepage-wizard-container--subway"},a.createElement("div",{className:"homepage-wizard-container--subway-inner","data-testid":"subway-nav"},a.createElement(o.SubwayNav,{currentStep:this.state.currentStep,onStepClick:this.handleNavClick,navigationSteps:w.KT,settingUpIcon:s.cO,settingUpText:"Arduino",setupTime:"5 minutes"}))),a.createElement("div",{className:"homepage-wizard-container--main"},a.createElement("div",{className:i()("homepage-wizard-container--main-wrapper",{verticallyCentered:1===this.state.currentStep||this.state.currentStep===w.KT.length})},a.createElement(S.ZP,null,this.renderStep())),a.createElement("div",{className:"homepage-wizard-container-footer"},a.createElement(o.Button,{onClick:this.handlePreviousClick,text:"Previous",size:o.ComponentSize.Large,color:o.ComponentColor.Tertiary,status:this.state.currentStep>1?o.ComponentStatus.Default:o.ComponentStatus.Disabled,testID:"arduino-prev-button"}),a.createElement(o.Button,{onClick:this.handleNextClick,text:"Next",size:o.ComponentSize.Large,color:o.ComponentColor.Primary,status:this.state.currentStep<w.KT.length?o.ComponentStatus.Default:o.ComponentStatus.Disabled,testID:"arduino-next-button"}))))))}}r()}catch(e){r(e)}}))},97465:(e,t,n)=>{var r;n.d(t,{LO:()=>l,Ug:()=>i,eR:()=>o,ku:()=>s,xf:()=>a}),function(e){e.Mac="MacOS",e.Windows="Windows",e.Linux="Linux"}(r||(r={}));const a=e=>{var t,n;let a=r.Mac;return(null===(t=null===window||void 0===window?void 0:window.navigator)||void 0===t?void 0:t.userAgent.includes("Windows"))&&(a=r.Windows),(null===(n=null===window||void 0===window?void 0:window.navigator)||void 0===n?void 0:n.userAgent.includes("Linux"))&&(a=r.Linux),!(a!==r.Mac||!e.metaKey)||!(a!==r.Windows&&a!==r.Linux||!e.ctrlKey)},l=e=>{var t,n;let a=r.Mac;return(null===(t=null===window||void 0===window?void 0:window.navigator)||void 0===t?void 0:t.userAgent.includes("Windows"))&&(a=r.Windows),(null===(n=null===window||void 0===window?void 0:window.navigator)||void 0===n?void 0:n.userAgent.includes("Linux"))&&(a=r.Linux),!(a!==r.Mac||!e.metaKey||"KeyC"!==e.key&&67!=e.keyCode)||!(a!==r.Windows&&a!==r.Linux||!e.ctrlKey||"KeyC"!==e.key&&67!=e.keyCode)},i=()=>window.getSelection().toString(),o=()=>{var e;return!!(null===(e=null===window||void 0===window?void 0:window.navigator)||void 0===e?void 0:e.userAgent.includes("Windows"))},s=()=>{var e;return!!(null===(e=null===window||void 0===window?void 0:window.navigator)||void 0===e?void 0:e.userAgent.includes("Linux"))}}}]);
//# sourceMappingURL=03c9aae5a5.js.map