/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.lax;

import java.io.IOException;
import java.io.Reader;

public class LAXQuotedStreamTokenizer {
    private Reader in;
    private char quoteChar = (char)34;
    private char delimiter = (char)32;
    private boolean delimiting = true;
    private int type = -1;
    public static final int NOTHING = -1;
    public static final int WORDS = -10;
    public static final int FULL_QUOTED = -11;
    public static final int HALF_QUOTED = -12;
    private boolean drained = false;
    private boolean quoting = false;

    public LAXQuotedStreamTokenizer(Reader reader) {
        this.in = reader;
    }

    public int getType() {
        return this.type;
    }

    public void setQuoteChar(char c) {
        this.quoteChar = c;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public void setDelimiter(char c) {
        this.delimiter = c;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public boolean isDelimiting() {
        return this.delimiting;
    }

    public void setDelimiting(boolean bl) {
        this.delimiting = bl;
    }

    public String getNextToken() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.drained) {
            this.type = -1;
            return null;
        }
        try {
            int n;
            while ((n = this.in.read()) != -1) {
                if (n == 92) {
                    if (bl) {
                        stringBuffer.append("\\");
                        bl = false;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (n == this.quoteChar) {
                    if (bl) {
                        stringBuffer.append("\"");
                        bl = false;
                        continue;
                    }
                    if (this.quoting) {
                        this.type = -11;
                        this.quoting = false;
                        return stringBuffer.toString();
                    }
                    this.quoting = true;
                    if (stringBuffer.length() <= 0) continue;
                    this.type = -10;
                    return stringBuffer.toString();
                }
                if (this.isDelimiting() && n == this.delimiter && !this.quoting) {
                    if (bl) {
                        stringBuffer.append("\\");
                        bl = false;
                    }
                    if (stringBuffer.length() <= 0) continue;
                    this.type = -10;
                    return stringBuffer.toString();
                }
                if (bl) {
                    stringBuffer.append("\\");
                    bl = false;
                }
                stringBuffer.append(String.valueOf((char)n));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.drained = true;
        this.type = this.quoting ? -12 : -10;
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

