/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.cbutil.CBUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class CBCache {
    private static int counter = 0;
    private static int CACHEMAX = 1000;
    private static int CACHEMIN = 500;
    private static File fileDir = null;
    private static File audioFileDir = null;
    private static String[] allFiles;
    private static String[] allAudioFiles;
    private static String extension;
    private static String dirPath;
    private static Logger log;

    public static void createCache(String currentDN, Attributes entry, String type, int size) {
        int i;
        if (type.equalsIgnoreCase("audio")) {
            CBCache.createAudioCache(currentDN, entry, type, size);
            return;
        }
        fileDir = CBCache.makeTempDir(dirPath);
        if (fileDir == null) {
            log.warning("Unable to create cache directory " + fileDir.toString() + " (permission problems?)");
            return;
        }
        allFiles = fileDir.list();
        if (allFiles == null) {
            log.warning("Unable to read cache directory " + fileDir.toString() + " (permission problems?)");
            return;
        }
        currentDN = Integer.toString(currentDN.hashCode());
        for (i = 0; i < allFiles.length; ++i) {
            if (allFiles[i].startsWith(currentDN) && type.equalsIgnoreCase("jpegPhoto") && allFiles[i].endsWith(".jpg")) {
                return;
            }
            if (allFiles[i].startsWith(currentDN) && type.equalsIgnoreCase("odDocumentDOC") && allFiles[i].endsWith(".doc")) {
                return;
            }
            if (allFiles[i].startsWith(currentDN) && type.equalsIgnoreCase("odSpreadSheetXLS") && allFiles[i].endsWith(".xls")) {
                return;
            }
            if (allFiles[i].startsWith(currentDN) && type.equalsIgnoreCase("odMovieAVI") && allFiles[i].endsWith(".avi")) {
                return;
            }
            if (allFiles[i].startsWith(currentDN) && type.equalsIgnoreCase("odSoundWAV") && allFiles[i].endsWith(".wav")) {
                return;
            }
            if (!allFiles[i].startsWith(currentDN) || !type.equalsIgnoreCase("odMusicMID") || !allFiles[i].endsWith(".mid")) continue;
            return;
        }
        for (i = 0; i < size; ++i) {
            byte[] bytes = CBCache.getAttByteValue(type, entry, i);
            if (type.equalsIgnoreCase("odDocumentDOC")) {
                CBCache.doNormalCache(currentDN, bytes, ".doc");
                continue;
            }
            if (type.equalsIgnoreCase("odSpreadSheetXLS")) {
                CBCache.doNormalCache(currentDN, bytes, ".xls");
                continue;
            }
            if (type.equalsIgnoreCase("odMovieAVI")) {
                CBCache.doNormalCache(currentDN, bytes, ".avi");
                continue;
            }
            if (type.equalsIgnoreCase("odMusicMID")) {
                CBCache.doNormalCache(currentDN, bytes, ".mid");
                continue;
            }
            if (type.equalsIgnoreCase("odSoundWAV")) {
                CBCache.doNormalCache(currentDN, bytes, ".wav");
                continue;
            }
            if (!type.equalsIgnoreCase("jpegPhoto")) continue;
            CBCache.doNormalCache(currentDN, bytes, ".jpg");
        }
        if (allFiles.length > CACHEMAX) {
            CBCache.decreaseCacheSize();
        }
    }

    public static void createAudioCache(String currentDN, Attributes entry, String type, int size) {
        int i;
        if (!type.equalsIgnoreCase("audio")) {
            log.warning("Error - trying to create a audio temporary cache with incorrect data in 'CBCache.createAudioCache'.");
            return;
        }
        audioFileDir = CBCache.makeAudioDir();
        if (audioFileDir == null) {
            log.warning("Unable to read cache directory " + audioFileDir.toString() + " (permission problems?)");
            return;
        }
        allAudioFiles = audioFileDir.list();
        if (allAudioFiles == null) {
            log.warning("Unable to list cache directory " + audioFileDir.toString() + " (permission problems?)");
            return;
        }
        currentDN = Integer.toString(currentDN.hashCode());
        for (i = 0; i < allAudioFiles.length; ++i) {
            if (!allAudioFiles[i].startsWith(currentDN)) continue;
            return;
        }
        for (i = 0; i < size; ++i) {
            byte[] bytes = CBCache.getAttByteValue(type, entry, i);
            if (!type.equalsIgnoreCase("audio")) continue;
            CBCache.doAudioCache(currentDN, bytes);
        }
        if (allAudioFiles.length > CACHEMAX) {
            CBCache.decreaseAudioCacheSize();
        }
    }

    public static void doNormalCache(String currentDN, byte[] bytes, String extension) {
        String name = currentDN + counter + extension;
        File file = new File(fileDir, name);
        ++counter;
        try {
            file.deleteOnExit();
            FileOutputStream output = new FileOutputStream(file);
            output.write(bytes);
            output.close();
        }
        catch (Exception e) {
            CBUtility.error(CBIntText.get("Problem writing the temporary file") + ": " + file.toString() + "\n" + e);
        }
    }

    public static void doAudioCache(String currentDN, byte[] bytes) {
        byte[] testBytes = new byte[100];
        if (bytes.length > 100) {
            System.arraycopy(bytes, 0, testBytes, 0, 100);
        } else {
            testBytes = bytes;
        }
        String hexSub = CBParse.bytes2Hex(testBytes);
        extension = hexSub.indexOf("574156") > -1 ? ".wav" : (hexSub.indexOf("494433") > -1 ? ".mp3" : (hexSub.toLowerCase().indexOf("fffb9044") > -1 ? ".mp3" : (hexSub.toLowerCase().indexOf("fffb300c") > -1 ? ".mp3" : (hexSub.toLowerCase().indexOf("fff330c0") > -1 ? ".mp3" : (hexSub.indexOf("524946") > -1 ? ".rmi" : (hexSub.toLowerCase().indexOf("524d46") > -1 ? ".ram" : (hexSub.indexOf("41494646") > -1 ? ".aiff" : (hexSub.toLowerCase().indexOf("4d546864") > -1 ? ".mid" : (hexSub.toLowerCase().indexOf("2e736e64") > -1 ? ".au" : (hexSub.toLowerCase().indexOf("636f6f6c") > -1 ? ".stm" : (hexSub.toLowerCase().indexOf("437265617469766520566f6963652046696c65") > -1 ? ".voc" : (hexSub.toLowerCase().indexOf("457874656e646564204d6f64756c65") > -1 ? ".xm" : (hexSub.toLowerCase().indexOf("5343524d") > -1 ? ".s3m" : (hexSub.toLowerCase().indexOf("494d50") > -1 ? ".it" : ".xxx"))))))))))))));
        if (audioFileDir == null) {
            log.warning("no cache directory found for audio files - skipping");
            return;
        }
        File file = new File(audioFileDir, currentDN + counter + extension);
        ++counter;
        file.deleteOnExit();
        try {
            FileOutputStream output = new FileOutputStream(file);
            output.write(bytes);
            output.close();
        }
        catch (IOException e) {
            CBUtility.error(CBIntText.get("Problem writing the audio temporary file") + ": " + file.toString() + "\n" + e);
        }
    }

    public static File[] sortFiles(File[] files) {
        Arrays.sort(files, new FileTimeComparator());
        return files;
    }

    public static File getCacheDirectory() {
        return fileDir;
    }

    public static File getAudioCacheDirectory() {
        return audioFileDir;
    }

    public static void decreaseCacheSize() {
        if (fileDir == null) {
            return;
        }
        File[] fileArray = fileDir.listFiles();
        fileArray = CBCache.sortFiles(fileArray);
        for (int i = 0; i < fileArray.length - CACHEMIN; ++i) {
            String fileName = fileArray[i].getName();
            for (int x = 0; x < allFiles.length; ++x) {
                if (!allFiles[x].startsWith(fileName.substring(0, fileArray[i].toString().length() - 15))) continue;
                File tempFile = new File(CBCache.makeTempDir(dirPath), allFiles[x].toString());
                tempFile.delete();
            }
        }
        CBCache.decreaseAudioCacheSize();
    }

    public static void decreaseAudioCacheSize() {
        if (audioFileDir == null) {
            return;
        }
        File[] fileArray = audioFileDir.listFiles();
        fileArray = CBCache.sortFiles(fileArray);
        for (int i = 0; i < fileArray.length - CACHEMIN; ++i) {
            String fileName = fileArray[i].getName();
            for (int x = 0; x < allAudioFiles.length; ++x) {
                if (!allAudioFiles[x].startsWith(fileName.substring(0, fileArray[i].toString().length() - 15))) continue;
                File tempFile = new File(CBCache.makeAudioDir(), allAudioFiles[x].toString());
                tempFile.delete();
            }
        }
    }

    public static File makeTempDir(String dir) {
        try {
            File temp = File.createTempFile(dir, Long.toString(System.nanoTime()));
            if (!temp.delete()) {
                throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
            }
            if (!temp.mkdir()) {
                throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
            }
            return temp;
        }
        catch (IOException e) {
            log.warning("Error creating temp directory: " + e.getMessage());
            return null;
        }
    }

    private static File makeAudioDir() {
        return CBCache.makeTempDir("audio");
    }

    public static String getDirPath() {
        return fileDir == null ? null : fileDir.getAbsolutePath() + File.separator;
    }

    public static String setDirPath(String path) {
        dirPath = path;
        return dirPath;
    }

    public static String getAudioDirPath() {
        if (audioFileDir == null) {
            audioFileDir = CBCache.makeAudioDir();
        }
        if (audioFileDir != null) {
            return audioFileDir.getAbsolutePath() + File.separator;
        }
        return null;
    }

    private static byte[] getAttByteValue(String name, Attributes entry, int entries) {
        try {
            Attribute a = entry.get(name);
            if (a == null) {
                return null;
            }
            if (a.size() == 0 || a.get() == null) {
                return null;
            }
            Object o = a.get(entries);
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            return null;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Form Value Error getting value for " + name + " value :\n ", e);
            return null;
        }
    }

    public static void cleanCache(String currentDN) {
        File tempFile;
        int i;
        currentDN = Integer.toString(currentDN.hashCode());
        if (fileDir != null) {
            allFiles = fileDir.list();
            for (i = 0; i < allFiles.length; ++i) {
                if (!allFiles[i].startsWith(currentDN.toString())) continue;
                tempFile = new File(fileDir, allFiles[i].toString());
                tempFile.delete();
            }
        }
        if (allAudioFiles != null) {
            allAudioFiles = audioFileDir.list();
            for (i = 0; i < allAudioFiles.length; ++i) {
                if (!allAudioFiles[i].startsWith(currentDN.toString())) continue;
                tempFile = new File(audioFileDir, allAudioFiles[i].toString());
                tempFile.delete();
            }
        }
    }

    public static void cleanCache() {
        File tempFile;
        int i;
        if (fileDir == null) {
            return;
        }
        allFiles = fileDir.list();
        if (allFiles == null) {
            return;
        }
        for (i = 0; i < allFiles.length; ++i) {
            tempFile = new File(fileDir, allFiles[i].toString());
            tempFile.delete();
        }
        if (audioFileDir == null) {
            return;
        }
        allAudioFiles = audioFileDir.list();
        if (allAudioFiles == null) {
            return;
        }
        if (allAudioFiles != null) {
            for (i = 0; i < allAudioFiles.length; ++i) {
                tempFile = new File(CBCache.makeAudioDir(), allAudioFiles[i].toString());
                tempFile.delete();
            }
        }
    }

    public static void setMaxCacheSize(int size) {
        CACHEMAX = size;
    }

    public static void setMinCacheSize(int size) {
        CACHEMIN = size;
    }

    static {
        extension = ".jpg";
        dirPath = "temp";
        log = Logger.getLogger(CBCache.class.getName());
    }

    public static class FileTimeComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            long b;
            long a = ((File)o1).lastModified();
            return a == (b = ((File)o2).lastModified()) ? 0 : (a < b ? -1 : 1);
        }
    }
}

