/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.cert.extensions.IssuerAltName;
import com.ca.commons.security.cert.extensions.V3Extension;

public class CRLDistributionPoints
implements V3Extension {
    String value = null;

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for CRLDistributionPoints");
        }
        for (int i = 0; i < asn1object.size(); ++i) {
            ASN1Object distributionPoint = asn1object.getComponent(i);
            if (!distributionPoint.isASN1Type(ASN1Type.SEQUENCE)) {
                throw new Exception("Wrong ASN.1 type for CRLDistributionPoints.distributionPoint");
            }
            for (int j = 0; j < distributionPoint.size(); ++j) {
                ASN1Object nextComp = distributionPoint.getComponent(j);
                if (j == 0) {
                    ASN1Object fullName = (ASN1Object)((ASN1Object)nextComp.getValue()).getValue();
                    if (this.value == null) {
                        this.value = IssuerAltName.getGNameString(fullName);
                        continue;
                    }
                    this.value = this.value + "\n" + IssuerAltName.getGNameString(fullName);
                    continue;
                }
                if (j == 1) {
                    System.out.println("Not reading CRLDistributionPoints.distributionPoint.reasons");
                    continue;
                }
                if (j != 2) continue;
                System.out.println("Not reading CRLDistributionPoints.distributionPoint.cRLIssuer");
            }
        }
    }

    public String toString() {
        return this.value;
    }
}

