/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.GeneralName;
import com.ca.commons.security.cert.extensions.V3Extension;
import java.util.StringTokenizer;
import java.util.Vector;

public class IssuerAltName
implements V3Extension {
    String value = null;

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for *AltName");
        }
        for (int i = 0; i < asn1object.size(); ++i) {
            ASN1Object nextName = asn1object.getComponent(i);
            String nextEntry = IssuerAltName.getGNameString(nextName);
            this.value = this.value == null ? nextEntry : this.value + "\n" + nextEntry;
        }
    }

    public static String cleanName(String dn) {
        StringTokenizer tok = new StringTokenizer(dn, ",");
        Vector<String> toks = new Vector<String>();
        while (tok.hasMoreTokens()) {
            String nextToken = tok.nextToken();
            if (nextToken.endsWith(" = null")) continue;
            toks.addElement(nextToken);
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < toks.size(); ++i) {
            if (buff.toString().length() == 0) {
                buff.append((String)toks.elementAt(i));
                continue;
            }
            buff.append(", " + toks.elementAt(i));
        }
        return buff.toString();
    }

    private static String getIP(String ip) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < ip.length(); ++i) {
            buff.append(ip.charAt(i) + ".");
        }
        if (buff.toString().endsWith(".")) {
            buff.deleteCharAt(buff.length() - 1);
        }
        return buff.toString();
    }

    public static String getGNameString(ASN1Object nextName) {
        GeneralName gname = new GeneralName(nextName);
        int type = gname.getType();
        Object valuee = gname.getValue(type);
        String nextEntry = null;
        if (type >= 0 && valuee != null) {
            String value = null;
            value = type == 7 ? IssuerAltName.getIP(valuee.toString()) : IssuerAltName.cleanName(valuee.toString());
            nextEntry = GeneralName.lookUpName(type) + ": " + value;
        } else {
            nextEntry = "Unrecognised GeneralName type: " + type;
        }
        return nextEntry;
    }

    public String toString() {
        return this.value;
    }
}

