/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.Theme;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.MainMenu;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ButtonBar
extends JToolBar
implements ActionListener {
    JXplorerBrowser browser;
    MainMenu menu;
    JButton connect;
    JButton disconnect;
    JButton print;
    JButton cut;
    JButton copy;
    JButton paste;
    JButton del;
    JButton newEntry;
    JButton rename;
    JButton refresh;
    JButton stop;
    JButton pasteAlias;
    JButton copyDN;
    ButtonRegister br = null;
    private static Logger log = Logger.getLogger(ButtonBar.class.getName());

    public ButtonBar(JXplorerBrowser browser) {
        this.browser = browser;
        this.setFloatable(false);
        this.menu = browser.mainMenu;
        this.setSize(750, 20);
        this.connect = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "connect.gif"));
        this.add(this.connect);
        this.disconnect = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "disconnect.gif"));
        this.add(this.disconnect);
        this.print = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "print.gif"));
        this.add(this.print);
        this.addSeparator();
        this.cut = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "cut.gif"));
        this.add(this.cut);
        this.copyDN = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "copy_dn.gif"));
        this.add(this.copyDN);
        this.copy = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "copy.gif"));
        this.add(this.copy);
        this.paste = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "paste.gif"));
        this.add(this.paste);
        this.pasteAlias = new JButton(new ImageIcon(Theme.getInstance().getDirIcons() + "alias.gif"));
        this.add(this.pasteAlias);
        this.addSeparator();
        this.del = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "delete.gif"));
        this.add(this.del);
        this.addSeparator();
        this.newEntry = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "new.gif"));
        this.add(this.newEntry);
        this.rename = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "rename.gif"));
        this.add(this.rename);
        this.addSeparator();
        this.refresh = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "refresh.gif"));
        this.add(this.refresh);
        this.addSeparator();
        this.stop = new JButton(new ImageIcon(Theme.getInstance().getDirImages() + "stop.gif"));
        this.add(this.stop);
        this.connect.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "connect_rollover.gif"));
        this.disconnect.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "disconnect_rollover.gif"));
        this.print.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "print_rollover.gif"));
        this.cut.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "cut_rollover.gif"));
        this.copy.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "copy_rollover.gif"));
        this.copyDN.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "copy_dn_rollover.gif"));
        this.paste.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "paste_rollover.gif"));
        this.pasteAlias.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "alias_rollover.gif"));
        this.del.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "delete_rollover.gif"));
        this.newEntry.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "new_rollover.gif"));
        this.rename.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "rename_rollover.gif"));
        this.refresh.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "refresh_rollover.gif"));
        this.stop.setRolloverIcon(new ImageIcon(Theme.getInstance().getDirImages() + "stop_rollover.gif"));
        Component[] buttons = this.getComponents();
        for (int i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof JButton)) continue;
            JButton temp = (JButton)buttons[i];
            temp.addActionListener(this);
            temp.setRolloverEnabled(true);
            temp.setSize(16, 16);
        }
        this.connect.setToolTipText(CBIntText.get("Connect to a DSA."));
        this.disconnect.setToolTipText(CBIntText.get("Disconnect from a DSA."));
        this.print.setToolTipText(CBIntText.get("Print out the current entry."));
        this.cut.setToolTipText(CBIntText.get("Select a subtree to move."));
        this.copy.setToolTipText(CBIntText.get("Select a subtree to copy."));
        this.copyDN.setToolTipText(CBIntText.get("Copy the Distinguished Name of an entry to the clipboard."));
        this.paste.setToolTipText(CBIntText.get("Paste a previously selected subtree."));
        this.pasteAlias.setToolTipText(CBIntText.get("Paste an Alias."));
        this.del.setToolTipText(CBIntText.get("Delete an entry."));
        this.newEntry.setToolTipText(CBIntText.get("Create a new entry."));
        this.rename.setToolTipText(CBIntText.get("Rename an entry."));
        this.refresh.setToolTipText(CBIntText.get("Refresh an entry."));
        this.stop.setToolTipText(CBIntText.get("Cancel queries."));
        this.br = browser.getButtonRegister();
        this.br.registerItem("PASTE", this.paste);
        this.br.registerItem("PASTE_ALIAS", this.pasteAlias);
        this.br.registerItem("COPY", this.copy);
        this.br.registerItem("COPY_DN", this.copyDN);
        this.br.registerItem("CUT", this.cut);
        this.br.registerItem("CONNECT", this.connect);
        this.br.registerItem("DISCONNECT", this.disconnect);
        this.br.registerItem("PRINT", this.print);
        this.br.registerItem("DELETE", this.del);
        this.br.registerItem("NEW", this.newEntry);
        this.br.registerItem("RENAME", this.rename);
        this.br.registerItem("REFRESH", this.refresh);
        this.br.registerItem("STOP", this.stop);
        this.br.setItemEnabled("STOP", false);
        browser.getStopMonitor().addWatcher(this.stop);
        this.setDisconnected();
        this.setMargin(new Insets(2, 0, 2, 0));
        this.doLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connect) {
            this.menu.connect();
        } else if (e.getSource() == this.disconnect) {
            this.menu.disconnect();
        } else if (e.getSource() == this.print) {
            this.menu.print();
        } else if (e.getSource() == this.cut) {
            this.browser.getActiveTree().getPopupTool().cut();
        } else if (e.getSource() == this.copy) {
            this.browser.getActiveTree().getPopupTool().copy();
        } else if (e.getSource() == this.copyDN) {
            this.browser.getActiveTree().getPopupTool().copyDN();
        } else if (e.getSource() == this.paste) {
            this.browser.getActiveTree().getPopupTool().paste();
        } else if (e.getSource() == this.pasteAlias) {
            this.browser.getActiveTree().getPopupTool().pasteAlias();
        } else if (e.getSource() == this.del) {
            this.browser.getActiveTree().getPopupTool().delete();
        } else if (e.getSource() == this.newEntry) {
            this.browser.getActiveTree().getPopupTool().newEntry();
        } else if (e.getSource() == this.rename) {
            this.browser.getActiveTree().getPopupTool().rename();
        } else if (e.getSource() == this.refresh) {
            this.browser.getActiveTree().getPopupTool().refresh();
        } else if (e.getSource() == this.stop) {
            this.browser.getStopMonitor().show();
        } else {
            log.warning("error - unknown option in ButtonBar: " + e.getSource().toString());
        }
    }

    public void setDisconnected() {
        this.br.setDisconnectState();
    }
}

