/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.LdifEntry;
import com.ca.commons.naming.LdifEntryType;
import com.ca.commons.naming.LdifFileChooser;
import com.ca.commons.naming.LdifModifyAttribute;
import com.ca.commons.naming.LdifModifyType;
import com.ca.commons.naming.LdifStreamReader;
import com.ca.commons.naming.LdifUtility;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.DataBrokerQueryInterface;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.broker.OfflineDataBroker;
import com.ca.directory.jxplorer.broker.SchemaDataBroker;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.ProgressMonitorInputStream;

public class LdifImport {
    DataBrokerQueryInterface dataSource;
    File readFile;
    SmartTree tree;
    Frame owner;
    SchemaDataBroker schema;
    boolean offline = true;
    LdifUtility ldifutil = new LdifUtility();
    static final boolean debug = true;
    static ProgressMonitorInputStream pmonitor;
    private static Logger log;

    public LdifImport(DataBrokerQueryInterface dataSource, SmartTree mrTree, Frame owner, SchemaDataBroker schema) {
        this.owner = owner;
        this.schema = schema;
        this.tree = mrTree;
        DN base = this.tree.getCurrentDN();
        this.offline = this.tree.isEmpty();
        this.dataSource = dataSource;
    }

    public boolean readLdifTree(InputStream textStream, DataBroker broker, DataQuery query, boolean preview) throws NamingException {
        HashSet<String> addedDNs = new HashSet<String>();
        HashSet<String> deletedDNs = new HashSet<String>();
        DXEntry apex = null;
        int numEntriesRead = 0;
        ArrayList<LdifEntry> testResults = new ArrayList<LdifEntry>();
        LdifStreamReader readText = this.getLdifStreamReader(textStream);
        try {
            ArrayList<DN> list = new ArrayList<DN>();
            String progressNote = CBIntText.get("reading entry #");
            if (preview) {
                addedDNs = new HashSet();
                deletedDNs = new HashSet();
            }
            try {
                LdifEntry newEntry;
                while ((newEntry = this.ldifutil.readLdifEntry(readText)) != null) {
                    if (query.isCancelled()) {
                        return false;
                    }
                    int size = newEntry.getDN().size();
                    if (size != 0) {
                        DN newDN = newEntry.getDN();
                        if (apex == null || apex.getDN().size() > size) {
                            apex = newEntry;
                        }
                        if (this.offline) {
                            this.translateToUnicode(newEntry);
                        }
                        if (preview) {
                            int lineNumber = readText.getLineNumber();
                            if (newEntry.getChangeType() == LdifEntryType.normal) {
                                testResults.add(this.testNormalLdifImpact(newEntry, broker, addedDNs, lineNumber));
                            } else {
                                testResults.add(this.testLdifChangeEntryImpact(newEntry, broker, addedDNs, deletedDNs, lineNumber));
                            }
                        } else if (newEntry.getChangeType() == LdifEntryType.normal) {
                            this.addLdifNormalEntry(newEntry, broker);
                        } else if (broker instanceof OfflineDataBroker) {
                            this.addLdifChangeTypeEntry(newEntry, broker);
                        } else {
                            this.executeLdifChangeTypeEntry(newEntry, broker);
                        }
                        if (!list.contains(this.getRoot(broker, newDN))) {
                            list.add(this.getRoot(broker, newDN));
                        }
                    } else {
                        log.warning("skipping ldif data at line: " + this.ldifutil.getCurrentLineNumber());
                    }
                    if (pmonitor == null) continue;
                    pmonitor.getProgressMonitor().setNote(progressNote + " " + ++numEntriesRead);
                }
            }
            catch (InterruptedIOException e) {
                return false;
            }
            catch (NamingException e) {
                CBUtility.error(CBIntText.get("An error occured while processing the LDIF file") + " line: " + readText.getLineNumber(), e);
                e.printStackTrace();
                return false;
            }
            if (preview) {
                return this.showTestResults(testResults, apex);
            }
            if (this.tree.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    DN root = (DN)list.get(i);
                    this.tree.setRootDN(root);
                    this.tree.expandRootDN();
                    this.tree.getRootNode().setStructural(true);
                }
            }
            if (apex != null && apex.getDN() != null && apex.getDN().size() > 1) {
                this.tree.refresh(apex.getDN().getParent());
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            CBUtility.error(CBIntText.get("An error occured while processing the LDIF file") + " -" + this.readFile.toString() + ":" + readText.getLineNumber(), e2);
        }
        return false;
    }

    protected LdifStreamReader getLdifStreamReader(InputStream textStream) throws NamingException {
        LdifStreamReader readText;
        try {
            readText = new LdifStreamReader(new InputStreamReader(textStream, "UTF-8"));
        }
        catch (IOException e) {
            throw new NamingException(CBIntText.get("Unexpected problem - Unable to read the LDIF file") + ": " + e.getMessage());
        }
        return readText;
    }

    public boolean showTestResults(ArrayList<LdifEntry> testResults, DXEntry apex) {
        boolean error = false;
        JTextArea text = new JTextArea("The following LDIF errors were found.  The server is unlikely to accept the file.\n\n");
        for (LdifEntry entry : testResults) {
            if (!entry.contains("error")) continue;
            text.append(" [" + entry.getString("linenumber") + "] " + entry.getDN() + " -> " + entry.getString("error") + "\n");
            error = true;
        }
        if (error) {
            JOptionPane.showMessageDialog(this.owner, text, CBIntText.get("Errors found!"), 0);
        } else if (apex == null) {
            JOptionPane.showMessageDialog(this.owner, CBIntText.get("No Ldif Entries were found.  File is empty or corrupt."), CBIntText.get("Errors found!"), 0);
        } else {
            int result = JOptionPane.showConfirmDialog(this.owner, CBIntText.get("No LDIF errors found (however the client can't completely test an LDIF file, and the server may still find errors).\nImport Now?"), CBIntText.get("No errors"), 0);
            if (result == 0) {
                return true;
            }
        }
        return false;
    }

    protected void addLdifNormalEntry(LdifEntry newEntry, DataBroker broker) throws NamingException {
        broker.unthreadedModify(null, newEntry);
    }

    protected void addLdifChangeTypeEntry(LdifEntry newEntry, DataBroker broker) throws NamingException {
        broker.unthreadedModify(null, newEntry);
    }

    protected void executeLdifChangeTypeEntry(LdifEntry newEntry, DataBroker broker) throws NamingException {
        newEntry.remove("changetype");
        switch (newEntry.getChangeType()) {
            case add: {
                broker.unthreadedModify(null, newEntry);
                break;
            }
            case delete: {
                broker.unthreadedModify(newEntry, null);
                break;
            }
            case moddn: 
            case modrdn: {
                LdapContext ctx = broker.getLdapContext();
                String newSuperior = newEntry.getString("newsuperior");
                String newRDN = newEntry.getString("newrdn");
                String deleteOldRDN = Boolean.toString(newEntry.getString("deleteoldrdn").equals("1"));
                String newName = newRDN + "," + newSuperior;
                String oldName = newEntry.getStringName();
                ctx.addToEnvironment("java.naming.ldap.deleteRDN", deleteOldRDN);
                ctx.rename(oldName, newName);
                break;
            }
            case modify: {
                LdapContext ctx = broker.getLdapContext();
                try {
                    ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
                    for (DXAttribute att : newEntry.getAttArrayList()) {
                        LdifModifyAttribute modifyAtt = (LdifModifyAttribute)att;
                        Attribute cleanAtt = modifyAtt.getCleanAttribute();
                        switch (modifyAtt.modifyType) {
                            case add: {
                                mods.add(new ModificationItem(1, cleanAtt));
                                break;
                            }
                            case replace: {
                                mods.add(new ModificationItem(2, cleanAtt));
                                break;
                            }
                            case delete: {
                                mods.add(new ModificationItem(3, cleanAtt));
                            }
                        }
                    }
                    ctx.modifyAttributes(newEntry.getDN(), mods.toArray(new ModificationItem[mods.size()]));
                    break;
                }
                catch (ClassCastException e) {
                    newEntry.put("error", CBIntText.get("unexpected internal error parsing modify attributes"));
                }
            }
        }
    }

    protected LdifEntry testLdifChangeEntryImpact(LdifEntry newEntry, DataBroker broker, HashSet<String> addedDNs, HashSet<String> deletedDNs, int lineNumber) throws NamingException {
        DN dn = newEntry.getDN();
        boolean error = false;
        if (broker.unthreadedExists(dn)) {
            switch (newEntry.getChangeType()) {
                case add: {
                    if (!deletedDNs.contains(dn)) {
                        newEntry.put("error", CBIntText.get("Entry already exists!  (Use changetype: modify)"));
                        break;
                    }
                    deletedDNs.remove(dn);
                    break;
                }
                case delete: {
                    DXNamingEnumeration children = broker.unthreadedList(dn);
                    if (children.size() > 0) {
                        while (children.hasMore()) {
                            SearchResult result = (SearchResult)children.nextElement();
                            System.out.println("TESTING: " + result.getName());
                            if (!deletedDNs.contains(new DN(result.getName()))) {
                                // empty if block
                            }
                            error = true;
                            newEntry.put("error", CBIntText.get("Entry has children; delete will fail unless children are deleted first"));
                        }
                    }
                    if (error) break;
                    deletedDNs.add(dn.toString());
                    break;
                }
                case moddn: 
                case modrdn: {
                    DN newDN;
                    String newSuperior = newEntry.getString("newsuperior");
                    String newRDN = newEntry.getString("newrdn");
                    String deleteOldRDN = newEntry.getString("deleteoldrdn");
                    if (newRDN == null) {
                        newEntry.put("error", CBIntText.get("No 'newrdn' or 'newdn' value found in entry"));
                        break;
                    }
                    if (newSuperior == null) {
                        newSuperior = dn.getParent().toString();
                    }
                    if (broker.unthreadedExists(newDN = new DN(newRDN + "," + newSuperior)) || addedDNs.contains(newDN)) {
                        newEntry.put("error", CBIntText.get("new dn already exists: "));
                        break;
                    }
                    addedDNs.add(newDN.toString());
                    deletedDNs.add(dn.toString());
                    break;
                }
                case modify: {
                    LdifEntry existingEntry = new LdifEntry(broker.unthreadedReadEntry(dn, null));
                    block14: for (DXAttribute att : newEntry.getAttArrayList()) {
                        if ("changetype".equals(att.getID())) continue;
                        try {
                            LdifModifyAttribute modifyAtt = (LdifModifyAttribute)att;
                            modifyAtt.remove(0);
                            DXAttribute oldAtt = existingEntry.get(modifyAtt.getID());
                            switch (modifyAtt.modifyType) {
                                case add: {
                                    if (oldAtt == null) break;
                                    if (oldAtt.isSingleValued()) {
                                        newEntry.put("error", CBIntText.get("unable to add to attribute {0} as it is single valued.  (Use 'replace')", new String[]{modifyAtt.getID()}));
                                        break;
                                    }
                                    for (Object o : modifyAtt.getValues()) {
                                        if (!oldAtt.contains(o)) continue;
                                        newEntry.put("error", CBIntText.get("unable to add value {0} from attribute {1} as it already exists", new String[]{o.toString(), modifyAtt.getID()}));
                                    }
                                    continue block14;
                                }
                                case replace: {
                                    if (oldAtt == null || !oldAtt.isSingleValued() || modifyAtt.size() <= 1) break;
                                    newEntry.put("error", CBIntText.get("unable to replace attribute {0} with multiple values as it is single valued.", new String[]{modifyAtt.getID()}));
                                    break;
                                }
                                case delete: {
                                    if (oldAtt == null || oldAtt.size() == 0) {
                                        newEntry.put("error", CBIntText.get("unable to delete attribute {0} as it does not exist", new String[]{modifyAtt.getID()}));
                                        break;
                                    }
                                    for (Object o : modifyAtt.getValues()) {
                                        if (oldAtt.contains(o)) continue;
                                        newEntry.put("error", CBIntText.get("unable to delete value {0} from attribute {1} as it does not exist", new String[]{o.toString(), modifyAtt.getID()}));
                                    }
                                    continue block14;
                                }
                            }
                        }
                        catch (ClassCastException e) {
                            if (att instanceof DXAttribute) {
                                newEntry.put("error", CBIntText.get("attribute {0} does not have a change operation", new String[]{att.getID()}));
                                continue;
                            }
                            newEntry.put("error", CBIntText.get("internal error parsing modify attributes for dn") + " (type: " + att.getClass().toString() + ")");
                        }
                    }
                    break;
                }
            }
        } else if (!broker.unthreadedExists(dn.getParent())) {
            if (!addedDNs.contains(dn.getParent().toString()) && !this.offline) {
                newEntry.put("error", CBIntText.get("Adding Entry without a parent. DN {0} does not exist, and has not yet appeared in LDIF file.", new String[]{dn.getParent().toString()}));
            }
        } else {
            if (newEntry.getChangeType() != LdifEntryType.add) {
                newEntry.put(CBIntText.get("error"), CBIntText.get("Entry does not exist!  (Use changetype: add)"));
            }
            if (addedDNs.contains(dn)) {
                newEntry.put("error", CBIntText.get("new dn already exists"));
            }
        }
        newEntry.put(new DXAttribute("linenumber", lineNumber));
        return newEntry;
    }

    LdifEntry testNormalLdifImpact(DXEntry newEntry, DataBroker broker, HashSet<String> addedDNs, int lineNumber) throws NamingException {
        DN dn = newEntry.getDN();
        LdifEntry ldifEntry = new LdifEntry(dn);
        ldifEntry.put(new DXAttribute("linenumber", lineNumber));
        if (broker.unthreadedExists(dn)) {
            ldifEntry.put("error", CBIntText.get("Entry already exists (use changetype: modify)"));
        } else if (addedDNs != null && addedDNs.contains(dn)) {
            ldifEntry.put("error", CBIntText.get("Entry exists twice in LDIF File"));
        } else if (!broker.unthreadedExists(dn.getParent())) {
            if (!addedDNs.contains(dn.getParent().toString()) && !this.offline) {
                ldifEntry.put("error", CBIntText.get("Adding Entry without a parent. DN {0} does not exist, and has not yet appeared in the LDIF file.", new String[]{dn.getParent().toString()}));
            }
        } else {
            addedDNs.add(dn.toString());
        }
        return ldifEntry;
    }

    LdifEntry getDiff(DXEntry newEntry, DataBroker broker) throws NamingException {
        DN dn = newEntry.getDN();
        LdifEntry ldifEntry = new LdifEntry(dn);
        if (broker.unthreadedExists(dn)) {
            ldifEntry.setChangeType(LdifEntryType.modify);
            DXEntry oldVals = broker.unthreadedReadEntry(dn, null);
            DXAttributes deletions = DXAttributes.getDeletionSet(null, oldVals, newEntry);
            DXAttributes additions = DXAttributes.getAdditionSet(null, oldVals, newEntry);
            DXAttributes replacements = DXAttributes.getReplacementSet(null, oldVals, newEntry);
            for (DXAttribute att : oldVals) {
                DXAttribute deletionAttVals;
                String attributeID = att.getID();
                if (!deletions.contains(attributeID) || (deletionAttVals = deletions.get(attributeID)).size() != att.size()) continue;
                if (additions.contains(attributeID)) {
                    replacements.put(newEntry.get(attributeID));
                    deletions.remove(attributeID);
                    additions.remove(attributeID);
                    continue;
                }
                deletions.remove(attributeID);
                deletions.put(new DXAttribute(attributeID));
            }
            for (DXAttribute addition : additions) {
                ldifEntry.put(new LdifModifyAttribute(addition, LdifModifyType.add));
            }
            for (DXAttribute deletion : deletions) {
                ldifEntry.put(new LdifModifyAttribute(deletion, LdifModifyType.delete));
            }
            for (DXAttribute replacement : replacements) {
                ldifEntry.put(new LdifModifyAttribute(replacement, LdifModifyType.replace));
            }
        } else {
            ldifEntry = new LdifEntry(newEntry);
            ldifEntry.setChangeType(LdifEntryType.add);
        }
        return ldifEntry;
    }

    public void selectAndImportFile() {
        this.importFile(null);
    }

    public void importFile(String fileName) {
        boolean testing = false;
        if (fileName == null) {
            LdifFileChooser chooser = new LdifFileChooser(JXConfig.getProperty("ldif.homeDir"));
            int option = chooser.showOpenDialog(this.owner);
            if (option == 1) {
                return;
            }
            this.readFile = chooser.getSelectedFile();
            JXConfig.setProperty("ldif.homeDir", this.readFile.getParent());
            if (option == 0) {
                testing = true;
            }
        } else {
            this.readFile = new File(fileName);
        }
        this.ldifutil.setFileDir(this.readFile.getParent());
        this.doFileRead(this.readFile, testing);
        if (this.owner instanceof JXplorerBrowser && this.offline) {
            ((JXplorerBrowser)this.owner).getMainMenu().setConnected(false);
        }
    }

    public String getFileName() {
        return this.readFile == null ? "<empty>" : this.readFile.getName();
    }

    protected void doFileRead(File readFile, boolean test) {
        if (readFile == null) {
            CBUtility.error(CBIntText.get("unable to read null LDIF file"), null);
        }
        final File myFile = readFile;
        final boolean testStatus = test;
        DataQuery ldifQuery = new DataQuery(256){

            public ProgressMonitorInputStream getInputStream(File file) {
                try {
                    FileInputStream rawBytes = new FileInputStream(file);
                    pmonitor = new ProgressMonitorInputStream(LdifImport.this.owner, CBIntText.get("Reading LDIF file"), rawBytes);
                }
                catch (FileNotFoundException e) {
                    CBUtility.error(CBIntText.get("Unable to read the LDIF file ''{0}''.", new String[]{myFile.toString()}), e);
                    return null;
                }
                LdifImport.this.ldifutil.resetErrorReportingInformation(myFile.toString());
                return pmonitor;
            }

            @Override
            public void doExtendedRequest(DataBroker dataBroker) {
                pmonitor = this.getInputStream(myFile);
                try {
                    try {
                        if (dataBroker instanceof OfflineDataBroker) {
                            ((OfflineDataBroker)dataBroker).setLdifFile(myFile);
                        }
                    }
                    catch (ClassCastException e) {
                        CBUtility.error("unexpected internal exception reading LDIF file " + e.getMessage());
                    }
                    if (LdifImport.this.readLdifTree(pmonitor, dataBroker, this, testStatus)) {
                        pmonitor = this.getInputStream(myFile);
                        LdifImport.this.readLdifTree(pmonitor, dataBroker, this, false);
                    }
                }
                catch (NamingException e) {
                    CBUtility.error(CBIntText.get("There were one or more errors reading the LDIF file\n(See the log for more details)"), e);
                }
                catch (Exception e) {
                    CBUtility.error(CBIntText.get("There were one or more errors reading the LDIF file\n(See the log for more details)"), e);
                    System.out.println("=== ran CBUtility error code... ====");
                }
                LdifImport.this.closeDown();
            }
        };
        this.dataSource.extendedRequest(ldifQuery);
    }

    protected DN getRoot(DataBroker b, DN lastKnownDN) {
        DN root;
        if (b == null) {
            log.warning("error: no data source available in ldif import/view");
            return null;
        }
        if (lastKnownDN == null) {
            log.warning("error: no DN available in ldif import/view");
            return null;
        }
        DN test = root = lastKnownDN;
        try {
            while (root != null || root.size() > 0) {
                test = root.getParent();
                if (test == null || !b.unthreadedExists(test) || test.size() == 0) {
                    return root;
                }
                root = test;
            }
        }
        catch (NamingException e) {
            log.warning("Error testing root node " + test + "\n" + e);
        }
        log.warning("Unable to determine root node from " + lastKnownDN);
        return null;
    }

    private void closeDown() {
        try {
            if (pmonitor != null) {
                pmonitor.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void translateToUnicode(DXEntry entry) {
        if (!this.offline) {
            return;
        }
        try {
            NamingEnumeration atts = entry.getAll();
            while (atts.hasMoreElements()) {
                DXAttribute att = (DXAttribute)atts.nextElement();
                for (int i = 0; i < att.size(); ++i) {
                    byte[] seq;
                    if (att.get(i) instanceof String || !CBParse.isUTF8(seq = (byte[])att.get(i))) continue;
                    try {
                        String s = new String(seq, "UTF8");
                        att.remove(i);
                        att.add(i, s);
                        att.setString(true);
                        continue;
                    }
                    catch (Exception e) {
                        log.warning("couldn't convert: " + att.getID() + "\n       " + e);
                    }
                }
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    static {
        log = Logger.getLogger(LdifImport.class.getName());
    }
}

