/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.broker;

import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.DataBrokerUnthreadedInterface;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapContext;

public class SchemaDataBroker
extends DataBroker {
    JNDIDataBroker jndiBroker;
    SchemaOps schemaOps;
    private static final Logger log = Logger.getLogger(SchemaDataBroker.class.getName());

    public SchemaDataBroker(JNDIDataBroker jb) {
        this.registerDirectoryConnection(jb);
    }

    public void registerDirectoryConnection(JNDIDataBroker broker) {
        this.jndiBroker = broker;
        this.schemaOps = this.jndiBroker.getSchemaOps();
    }

    @Override
    public DataQuery doExistsQuery(DataQuery request) {
        return request.setException(new Exception("schemaOps exists not yet implemented"));
    }

    @Override
    protected DataQuery doSearchQuery(DataQuery request) {
        return request.setException(new Exception("schemaOps search not allowed"));
    }

    @Override
    protected DataQuery doModifyQuery(DataQuery request) {
        return request.setException(new Exception("schemaOps modification not allowed"));
    }

    @Override
    protected DataQuery doCopyQuery(DataQuery request) {
        return request.setException(new Exception("schemaOps copy not allowed"));
    }

    protected DataQuery doGetAllOCsQuery(DataQuery request) {
        return request.setException(new Exception("schemaOps object class list not allowed"));
    }

    @Override
    protected DataQuery doGetRecOCsQuery(DataQuery request) {
        return request.setException(new Exception("schemaOps rec. object class list not allowed"));
    }

    @Override
    public DXNamingEnumeration unthreadedList(DN searchbase) {
        try {
            if (this.schemaOps == null) {
                return null;
            }
            ArrayList<String> nextLevel = this.schemaOps.listEntryNames(searchbase.toString());
            int size = nextLevel.size();
            for (int i = 0; i < size; ++i) {
                nextLevel.set(i, (String)((Object)new NameClassPair("schema=" + nextLevel.get(i), "schema", false)));
            }
            return new DXNamingEnumeration(nextLevel);
        }
        catch (NamingException e) {
            System.out.println("hurm.");
            return null;
        }
    }

    @Override
    public DXNamingEnumeration unthreadedSearch(DN dn, String filter, int search_level, String[] returnAttributes) {
        return null;
    }

    @Override
    public void unthreadedCopy(DN oldNodeDN, DN newNodeDN) throws NamingException {
        throw new NamingException("unable to modify schema");
    }

    @Override
    public void unthreadedCopyBetweenWindows(DN oldNodeDN, DataBrokerUnthreadedInterface externalDataSource, DN newNodeDN, boolean updateExistingEntries) throws NamingException {
        throw new NamingException("unable to modify schema");
    }

    @Override
    public boolean unthreadedExists(DN checkMe) {
        return false;
    }

    public Vector unthreadedGetAllOCs() {
        return null;
    }

    @Override
    public DXEntry unthreadedReadEntry(DN entryDN, String[] returnAttributes) throws NamingException {
        if (this.schemaOps == null) {
            return null;
        }
        DXEntry returnEntry = new DXEntry(entryDN);
        Attributes atts = this.schemaOps.getAttributes(entryDN.toString());
        if (atts == null || atts.size() == 0) {
            returnEntry = null;
        } else if (returnAttributes == null) {
            returnEntry.put(atts.getAll());
        } else if (returnAttributes.length != 0) {
            log.warning("return of partial schemaOps attributes not implemented - returning all");
            returnEntry.put(atts.getAll());
        }
        return returnEntry;
    }

    @Override
    public void unthreadedModify(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        throw new NamingException("unable to modify schema");
    }

    @Override
    public ArrayList unthreadedGetRecOCs(DN dn) {
        return null;
    }

    @Override
    public LdapContext getLdapContext() throws NamingException {
        return this.jndiBroker.getLdapContext();
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public SchemaOps getSchemaOps() {
        return this.schemaOps;
    }

    @Override
    public String id() {
        return "SchemaDataBroker " + this.id;
    }
}

