/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench;

import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.MainMenu;
import com.pegacat.jxworkbench.JXWBrowser;
import com.pegacat.jxworkbench.JXWCSV;
import com.pegacat.jxworkbench.JXWConWin;
import com.pegacat.jxworkbench.JXWRegister;
import com.pegacat.jxworkbench.JXWReplaceGUI;
import com.pegacat.jxworkbench.JXWVault;
import com.pegacat.jxworkbench.reports.JXWReport;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class JXWMainMenu
extends MainMenu {
    protected JMenuItem register;
    protected JMenuItem vaultKey;
    protected JMenuItem vaultMgr;
    protected JMenuItem vaultClear;
    protected JMenuItem find;
    protected JMenuItem replace;
    protected JMenuItem saveCSV;
    protected JMenuItem loadCSV;
    protected JMenuItem reports;
    protected JMenu workbenchMenu;
    protected JXWBrowser parentBrowser;

    public JXWMainMenu(JXWBrowser browser) {
        super((JXplorerBrowser)browser);
        this.parentBrowser = browser;
        if (this.parentBrowser.isLicenced()) {
            this.setMenuStateToRegistered();
            this.addWorkBenchMenu();
        }
    }

    public void addWorkBenchMenu() {
        this.remove(this.helpMenu);
        this.workbenchMenu = new JMenu(CBIntText.get((String)"Workbench"));
        this.helpMenu.setMnemonic('W');
        this.setupWorkbenchMenu();
        this.add(this.workbenchMenu);
        this.add(this.helpMenu);
    }

    void setMenuStateToRegistered() {
        this.register.setText(CBIntText.get((String)"Unregister"));
        this.register.setToolTipText(CBIntText.get((String)"licenced to user: {0}", (Object[])new String[]{JXConfig.getProperty((String)"licencedUser")}));
    }

    protected void setupFileMenu(JMenu fileMenu) {
        ActionListener workBenchFileListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem src = (JMenuItem)e.getSource();
                if (src == JXWMainMenu.this.register) {
                    JXWMainMenu.this.register();
                }
            }
        };
        this.register = this.setMenuItem(fileMenu, workBenchFileListener, new String[]{CBIntText.get((String)"Upgrade to JXWorkBench"), "1", CBIntText.get((String)"Get the JXWorkBench Enterprise Bundle"), "E", Theme.getInstance().getDirImages() + "blank.gif"});
        this.setMenuItem(fileMenu, workBenchFileListener, new String[]{"-", "", "", ""});
        super.setupFileMenu(fileMenu);
    }

    protected void setupSSLMenu(JMenu sslMenu) {
        super.setupSSLMenu(sslMenu);
    }

    private void register() {
        if (this.parentBrowser.isLicenced()) {
            int response = JOptionPane.showConfirmDialog((Component)((Object)this), CBIntText.get((String)"Remove JXWorkBench Licence and clear passwords?"), CBIntText.get((String)"Deregister JXWorkBench"), 0);
            if (response == 0) {
                JXConfig.setProperty((String)"licencedUser", (String)"", (String)CBIntText.get((String)"this copy of JXW is licenced to this user or company"));
                JXConfig.setProperty((String)"licenceKey", (String)"", (String)CBIntText.get((String)"the JXW licence key"));
                JXConfig.writePropertyFile();
                JXWVault.clearPasswords();
                JOptionPane.showMessageDialog((Component)((Object)this), CBIntText.get((String)"JXWorkBench Licence removed.  Please restart JXplorer."), CBIntText.get((String)"Registration Removed"), 1);
            }
        } else {
            JXWRegister registerDialog = new JXWRegister(this, this.parentBrowser);
            registerDialog.setVisible(true);
        }
    }

    protected void setupWorkbenchMenu() {
        final JXWCSV csvDialog = new JXWCSV(this.parentBrowser);
        final JXWReport report = new JXWReport(this.parentBrowser);
        ActionListener workbenchListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem src = (JMenuItem)e.getSource();
                if (src == JXWMainMenu.this.find) {
                    JXWReplaceGUI replaceDialog = new JXWReplaceGUI(JXWMainMenu.this.browser, true);
                    replaceDialog.setVisible(true);
                } else if (src == JXWMainMenu.this.replace) {
                    JXWReplaceGUI replaceDialog = new JXWReplaceGUI(JXWMainMenu.this.browser, false);
                    replaceDialog.setVisible(true);
                } else if (src == JXWMainMenu.this.saveCSV) {
                    csvDialog.showSaveUI();
                } else if (src == JXWMainMenu.this.loadCSV) {
                    csvDialog.showLoadUI();
                } else if (src == JXWMainMenu.this.vaultMgr) {
                    JXWVault.showVaultManager((Frame)((Object)JXWMainMenu.this.parentBrowser));
                } else if (src == JXWMainMenu.this.vaultKey) {
                    JXWVault.enterVaultKey((Frame)((Object)JXWMainMenu.this.parentBrowser));
                } else if (src == JXWMainMenu.this.vaultClear) {
                    JXWVault.clearVault((Frame)((Object)JXWMainMenu.this.parentBrowser));
                } else if (src == JXWMainMenu.this.reports) {
                    report.showUI();
                }
            }
        };
        this.find = this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{CBIntText.get((String)"Find..."), "f", CBIntText.get((String)"Find text across multiple entries."), "E", Theme.getInstance().getDirImages() + "blank.gif"});
        this.replace = this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{CBIntText.get((String)"Replace..."), "r", CBIntText.get((String)"Do a string replace across multiple entries."), "E", Theme.getInstance().getDirImages() + "blank.gif"});
        this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{"-", "", "", ""});
        this.saveCSV = this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{CBIntText.get((String)"Export CSV"), "", CBIntText.get((String)"Save data as a csv file."), "E", Theme.getInstance().getDirImages() + "blank.gif"});
        this.loadCSV = this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{CBIntText.get((String)"Import CSV"), "", CBIntText.get((String)"Load data from csv file"), "E", Theme.getInstance().getDirImages() + "blank.gif"});
        String vaultState = JXWVault.isEnabled() ? "E" : "D";
        this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{"-", "", "", ""});
        this.vaultKey = this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{CBIntText.get((String)"Enter Vault Key"), "k", CBIntText.get((String)"Enter the key to unlock the PasssWord Vault."), vaultState, Theme.getInstance().getDirImages() + "blank.gif"});
        this.vaultMgr = this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{CBIntText.get((String)"Manage Password Vault"), "v", CBIntText.get((String)"Setup or modify the Password Vault."), "E", Theme.getInstance().getDirImages() + "blank.gif"});
        this.vaultClear = this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{CBIntText.get((String)"Clear Password Vault"), "", CBIntText.get((String)"Delete Password Vault and erase stored passwords."), vaultState, Theme.getInstance().getDirImages() + "blank.gif"});
        JXWVault.registerMenuComponents(this.vaultKey, this.vaultMgr, this.vaultClear);
        this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{"-", "", "", ""});
        this.reports = this.setMenuItem(this.workbenchMenu, workbenchListener, new String[]{CBIntText.get((String)"Run Reports"), "", CBIntText.get((String)"Produce Reports on Directory Data"), "E", Theme.getInstance().getDirImages() + "blank.gif"});
        ButtonRegister br = this.browser.getButtonRegister();
        br.registerItem("ADVANCED_FIND", (Component)this.find);
        br.registerItem("ADVANCED_REPLACE", (Component)this.replace);
    }

    public void connect() {
        if (this.parentBrowser.isLicenced()) {
            CBCache.cleanCache();
            if (this.getConnection == null) {
                this.getConnection = new JXWConWin(this.browser, this.browser.getDisplayLabel(), JXConfig.getProperty((String)"option.ssl.clientcerts"), JXConfig.getProperty((String)"option.ssl.cacerts"), JXConfig.getProperty((String)"option.ldap.referral"), JXConfig.getProperty((String)"option.ldap.searchAliasBehaviour"));
                this.getConnection.setSize(600, 400);
                CBUtility.center((Component)this.getConnection, (Component)this.browser);
            } else {
                this.getConnection.reinit(JXConfig.getProperty((String)"option.ssl.clientcerts"), JXConfig.getProperty((String)"option.ssl.cacerts"), JXConfig.getProperty((String)"option.ldap.referral"), JXConfig.getProperty((String)"option.ldap.searchAliasBehaviour"));
            }
            this.getConnection.resetTitleAndPassword();
            this.getConnection.setVisible(true);
        } else {
            super.connect();
        }
    }
}

