/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBSaveLoadTemplate;
import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.JXplorer;
import com.pegacat.jxworkbench.JXWVault;
import java.awt.Frame;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class JXWSaveLoadTemplate
extends CBSaveLoadTemplate {
    private PasswordStateReporter passwordStateReporter;
    private String quickSavePrefix = "QS.";
    private String vaultPrefix = "VS.";
    private Frame displayFrame;
    private static Logger log = Logger.getLogger(JXWSaveLoadTemplate.class.getName());

    JXWSaveLoadTemplate(String fileName) {
        super(JXplorer.APPLICATION_NAME, fileName);
    }

    public void registerPasswordStateReporter(PasswordStateReporter rep) {
        this.passwordStateReporter = rep;
    }

    public JXWSaveLoadTemplate(String fileName, Frame frame) {
        super(JXplorer.APPLICATION_NAME, fileName);
        this.displayFrame = frame;
    }

    private byte[] gk(String data) throws Exception {
        if (data == null || data.length() == 0) {
            throw new InvalidKeyException("zero length password found");
        }
        if (data.length() < 14) {
            data = "      " + data + "xxxxxxxx";
        }
        return Arrays.copyOf(data.substring(6).getBytes("utf-8"), 8);
    }

    protected String encodePassword(String pwdData, String key) {
        try {
            Cipher c = Cipher.getInstance("Blowfish");
            SecretKeySpec keySpec = new SecretKeySpec(this.gk(key), "Blowfish");
            c.init(1, keySpec);
            byte[] encryptedPassword = c.doFinal(pwdData.getBytes());
            return CBBase64.binaryToString((byte[])encryptedPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String decodePassword(String encodedData, String key) {
        if (encodedData.equals("null")) {
            return null;
        }
        try {
            if (key == null || key.length() == 0) {
                throw new InvalidKeyException("zero length key passed to decodePassword().");
            }
            SecretKeySpec keySpec = new SecretKeySpec(this.gk(key), "Blowfish");
            Cipher c = Cipher.getInstance("Blowfish");
            byte[] encryptedPassword = CBBase64.stringToBinary((String)encodedData);
            c.init(2, keySpec);
            byte[] decryptedPwd = c.doFinal(encryptedPassword);
            return new String(decryptedPwd);
        }
        catch (Exception e) {
            log.severe("CRYPTO EXCEPTION: Unable to decode saved password. (Has the licenced user changed?) " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    protected void recodePasswords(char[] oldPwd, char[] newPwd) {
        Enumeration<Object> keys = this.templates.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String property = this.templates.getProperty(key);
            if (!property.startsWith(this.vaultPrefix) || property.length() <= this.vaultPrefix.length()) continue;
            String pwd = this.decodePassword(property.substring(this.vaultPrefix.length()), new String(oldPwd));
            property = this.vaultPrefix + this.encodePassword(pwd, new String(newPwd));
            this.templates.setProperty(key, property);
        }
        CBUtility.writePropertyFile((String)this.configFile, (Properties)this.templates, (String)"");
    }

    protected void clearAllVaultPasswords() {
        Enumeration<Object> keys = this.templates.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String property = this.templates.getProperty(key);
            if (property.startsWith(this.vaultPrefix) && property.length() > this.vaultPrefix.length()) {
                this.templates.setProperty(key, "");
                continue;
            }
            if (!property.startsWith(this.quickSavePrefix) || property.length() <= this.quickSavePrefix.length()) continue;
            this.templates.setProperty(key, "");
        }
        CBUtility.writePropertyFile((String)this.configFile, (Properties)this.templates, (String)"");
    }

    public PwdHandling getState() {
        return this.passwordStateReporter.getPasswordHandling();
    }

    protected String getPasswordDataToSave(String passwordToSave) {
        String key;
        if (this.getState() == PwdHandling.QUICKSAVE) {
            return this.quickSavePrefix + this.encodePassword(passwordToSave, JXWVault.getMenuItem());
        }
        if (this.getState() == PwdHandling.VAULTSAVE && (key = this.checkVault()) != null) {
            return this.vaultPrefix + this.encodePassword(passwordToSave, key);
        }
        return "";
    }

    protected String getPasswordDataFromLoad(String savedPasswordData) {
        try {
            if (savedPasswordData.startsWith(this.quickSavePrefix)) {
                String pwd = this.decodePassword(savedPasswordData.substring(this.quickSavePrefix.length()), JXWVault.getMenuItem());
                return pwd;
            }
            if (savedPasswordData.startsWith(this.vaultPrefix)) {
                savedPasswordData = savedPasswordData.substring(this.vaultPrefix.length());
                String key = this.checkVault();
                if (key != null) {
                    return this.decodePassword(savedPasswordData, key);
                }
            }
        }
        catch (Exception e) {
            log.fine("unexpected exception parsing password:" + e);
        }
        return null;
    }

    protected String checkVault() {
        if (JXWVault.getKey() != null) {
            return new String(JXWVault.getKey());
        }
        JXWVault.enterVaultKey(this.displayFrame);
        char[] key = JXWVault.getKey();
        if (key == null || key.length == 0) {
            return null;
        }
        return new String(JXWVault.getKey());
    }

    public void save() {
        JXWVault.resetUserRefusedKeyEntry();
        super.save();
    }

    public static enum PwdHandling {
        IGNORE,
        QUICKSAVE,
        VAULTSAVE;

    }

    static interface PasswordStateReporter {
        public PwdHandling getPasswordHandling();
    }
}

