package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyRDSToClickhouseDb invokes the clickhouse.ModifyRDSToClickhouseDb API synchronously
func (client *Client) ModifyRDSToClickhouseDb(request *ModifyRDSToClickhouseDbRequest) (response *ModifyRDSToClickhouseDbResponse, err error) {
	response = CreateModifyRDSToClickhouseDbResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyRDSToClickhouseDbWithChan invokes the clickhouse.ModifyRDSToClickhouseDb API asynchronously
func (client *Client) ModifyRDSToClickhouseDbWithChan(request *ModifyRDSToClickhouseDbRequest) (<-chan *ModifyRDSToClickhouseDbResponse, <-chan error) {
	responseChan := make(chan *ModifyRDSToClickhouseDbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyRDSToClickhouseDb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyRDSToClickhouseDbWithCallback invokes the clickhouse.ModifyRDSToClickhouseDb API asynchronously
func (client *Client) ModifyRDSToClickhouseDbWithCallback(request *ModifyRDSToClickhouseDbRequest, callback func(response *ModifyRDSToClickhouseDbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyRDSToClickhouseDbResponse
		var err error
		defer close(result)
		response, err = client.ModifyRDSToClickhouseDb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyRDSToClickhouseDbRequest is the request struct for api ModifyRDSToClickhouseDb
type ModifyRDSToClickhouseDbRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RdsVpcId             string           `position:"Query" name:"RdsVpcId"`
	CkPassword           string           `position:"Query" name:"CkPassword"`
	RdsSynTables         string           `position:"Query" name:"RdsSynTables"`
	RdsPassword          string           `position:"Query" name:"RdsPassword"`
	CkUserName           string           `position:"Query" name:"CkUserName"`
	RdsSynDb             string           `position:"Query" name:"RdsSynDb"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DbClusterId          string           `position:"Query" name:"DbClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	RdsId                string           `position:"Query" name:"RdsId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ClickhousePort       requests.Integer `position:"Query" name:"ClickhousePort"`
	LimitUpper           requests.Integer `position:"Query" name:"LimitUpper"`
	RdsPort              requests.Integer `position:"Query" name:"RdsPort"`
	SkipUnsupported      requests.Boolean `position:"Query" name:"SkipUnsupported"`
	RdsUserName          string           `position:"Query" name:"RdsUserName"`
}

// ModifyRDSToClickhouseDbResponse is the response struct for api ModifyRDSToClickhouseDb
type ModifyRDSToClickhouseDbResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Status    int64  `json:"Status" xml:"Status"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode int64  `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateModifyRDSToClickhouseDbRequest creates a request to invoke ModifyRDSToClickhouseDb API
func CreateModifyRDSToClickhouseDbRequest() (request *ModifyRDSToClickhouseDbRequest) {
	request = &ModifyRDSToClickhouseDbRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "ModifyRDSToClickhouseDb", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyRDSToClickhouseDbResponse creates a response to parse from ModifyRDSToClickhouseDb response
func CreateModifyRDSToClickhouseDbResponse() (response *ModifyRDSToClickhouseDbResponse) {
	response = &ModifyRDSToClickhouseDbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
