package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveAccountConfig invokes the cloudwf.SaveAccountConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/saveaccountconfig.html
func (client *Client) SaveAccountConfig(request *SaveAccountConfigRequest) (response *SaveAccountConfigResponse, err error) {
	response = CreateSaveAccountConfigResponse()
	err = client.DoAction(request, response)
	return
}

// SaveAccountConfigWithChan invokes the cloudwf.SaveAccountConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveaccountconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveAccountConfigWithChan(request *SaveAccountConfigRequest) (<-chan *SaveAccountConfigResponse, <-chan error) {
	responseChan := make(chan *SaveAccountConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveAccountConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveAccountConfigWithCallback invokes the cloudwf.SaveAccountConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/saveaccountconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SaveAccountConfigWithCallback(request *SaveAccountConfigRequest, callback func(response *SaveAccountConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveAccountConfigResponse
		var err error
		defer close(result)
		response, err = client.SaveAccountConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveAccountConfigRequest is the request struct for api SaveAccountConfig
type SaveAccountConfigRequest struct {
	*requests.RpcRequest
	JsonData string `position:"Query" name:"JsonData"`
}

// SaveAccountConfigResponse is the response struct for api SaveAccountConfig
type SaveAccountConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateSaveAccountConfigRequest creates a request to invoke SaveAccountConfig API
func CreateSaveAccountConfigRequest() (request *SaveAccountConfigRequest) {
	request = &SaveAccountConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "SaveAccountConfig", "cloudwf", "openAPI")
	return
}

// CreateSaveAccountConfigResponse creates a response to parse from SaveAccountConfig response
func CreateSaveAccountConfigResponse() (response *SaveAccountConfigResponse) {
	response = &SaveAccountConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
