package dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserGatewayInstances invokes the dg.GetUserGatewayInstances API synchronously
func (client *Client) GetUserGatewayInstances(request *GetUserGatewayInstancesRequest) (response *GetUserGatewayInstancesResponse, err error) {
	response = CreateGetUserGatewayInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserGatewayInstancesWithChan invokes the dg.GetUserGatewayInstances API asynchronously
func (client *Client) GetUserGatewayInstancesWithChan(request *GetUserGatewayInstancesRequest) (<-chan *GetUserGatewayInstancesResponse, <-chan error) {
	responseChan := make(chan *GetUserGatewayInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserGatewayInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserGatewayInstancesWithCallback invokes the dg.GetUserGatewayInstances API asynchronously
func (client *Client) GetUserGatewayInstancesWithCallback(request *GetUserGatewayInstancesRequest, callback func(response *GetUserGatewayInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserGatewayInstancesResponse
		var err error
		defer close(result)
		response, err = client.GetUserGatewayInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserGatewayInstancesRequest is the request struct for api GetUserGatewayInstances
type GetUserGatewayInstancesRequest struct {
	*requests.RpcRequest
	GatewayId string `position:"Body" name:"GatewayId"`
}

// GetUserGatewayInstancesResponse is the response struct for api GetUserGatewayInstances
type GetUserGatewayInstancesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetUserGatewayInstancesRequest creates a request to invoke GetUserGatewayInstances API
func CreateGetUserGatewayInstancesRequest() (request *GetUserGatewayInstancesRequest) {
	request = &GetUserGatewayInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dg", "2019-03-27", "GetUserGatewayInstances", "dg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetUserGatewayInstancesResponse creates a response to parse from GetUserGatewayInstances response
func CreateGetUserGatewayInstancesResponse() (response *GetUserGatewayInstancesResponse) {
	response = &GetUserGatewayInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
