package faas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFpgaImage invokes the faas.AddFpgaImage API synchronously
// api document: https://help.aliyun.com/api/faas/addfpgaimage.html
func (client *Client) AddFpgaImage(request *AddFpgaImageRequest) (response *AddFpgaImageResponse, err error) {
	response = CreateAddFpgaImageResponse()
	err = client.DoAction(request, response)
	return
}

// AddFpgaImageWithChan invokes the faas.AddFpgaImage API asynchronously
// api document: https://help.aliyun.com/api/faas/addfpgaimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddFpgaImageWithChan(request *AddFpgaImageRequest) (<-chan *AddFpgaImageResponse, <-chan error) {
	responseChan := make(chan *AddFpgaImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFpgaImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFpgaImageWithCallback invokes the faas.AddFpgaImage API asynchronously
// api document: https://help.aliyun.com/api/faas/addfpgaimage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddFpgaImageWithCallback(request *AddFpgaImageRequest, callback func(response *AddFpgaImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFpgaImageResponse
		var err error
		defer close(result)
		response, err = client.AddFpgaImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFpgaImageRequest is the request struct for api AddFpgaImage
type AddFpgaImageRequest struct {
	*requests.RpcRequest
	CloudType           string `position:"Query" name:"CloudType"`
	KeyId               string `position:"Query" name:"KeyId"`
	Description         string `position:"Query" name:"Description"`
	FpgaImageTags       string `position:"Query" name:"FpgaImageTags"`
	OwnerId             string `position:"Query" name:"OwnerId"`
	ShellUniqueId       string `position:"Query" name:"ShellUniqueId"`
	Encryption          string `position:"Query" name:"Encryption"`
	FpgaImageName       string `position:"Query" name:"FpgaImageName"`
	FpgaImageUniqueId   string `position:"Query" name:"FpgaImageUniqueId"`
	FpgaImageObjectName string `position:"Query" name:"FpgaImageObjectName"`
	FpgaImageTime       string `position:"Query" name:"FpgaImageTime"`
}

// AddFpgaImageResponse is the response struct for api AddFpgaImage
type AddFpgaImageResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	FpgaImageUniqueId string `json:"FpgaImageUniqueId" xml:"FpgaImageUniqueId"`
	CreateTime        string `json:"CreateTime" xml:"CreateTime"`
	Description       string `json:"Description" xml:"Description"`
	ShellUniqueId     string `json:"ShellUniqueId" xml:"ShellUniqueId"`
	State             string `json:"State" xml:"State"`
}

// CreateAddFpgaImageRequest creates a request to invoke AddFpgaImage API
func CreateAddFpgaImageRequest() (request *AddFpgaImageRequest) {
	request = &AddFpgaImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("faas", "2020-02-17", "AddFpgaImage", "faas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddFpgaImageResponse creates a response to parse from AddFpgaImage response
func CreateAddFpgaImageResponse() (response *AddFpgaImageResponse) {
	response = &AddFpgaImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
