// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) Go Code Generator. DO NOT EDIT.

package azkeys

import (
	"context"
	"errors"
	"net/http"
	"net/url"
	"strings"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

// Client - The key vault client performs cryptographic key operations and vault operations against the Key Vault service.
// Don't use this type directly, use a constructor function instead.
type Client struct {
	internal     *azcore.Client
	vaultBaseUrl string
}

// BackupKey - Requests that a backup of the specified key be downloaded to the client.
//
// The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this operation does NOT return
// key material in a form that can be used outside the Azure Key Vault system, the returned key material is either protected
// to a Azure Key Vault HSM or to Azure Key Vault itself. The intent of this operation is to allow a client to GENERATE a
// key in one Azure Key Vault instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance. The BACKUP
// operation may be used to export, in protected form, any key type from Azure Key Vault. Individual versions of a key cannot
// be backed up. BACKUP / RESTORE can be performed within geographical boundaries only; meaning that a BACKUP from one geographical
// area cannot be restored to another geographical area. For example, a backup from the US geographical area cannot be restored
// in an EU geographical area. This operation requires the key/backup permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key.
//   - options - BackupKeyOptions contains the optional parameters for the Client.BackupKey method.
func (client *Client) BackupKey(ctx context.Context, name string, options *BackupKeyOptions) (BackupKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.BackupKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.backupKeyCreateRequest(ctx, name, options)
	if err != nil {
		return BackupKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return BackupKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return BackupKeyResponse{}, err
	}
	resp, err := client.backupKeyHandleResponse(httpResp)
	return resp, err
}

// backupKeyCreateRequest creates the BackupKey request.
func (client *Client) backupKeyCreateRequest(ctx context.Context, name string, _ *BackupKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/backup"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// backupKeyHandleResponse handles the BackupKey response.
func (client *Client) backupKeyHandleResponse(resp *http.Response) (BackupKeyResponse, error) {
	result := BackupKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.BackupKeyResult); err != nil {
		return BackupKeyResponse{}, err
	}
	return result, nil
}

// CreateKey - Creates a new key, stores it, then returns key parameters and attributes to the client.
//
// The create key operation can be used to create any key type in Azure Key Vault. If the named key already exists, Azure
// Key Vault creates a new version of the key. It requires the keys/create permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name for the new key. The system will generate the version name for the new key. The value you provide may be
//     copied globally for the purpose of running the service. The value provided should not include personally identifiable or
//     sensitive information.
//   - parameters - The parameters to create a key.
//   - options - CreateKeyOptions contains the optional parameters for the Client.CreateKey method.
func (client *Client) CreateKey(ctx context.Context, name string, parameters CreateKeyParameters, options *CreateKeyOptions) (CreateKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.CreateKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createKeyCreateRequest(ctx, name, parameters, options)
	if err != nil {
		return CreateKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return CreateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return CreateKeyResponse{}, err
	}
	resp, err := client.createKeyHandleResponse(httpResp)
	return resp, err
}

// createKeyCreateRequest creates the CreateKey request.
func (client *Client) createKeyCreateRequest(ctx context.Context, name string, parameters CreateKeyParameters, _ *CreateKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/create"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createKeyHandleResponse handles the CreateKey response.
func (client *Client) createKeyHandleResponse(resp *http.Response) (CreateKeyResponse, error) {
	result := CreateKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return CreateKeyResponse{}, err
	}
	return result, nil
}

// Decrypt - Decrypts a single block of encrypted data.
//
// The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption key and specified algorithm.
// This operation is the reverse of the ENCRYPT operation; only a single block of data may be decrypted, the size of this
// block is dependent on the target key and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric
// keys stored in Azure Key Vault since it uses the private portion of the key. This operation requires the keys/decrypt permission.
// Microsoft recommends not to use CBC algorithms for decryption without first ensuring the integrity of the ciphertext using
// an HMAC, for example. See https://docs.microsoft.com/dotnet/standard/security/vulnerabilities-cbc-mode for more information.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for the decryption operation.
//   - options - DecryptOptions contains the optional parameters for the Client.Decrypt method.
func (client *Client) Decrypt(ctx context.Context, name string, version string, parameters KeyOperationParameters, options *DecryptOptions) (DecryptResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.Decrypt", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.decryptCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return DecryptResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DecryptResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DecryptResponse{}, err
	}
	resp, err := client.decryptHandleResponse(httpResp)
	return resp, err
}

// decryptCreateRequest creates the Decrypt request.
func (client *Client) decryptCreateRequest(ctx context.Context, name string, version string, parameters KeyOperationParameters, _ *DecryptOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/{key-version}/decrypt"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// decryptHandleResponse handles the Decrypt response.
func (client *Client) decryptHandleResponse(resp *http.Response) (DecryptResponse, error) {
	result := DecryptResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return DecryptResponse{}, err
	}
	return result, nil
}

// DeleteKey - Deletes a key of any type from storage in Azure Key Vault.
//
// The delete key operation cannot be used to remove individual versions of a key. This operation removes the cryptographic
// material associated with the key, which means the key is not usable for Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations.
// This operation requires the keys/delete permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key to delete.
//   - options - DeleteKeyOptions contains the optional parameters for the Client.DeleteKey method.
func (client *Client) DeleteKey(ctx context.Context, name string, options *DeleteKeyOptions) (DeleteKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.DeleteKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteKeyCreateRequest(ctx, name, options)
	if err != nil {
		return DeleteKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DeleteKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DeleteKeyResponse{}, err
	}
	resp, err := client.deleteKeyHandleResponse(httpResp)
	return resp, err
}

// deleteKeyCreateRequest creates the DeleteKey request.
func (client *Client) deleteKeyCreateRequest(ctx context.Context, name string, _ *DeleteKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// deleteKeyHandleResponse handles the DeleteKey response.
func (client *Client) deleteKeyHandleResponse(resp *http.Response) (DeleteKeyResponse, error) {
	result := DeleteKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedKey); err != nil {
		return DeleteKeyResponse{}, err
	}
	return result, nil
}

// Encrypt - Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.
//
// The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is stored in Azure Key Vault.
// Note that the ENCRYPT operation only supports a single block of data, the size of which is dependent on the target key
// and the encryption algorithm to be used. The ENCRYPT operation is only strictly necessary for symmetric keys stored in
// Azure Key Vault since protection with an asymmetric key can be performed using public portion of the key. This operation
// is supported for asymmetric keys as a convenience for callers that have a key-reference but do not have access to the public
// key material. This operation requires the keys/encrypt permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for the encryption operation.
//   - options - EncryptOptions contains the optional parameters for the Client.Encrypt method.
func (client *Client) Encrypt(ctx context.Context, name string, version string, parameters KeyOperationParameters, options *EncryptOptions) (EncryptResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.Encrypt", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.encryptCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return EncryptResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return EncryptResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return EncryptResponse{}, err
	}
	resp, err := client.encryptHandleResponse(httpResp)
	return resp, err
}

// encryptCreateRequest creates the Encrypt request.
func (client *Client) encryptCreateRequest(ctx context.Context, name string, version string, parameters KeyOperationParameters, _ *EncryptOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/{key-version}/encrypt"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// encryptHandleResponse handles the Encrypt response.
func (client *Client) encryptHandleResponse(resp *http.Response) (EncryptResponse, error) {
	result := EncryptResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return EncryptResponse{}, err
	}
	return result, nil
}

// GetDeletedKey - Gets the public part of a deleted key.
//
// The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any vault,
// it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key.
//   - options - GetDeletedKeyOptions contains the optional parameters for the Client.GetDeletedKey method.
func (client *Client) GetDeletedKey(ctx context.Context, name string, options *GetDeletedKeyOptions) (GetDeletedKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.GetDeletedKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getDeletedKeyCreateRequest(ctx, name, options)
	if err != nil {
		return GetDeletedKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetDeletedKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetDeletedKeyResponse{}, err
	}
	resp, err := client.getDeletedKeyHandleResponse(httpResp)
	return resp, err
}

// getDeletedKeyCreateRequest creates the GetDeletedKey request.
func (client *Client) getDeletedKeyCreateRequest(ctx context.Context, name string, _ *GetDeletedKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/deletedkeys/{key-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getDeletedKeyHandleResponse handles the GetDeletedKey response.
func (client *Client) getDeletedKeyHandleResponse(resp *http.Response) (GetDeletedKeyResponse, error) {
	result := GetDeletedKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedKey); err != nil {
		return GetDeletedKeyResponse{}, err
	}
	return result, nil
}

// GetKey - Gets the public part of a stored key.
//
// The get key operation is applicable to all key types. If the requested key is symmetric, then no key material is released
// in the response. This operation requires the keys/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key to get.
//   - version - Adding the version parameter retrieves a specific version of a key. This URI fragment is optional. If not specified,
//     the latest version of the key is returned.
//   - options - GetKeyOptions contains the optional parameters for the Client.GetKey method.
func (client *Client) GetKey(ctx context.Context, name string, version string, options *GetKeyOptions) (GetKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.GetKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getKeyCreateRequest(ctx, name, version, options)
	if err != nil {
		return GetKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetKeyResponse{}, err
	}
	resp, err := client.getKeyHandleResponse(httpResp)
	return resp, err
}

// getKeyCreateRequest creates the GetKey request.
func (client *Client) getKeyCreateRequest(ctx context.Context, name string, version string, _ *GetKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/{key-version}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getKeyHandleResponse handles the GetKey response.
func (client *Client) getKeyHandleResponse(resp *http.Response) (GetKeyResponse, error) {
	result := GetKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return GetKeyResponse{}, err
	}
	return result, nil
}

// GetKeyRotationPolicy - Lists the policy for a key.
//
// The GetKeyRotationPolicy operation returns the specified key policy resources in the specified key vault. This operation
// requires the keys/get permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key in a given key vault.
//   - options - GetKeyRotationPolicyOptions contains the optional parameters for the Client.GetKeyRotationPolicy method.
func (client *Client) GetKeyRotationPolicy(ctx context.Context, name string, options *GetKeyRotationPolicyOptions) (GetKeyRotationPolicyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.GetKeyRotationPolicy", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getKeyRotationPolicyCreateRequest(ctx, name, options)
	if err != nil {
		return GetKeyRotationPolicyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetKeyRotationPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetKeyRotationPolicyResponse{}, err
	}
	resp, err := client.getKeyRotationPolicyHandleResponse(httpResp)
	return resp, err
}

// getKeyRotationPolicyCreateRequest creates the GetKeyRotationPolicy request.
func (client *Client) getKeyRotationPolicyCreateRequest(ctx context.Context, name string, _ *GetKeyRotationPolicyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/rotationpolicy"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getKeyRotationPolicyHandleResponse handles the GetKeyRotationPolicy response.
func (client *Client) getKeyRotationPolicyHandleResponse(resp *http.Response) (GetKeyRotationPolicyResponse, error) {
	result := GetKeyRotationPolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyRotationPolicy); err != nil {
		return GetKeyRotationPolicyResponse{}, err
	}
	return result, nil
}

// GetRandomBytes - Get the requested number of bytes containing random values.
//
// Get the requested number of bytes containing random values from a managed HSM.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - parameters - The request object to get random bytes.
//   - options - GetRandomBytesOptions contains the optional parameters for the Client.GetRandomBytes method.
func (client *Client) GetRandomBytes(ctx context.Context, parameters GetRandomBytesParameters, options *GetRandomBytesOptions) (GetRandomBytesResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.GetRandomBytes", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getRandomBytesCreateRequest(ctx, parameters, options)
	if err != nil {
		return GetRandomBytesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GetRandomBytesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GetRandomBytesResponse{}, err
	}
	resp, err := client.getRandomBytesHandleResponse(httpResp)
	return resp, err
}

// getRandomBytesCreateRequest creates the GetRandomBytes request.
func (client *Client) getRandomBytesCreateRequest(ctx context.Context, parameters GetRandomBytesParameters, _ *GetRandomBytesOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/rng"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// getRandomBytesHandleResponse handles the GetRandomBytes response.
func (client *Client) getRandomBytesHandleResponse(resp *http.Response) (GetRandomBytesResponse, error) {
	result := GetRandomBytesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RandomBytes); err != nil {
		return GetRandomBytesResponse{}, err
	}
	return result, nil
}

// ImportKey - Imports an externally created key, stores it, and returns key parameters and attributes to the client.
//
// The import key operation may be used to import any key type into an Azure Key Vault. If the named key already exists, Azure
// Key Vault creates a new version of the key. This operation requires the keys/import permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - Name for the imported key. The value you provide may be copied globally for the purpose of running the service.
//     The value provided should not include personally identifiable or sensitive information.
//   - parameters - The parameters to import a key.
//   - options - ImportKeyOptions contains the optional parameters for the Client.ImportKey method.
func (client *Client) ImportKey(ctx context.Context, name string, parameters ImportKeyParameters, options *ImportKeyOptions) (ImportKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.ImportKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.importKeyCreateRequest(ctx, name, parameters, options)
	if err != nil {
		return ImportKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ImportKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ImportKeyResponse{}, err
	}
	resp, err := client.importKeyHandleResponse(httpResp)
	return resp, err
}

// importKeyCreateRequest creates the ImportKey request.
func (client *Client) importKeyCreateRequest(ctx context.Context, name string, parameters ImportKeyParameters, _ *ImportKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// importKeyHandleResponse handles the ImportKey response.
func (client *Client) importKeyHandleResponse(resp *http.Response) (ImportKeyResponse, error) {
	result := ImportKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return ImportKeyResponse{}, err
	}
	return result, nil
}

// NewListDeletedKeyPropertiesPager - Lists the deleted keys in the specified vault.
//
// Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a deleted key.
// This operation includes deletion-specific information. The Get Deleted Keys operation is applicable for vaults enabled
// for soft-delete. While the operation can be invoked on any vault, it will return an error if invoked on a non soft-delete
// enabled vault. This operation requires the keys/list permission.
//
// Generated from API version 7.5
//   - options - ListDeletedKeyPropertiesOptions contains the optional parameters for the Client.NewListDeletedKeyPropertiesPager
//     method.
func (client *Client) NewListDeletedKeyPropertiesPager(options *ListDeletedKeyPropertiesOptions) *runtime.Pager[ListDeletedKeyPropertiesResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListDeletedKeyPropertiesResponse]{
		More: func(page ListDeletedKeyPropertiesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListDeletedKeyPropertiesResponse) (ListDeletedKeyPropertiesResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listDeletedKeyPropertiesCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ListDeletedKeyPropertiesResponse{}, err
			}
			return client.listDeletedKeyPropertiesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listDeletedKeyPropertiesCreateRequest creates the ListDeletedKeyProperties request.
func (client *Client) listDeletedKeyPropertiesCreateRequest(ctx context.Context, options *ListDeletedKeyPropertiesOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/deletedkeys"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listDeletedKeyPropertiesHandleResponse handles the ListDeletedKeyProperties response.
func (client *Client) listDeletedKeyPropertiesHandleResponse(resp *http.Response) (ListDeletedKeyPropertiesResponse, error) {
	result := ListDeletedKeyPropertiesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DeletedKeyPropertiesListResult); err != nil {
		return ListDeletedKeyPropertiesResponse{}, err
	}
	return result, nil
}

// NewListKeyPropertiesPager - List keys in the specified vault.
//
// Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the public part of a stored key.
// The LIST operation is applicable to all key types, however only the base key identifier, attributes, and tags are provided
// in the response. Individual versions of a key are not listed in the response. This operation requires the keys/list permission.
//
// Generated from API version 7.5
//   - options - ListKeyPropertiesOptions contains the optional parameters for the Client.NewListKeyPropertiesPager method.
func (client *Client) NewListKeyPropertiesPager(options *ListKeyPropertiesOptions) *runtime.Pager[ListKeyPropertiesResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListKeyPropertiesResponse]{
		More: func(page ListKeyPropertiesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListKeyPropertiesResponse) (ListKeyPropertiesResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listKeyPropertiesCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return ListKeyPropertiesResponse{}, err
			}
			return client.listKeyPropertiesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listKeyPropertiesCreateRequest creates the ListKeyProperties request.
func (client *Client) listKeyPropertiesCreateRequest(ctx context.Context, options *ListKeyPropertiesOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listKeyPropertiesHandleResponse handles the ListKeyProperties response.
func (client *Client) listKeyPropertiesHandleResponse(resp *http.Response) (ListKeyPropertiesResponse, error) {
	result := ListKeyPropertiesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyPropertiesListResult); err != nil {
		return ListKeyPropertiesResponse{}, err
	}
	return result, nil
}

// NewListKeyPropertiesVersionsPager - Retrieves a list of individual key versions with the same key name.
//
// The full key identifier, attributes, and tags are provided in the response. This operation requires the keys/list permission.
//
// Generated from API version 7.5
//   - name - The name of the key.
//   - options - ListKeyPropertiesVersionsOptions contains the optional parameters for the Client.NewListKeyPropertiesVersionsPager
//     method.
func (client *Client) NewListKeyPropertiesVersionsPager(name string, options *ListKeyPropertiesVersionsOptions) *runtime.Pager[ListKeyPropertiesVersionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ListKeyPropertiesVersionsResponse]{
		More: func(page ListKeyPropertiesVersionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ListKeyPropertiesVersionsResponse) (ListKeyPropertiesVersionsResponse, error) {
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listKeyPropertiesVersionsCreateRequest(ctx, name, options)
			}, nil)
			if err != nil {
				return ListKeyPropertiesVersionsResponse{}, err
			}
			return client.listKeyPropertiesVersionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listKeyPropertiesVersionsCreateRequest creates the ListKeyPropertiesVersions request.
func (client *Client) listKeyPropertiesVersionsCreateRequest(ctx context.Context, name string, options *ListKeyPropertiesVersionsOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/versions"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listKeyPropertiesVersionsHandleResponse handles the ListKeyPropertiesVersions response.
func (client *Client) listKeyPropertiesVersionsHandleResponse(resp *http.Response) (ListKeyPropertiesVersionsResponse, error) {
	result := ListKeyPropertiesVersionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyPropertiesListResult); err != nil {
		return ListKeyPropertiesVersionsResponse{}, err
	}
	return result, nil
}

// PurgeDeletedKey - Permanently deletes the specified key.
//
// The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the operation can be invoked on any
// vault, it will return an error if invoked on a non soft-delete enabled vault. This operation requires the keys/purge permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key
//   - options - PurgeDeletedKeyOptions contains the optional parameters for the Client.PurgeDeletedKey method.
func (client *Client) PurgeDeletedKey(ctx context.Context, name string, options *PurgeDeletedKeyOptions) (PurgeDeletedKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.PurgeDeletedKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.purgeDeletedKeyCreateRequest(ctx, name, options)
	if err != nil {
		return PurgeDeletedKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PurgeDeletedKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return PurgeDeletedKeyResponse{}, err
	}
	return PurgeDeletedKeyResponse{}, nil
}

// purgeDeletedKeyCreateRequest creates the PurgeDeletedKey request.
func (client *Client) purgeDeletedKeyCreateRequest(ctx context.Context, name string, _ *PurgeDeletedKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/deletedkeys/{key-name}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RecoverDeletedKey - Recovers the deleted key to its latest version.
//
// The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults. It recovers the deleted
// key back to its latest version under /keys. An attempt to recover an non-deleted key will return an error. Consider this
// the inverse of the delete operation on soft-delete enabled vaults. This operation requires the keys/recover permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the deleted key.
//   - options - RecoverDeletedKeyOptions contains the optional parameters for the Client.RecoverDeletedKey method.
func (client *Client) RecoverDeletedKey(ctx context.Context, name string, options *RecoverDeletedKeyOptions) (RecoverDeletedKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.RecoverDeletedKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.recoverDeletedKeyCreateRequest(ctx, name, options)
	if err != nil {
		return RecoverDeletedKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RecoverDeletedKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RecoverDeletedKeyResponse{}, err
	}
	resp, err := client.recoverDeletedKeyHandleResponse(httpResp)
	return resp, err
}

// recoverDeletedKeyCreateRequest creates the RecoverDeletedKey request.
func (client *Client) recoverDeletedKeyCreateRequest(ctx context.Context, name string, _ *RecoverDeletedKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/deletedkeys/{key-name}/recover"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// recoverDeletedKeyHandleResponse handles the RecoverDeletedKey response.
func (client *Client) recoverDeletedKeyHandleResponse(resp *http.Response) (RecoverDeletedKeyResponse, error) {
	result := RecoverDeletedKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return RecoverDeletedKeyResponse{}, err
	}
	return result, nil
}

// Release - Releases a key.
//
// The release key operation is applicable to all key types. The target key must be marked exportable. This operation requires
// the keys/release permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key to get.
//   - version - Adding the version parameter retrieves a specific version of a key.
//   - parameters - The parameters for the key release operation.
//   - options - ReleaseOptions contains the optional parameters for the Client.Release method.
func (client *Client) Release(ctx context.Context, name string, version string, parameters ReleaseParameters, options *ReleaseOptions) (ReleaseResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.Release", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.releaseCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return ReleaseResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ReleaseResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ReleaseResponse{}, err
	}
	resp, err := client.releaseHandleResponse(httpResp)
	return resp, err
}

// releaseCreateRequest creates the Release request.
func (client *Client) releaseCreateRequest(ctx context.Context, name string, version string, parameters ReleaseParameters, _ *ReleaseOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/{key-version}/release"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// releaseHandleResponse handles the Release response.
func (client *Client) releaseHandleResponse(resp *http.Response) (ReleaseResponse, error) {
	result := ReleaseResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyReleaseResult); err != nil {
		return ReleaseResponse{}, err
	}
	return result, nil
}

// RestoreKey - Restores a backed up key to a vault.
//
// Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier, attributes and access control
// policies. The RESTORE operation may be used to import a previously backed up key. Individual versions of a key cannot be
// restored. The key is restored in its entirety with the same key name as it had when it was backed up. If the key name is
// not available in the target Key Vault, the RESTORE operation will be rejected. While the key name is retained during restore,
// the final key identifier will change if the key is restored to a different vault. Restore will restore all versions and
// preserve version identifiers. The RESTORE operation is subject to security constraints: The target Key Vault must be owned
// by the same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission in the target Key
// Vault. This operation requires the keys/restore permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - parameters - The parameters to restore the key.
//   - options - RestoreKeyOptions contains the optional parameters for the Client.RestoreKey method.
func (client *Client) RestoreKey(ctx context.Context, parameters RestoreKeyParameters, options *RestoreKeyOptions) (RestoreKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.RestoreKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.restoreKeyCreateRequest(ctx, parameters, options)
	if err != nil {
		return RestoreKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RestoreKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RestoreKeyResponse{}, err
	}
	resp, err := client.restoreKeyHandleResponse(httpResp)
	return resp, err
}

// restoreKeyCreateRequest creates the RestoreKey request.
func (client *Client) restoreKeyCreateRequest(ctx context.Context, parameters RestoreKeyParameters, _ *RestoreKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/restore"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// restoreKeyHandleResponse handles the RestoreKey response.
func (client *Client) restoreKeyHandleResponse(resp *http.Response) (RestoreKeyResponse, error) {
	result := RestoreKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return RestoreKeyResponse{}, err
	}
	return result, nil
}

// RotateKey - Creates a new key version, stores it, then returns key parameters, attributes and policy to the client.
//
// The operation will rotate the key based on the key policy. It requires the keys/rotate permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of key to be rotated. The system will generate a new version in the specified key.
//   - options - RotateKeyOptions contains the optional parameters for the Client.RotateKey method.
func (client *Client) RotateKey(ctx context.Context, name string, options *RotateKeyOptions) (RotateKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.RotateKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.rotateKeyCreateRequest(ctx, name, options)
	if err != nil {
		return RotateKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RotateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RotateKeyResponse{}, err
	}
	resp, err := client.rotateKeyHandleResponse(httpResp)
	return resp, err
}

// rotateKeyCreateRequest creates the RotateKey request.
func (client *Client) rotateKeyCreateRequest(ctx context.Context, name string, _ *RotateKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/rotate"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// rotateKeyHandleResponse handles the RotateKey response.
func (client *Client) rotateKeyHandleResponse(resp *http.Response) (RotateKeyResponse, error) {
	result := RotateKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return RotateKeyResponse{}, err
	}
	return result, nil
}

// Sign - Creates a signature from a digest using the specified key.
//
// The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault since this operation uses the
// private portion of the key. This operation requires the keys/sign permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for the signing operation.
//   - options - SignOptions contains the optional parameters for the Client.Sign method.
func (client *Client) Sign(ctx context.Context, name string, version string, parameters SignParameters, options *SignOptions) (SignResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.Sign", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.signCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return SignResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SignResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SignResponse{}, err
	}
	resp, err := client.signHandleResponse(httpResp)
	return resp, err
}

// signCreateRequest creates the Sign request.
func (client *Client) signCreateRequest(ctx context.Context, name string, version string, parameters SignParameters, _ *SignOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/{key-version}/sign"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// signHandleResponse handles the Sign response.
func (client *Client) signHandleResponse(resp *http.Response) (SignResponse, error) {
	result := SignResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return SignResponse{}, err
	}
	return result, nil
}

// UnwrapKey - Unwraps a symmetric key using the specified key that was initially used for wrapping that key.
//
// The UNWRAP operation supports decryption of a symmetric key using the target key encryption key. This operation is the
// reverse of the WRAP operation. The UNWRAP operation applies to asymmetric and symmetric keys stored in Azure Key Vault
// since it uses the private portion of the key. This operation requires the keys/unwrapKey permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for the key operation.
//   - options - UnwrapKeyOptions contains the optional parameters for the Client.UnwrapKey method.
func (client *Client) UnwrapKey(ctx context.Context, name string, version string, parameters KeyOperationParameters, options *UnwrapKeyOptions) (UnwrapKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.UnwrapKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.unwrapKeyCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return UnwrapKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UnwrapKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UnwrapKeyResponse{}, err
	}
	resp, err := client.unwrapKeyHandleResponse(httpResp)
	return resp, err
}

// unwrapKeyCreateRequest creates the UnwrapKey request.
func (client *Client) unwrapKeyCreateRequest(ctx context.Context, name string, version string, parameters KeyOperationParameters, _ *UnwrapKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/{key-version}/unwrapkey"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// unwrapKeyHandleResponse handles the UnwrapKey response.
func (client *Client) unwrapKeyHandleResponse(resp *http.Response) (UnwrapKeyResponse, error) {
	result := UnwrapKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return UnwrapKeyResponse{}, err
	}
	return result, nil
}

// UpdateKey - The update key operation changes specified attributes of a stored key and can be applied to any key type and
// key version stored in Azure Key Vault.
//
// In order to perform this operation, the key must already exist in the Key Vault. Note: The cryptographic material of a
// key itself cannot be changed. This operation requires the keys/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of key to update.
//   - version - The version of the key to update.
//   - parameters - The parameters of the key to update.
//   - options - UpdateKeyOptions contains the optional parameters for the Client.UpdateKey method.
func (client *Client) UpdateKey(ctx context.Context, name string, version string, parameters UpdateKeyParameters, options *UpdateKeyOptions) (UpdateKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.UpdateKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateKeyCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return UpdateKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateKeyResponse{}, err
	}
	resp, err := client.updateKeyHandleResponse(httpResp)
	return resp, err
}

// updateKeyCreateRequest creates the UpdateKey request.
func (client *Client) updateKeyCreateRequest(ctx context.Context, name string, version string, parameters UpdateKeyParameters, _ *UpdateKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/{key-version}"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// updateKeyHandleResponse handles the UpdateKey response.
func (client *Client) updateKeyHandleResponse(resp *http.Response) (UpdateKeyResponse, error) {
	result := UpdateKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyBundle); err != nil {
		return UpdateKeyResponse{}, err
	}
	return result, nil
}

// UpdateKeyRotationPolicy - Updates the rotation policy for a key.
//
// Set specified members in the key policy. Leave others as undefined. This operation requires the keys/update permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key in the given vault.
//   - keyRotationPolicy - The policy for the key.
//   - options - UpdateKeyRotationPolicyOptions contains the optional parameters for the Client.UpdateKeyRotationPolicy method.
func (client *Client) UpdateKeyRotationPolicy(ctx context.Context, name string, keyRotationPolicy KeyRotationPolicy, options *UpdateKeyRotationPolicyOptions) (UpdateKeyRotationPolicyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.UpdateKeyRotationPolicy", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateKeyRotationPolicyCreateRequest(ctx, name, keyRotationPolicy, options)
	if err != nil {
		return UpdateKeyRotationPolicyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return UpdateKeyRotationPolicyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return UpdateKeyRotationPolicyResponse{}, err
	}
	resp, err := client.updateKeyRotationPolicyHandleResponse(httpResp)
	return resp, err
}

// updateKeyRotationPolicyCreateRequest creates the UpdateKeyRotationPolicy request.
func (client *Client) updateKeyRotationPolicyCreateRequest(ctx context.Context, name string, keyRotationPolicy KeyRotationPolicy, _ *UpdateKeyRotationPolicyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/rotationpolicy"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, keyRotationPolicy); err != nil {
		return nil, err
	}
	return req, nil
}

// updateKeyRotationPolicyHandleResponse handles the UpdateKeyRotationPolicy response.
func (client *Client) updateKeyRotationPolicyHandleResponse(resp *http.Response) (UpdateKeyRotationPolicyResponse, error) {
	result := UpdateKeyRotationPolicyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyRotationPolicy); err != nil {
		return UpdateKeyRotationPolicyResponse{}, err
	}
	return result, nil
}

// Verify - Verifies a signature using a specified key.
//
// The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not strictly necessary for asymmetric
// keys stored in Azure Key Vault since signature verification can be performed using the public portion of the key but this
// operation is supported as a convenience for callers that only have a key-reference and not the public portion of the key.
// This operation requires the keys/verify permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for verify operations.
//   - options - VerifyOptions contains the optional parameters for the Client.Verify method.
func (client *Client) Verify(ctx context.Context, name string, version string, parameters VerifyParameters, options *VerifyOptions) (VerifyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.Verify", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.verifyCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return VerifyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VerifyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VerifyResponse{}, err
	}
	resp, err := client.verifyHandleResponse(httpResp)
	return resp, err
}

// verifyCreateRequest creates the Verify request.
func (client *Client) verifyCreateRequest(ctx context.Context, name string, version string, parameters VerifyParameters, _ *VerifyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/{key-version}/verify"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// verifyHandleResponse handles the Verify response.
func (client *Client) verifyHandleResponse(resp *http.Response) (VerifyResponse, error) {
	result := VerifyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyVerifyResult); err != nil {
		return VerifyResponse{}, err
	}
	return result, nil
}

// WrapKey - Wraps a symmetric key using a specified key.
//
// The WRAP operation supports encryption of a symmetric key using a key encryption key that has previously been stored in
// an Azure Key Vault. The WRAP operation is only strictly necessary for symmetric keys stored in Azure Key Vault since protection
// with an asymmetric key can be performed using the public portion of the key. This operation is supported for asymmetric
// keys as a convenience for callers that have a key-reference but do not have access to the public key material. This operation
// requires the keys/wrapKey permission.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 7.5
//   - name - The name of the key.
//   - version - The version of the key.
//   - parameters - The parameters for wrap operation.
//   - options - WrapKeyOptions contains the optional parameters for the Client.WrapKey method.
func (client *Client) WrapKey(ctx context.Context, name string, version string, parameters KeyOperationParameters, options *WrapKeyOptions) (WrapKeyResponse, error) {
	var err error
	ctx, endSpan := runtime.StartSpan(ctx, "Client.WrapKey", client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.wrapKeyCreateRequest(ctx, name, version, parameters, options)
	if err != nil {
		return WrapKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return WrapKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return WrapKeyResponse{}, err
	}
	resp, err := client.wrapKeyHandleResponse(httpResp)
	return resp, err
}

// wrapKeyCreateRequest creates the WrapKey request.
func (client *Client) wrapKeyCreateRequest(ctx context.Context, name string, version string, parameters KeyOperationParameters, _ *WrapKeyOptions) (*policy.Request, error) {
	host := "{vaultBaseUrl}"
	host = strings.ReplaceAll(host, "{vaultBaseUrl}", client.vaultBaseUrl)
	urlPath := "/keys/{key-name}/{key-version}/wrapkey"
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{key-name}", url.PathEscape(name))
	urlPath = strings.ReplaceAll(urlPath, "{key-version}", url.PathEscape(version))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "7.5")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	req.Raw().Header["Content-Type"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// wrapKeyHandleResponse handles the WrapKey response.
func (client *Client) wrapKeyHandleResponse(resp *http.Response) (WrapKeyResponse, error) {
	result := WrapKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KeyOperationResult); err != nil {
		return WrapKeyResponse{}, err
	}
	return result, nil
}
