/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Splitter;
import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.internal.buildoption.BooleanBuildOption;
import org.gradle.internal.buildoption.BooleanCommandLineOptionConfiguration;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.EnabledOnlyBooleanBuildOption;
import org.gradle.internal.buildoption.EnumBuildOption;
import org.gradle.internal.buildoption.IntegerBuildOption;
import org.gradle.internal.buildoption.ListBuildOption;
import org.gradle.internal.buildoption.Option;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;
import org.gradle.internal.watch.registry.WatchMode;

public class StartParameterBuildOptions
extends BuildOptionSet<StartParameterInternal> {
    private static List<BuildOption<StartParameterInternal>> options = Arrays.asList(new BuildOption[]{new ProjectCacheDirOption(), new RerunTasksOption(), new ProfileOption(), new ContinueOption(), new OfflineOption(), new RefreshDependenciesOption(), new DryRunOption(), new ContinuousOption(), new ContinuousBuildQuietPeriodOption(), new NoProjectDependenciesRebuildOption(), new InitScriptOption(), new ExcludeTaskOption(), new IncludeBuildOption(), new ConfigureOnDemandOption(), new BuildCacheOption(), new BuildCacheDebugLoggingOption(), new WatchFileSystemOption(), new VfsVerboseLoggingOption(), new BuildScanOption(), new DependencyLockingWriteOption(), new DependencyVerificationWriteOption(), new DependencyVerificationModeOption(), new DependencyLockingUpdateOption(), new RefreshKeysOption(), new ExportKeysOption(), new ConfigurationCacheProblemsOption(), new ConfigurationCacheOption(), new ConfigurationCacheIgnoreInputsDuringStore(), new ConfigurationCacheMaxProblemsOption(), new ConfigurationCacheIgnoredFileSystemCheckInputs(), new ConfigurationCacheDebugOption(), new ConfigurationCacheParallelOption(), new ConfigurationCacheRecreateOption(), new ConfigurationCacheQuietOption(), new ConfigurationCacheEntriesPerKeyOption(), new IsolatedProjectsOption(), new ProblemReportGenerationOption(), new PropertyUpgradeReportOption()});

    public List<? extends BuildOption<? super StartParameterInternal>> getAllOptions() {
        return options;
    }

    public static class ProjectCacheDirOption
    extends StringBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.projectcachedir";

        public ProjectCacheDirOption() {
            super(PROPERTY_NAME, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"project-cache-dir", (String)"Specify the project-specific cache directory. Defaults to .gradle in the root project directory.")});
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setProjectCacheDir((File)resolver.transform((Object)value));
        }
    }

    public static class RerunTasksOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public RerunTasksOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"rerun-tasks", (String)"Ignore previously cached task results.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRerunTasks(true);
        }
    }

    public static class ProfileOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public ProfileOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"profile", (String)"Profile build execution time and generates a report in the <build_dir>/reports/profile directory.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setProfile(true);
        }
    }

    public static class ContinueOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "continue";
        public static final String PROPERTY_NAME = "org.gradle.continue";

        public ContinueOption() {
            super(PROPERTY_NAME, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Continue task execution after a task failure.", (String)"Stop task execution after a task failure.")});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setContinueOnFailure(value);
        }
    }

    public static class OfflineOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public OfflineOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"offline", (String)"Execute the build without accessing network resources.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setOffline(true);
        }
    }

    public static class RefreshDependenciesOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public RefreshDependenciesOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"refresh-dependencies", (String)"U", (String)"Refresh the state of dependencies.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRefreshDependencies(true);
        }
    }

    public static class DryRunOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public DryRunOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"dry-run", (String)"m", (String)"Run the builds with all task actions disabled.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setDryRun(true);
        }
    }

    public static class ContinuousOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public ContinuousOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"continuous", (String)"t", (String)"Enables continuous build. Gradle does not exit and will re-execute tasks when task file inputs change.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setContinuous(true);
        }
    }

    public static class ContinuousBuildQuietPeriodOption
    extends IntegerBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.continuous.quietperiod";

        public ContinuousBuildQuietPeriodOption() {
            super(PROPERTY_NAME);
        }

        public void applyTo(int quietPeriodMillis, StartParameterInternal startParameter, Origin origin) {
            startParameter.setContinuousBuildQuietPeriod(Duration.ofMillis(quietPeriodMillis));
        }
    }

    public static class NoProjectDependenciesRebuildOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "no-rebuild";
        private static final String SHORT_OPTION = "a";

        public NoProjectDependenciesRebuildOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)SHORT_OPTION, (String)"Do not rebuild project dependencies.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setBuildProjectDependencies(false);
        }
    }

    public static class InitScriptOption
    extends ListBuildOption<StartParameterInternal> {
        public InitScriptOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"init-script", (String)"I", (String)"Specify an initialization script.")});
        }

        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            for (String script : values) {
                settings.addInitScript((File)resolver.transform((Object)script));
            }
        }
    }

    public static class ExcludeTaskOption
    extends ListBuildOption<StartParameterInternal> {
        public ExcludeTaskOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"exclude-task", (String)"x", (String)"Specify a task to be excluded from execution.")});
        }

        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            settings.setExcludedTaskNames(values);
        }
    }

    public static class IncludeBuildOption
    extends ListBuildOption<StartParameterInternal> {
        public IncludeBuildOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"include-build", (String)"Include the specified build in the composite.")});
        }

        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            for (String includedBuild : values) {
                settings.includeBuild((File)resolver.transform((Object)includedBuild));
            }
        }
    }

    public static class ConfigureOnDemandOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.configureondemand";

        public ConfigureOnDemandOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)"configure-on-demand", (String)"Configure necessary projects only. Gradle will attempt to reduce configuration time for large multi-project builds.", (String)"Disables the use of configuration on demand.").incubating()});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigureOnDemand(value);
        }
    }

    public static class BuildCacheOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.caching";

        public BuildCacheOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)"build-cache", (String)"Enables the Gradle build cache. Gradle will try to reuse outputs from previous builds.", (String)"Disables the Gradle build cache.")});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setBuildCacheEnabled(value);
        }
    }

    public static class BuildCacheDebugLoggingOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.caching.debug";

        public BuildCacheDebugLoggingOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setBuildCacheDebugLogging(value);
        }
    }

    public static class WatchFileSystemOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "watch-fs";
        public static final String GRADLE_PROPERTY = "org.gradle.vfs.watch";

        public WatchFileSystemOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Enables watching the file system for changes, allowing data about the file system to be re-used for the next build.", (String)"Disables watching the file system.")});
        }

        public void applyTo(boolean value, StartParameterInternal startParameter, Origin origin) {
            startParameter.setWatchFileSystemMode(value ? WatchMode.ENABLED : WatchMode.DISABLED);
        }
    }

    public static class VfsVerboseLoggingOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.vfs.verbose";

        public VfsVerboseLoggingOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(boolean value, StartParameterInternal startParameter, Origin origin) {
            startParameter.setVfsVerboseLogging(value);
        }
    }

    public static class BuildScanOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "scan";

        public BuildScanOption() {
            super(null, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Creates a build scan. Gradle will emit a warning if the build scan plugin has not been applied. (https://gradle.com/build-scans)", (String)"Disables the creation of a build scan. For more information about build scans, please visit https://gradle.com/build-scans.")});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            if (value) {
                settings.setBuildScan(true);
            } else {
                settings.setNoBuildScan(true);
            }
        }
    }

    public static class DependencyLockingWriteOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "write-locks";

        public DependencyLockingWriteOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Persists dependency resolution for locked configurations, ignoring existing locking information if it exists")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setWriteDependencyLocks(true);
        }
    }

    public static class DependencyVerificationWriteOption
    extends StringBuildOption<StartParameterInternal> {
        public static final String SHORT_OPTION = "M";
        public static final String LONG_OPTION = "write-verification-metadata";

        DependencyVerificationWriteOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)SHORT_OPTION, (String)"Generates checksums for dependencies used in the project (comma-separated list)")});
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            List checksums = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)value).stream().map(String::toLowerCase).collect(Collectors.toList());
            settings.setWriteDependencyVerifications(checksums);
        }
    }

    public static class DependencyVerificationModeOption
    extends EnumBuildOption<DependencyVerificationMode, StartParameterInternal> {
        private static final String GRADLE_PROPERTY = "org.gradle.dependency.verification";
        private static final String LONG_OPTION = "dependency-verification";
        private static final String SHORT_OPTION = "F";

        public DependencyVerificationModeOption() {
            super(LONG_OPTION, DependencyVerificationMode.class, (Enum[])DependencyVerificationMode.values(), GRADLE_PROPERTY, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)SHORT_OPTION, (String)"Configures the dependency verification mode. Values are 'strict', 'lenient' or 'off'.")});
        }

        public void applyTo(DependencyVerificationMode value, StartParameterInternal settings, Origin origin) {
            settings.setDependencyVerificationMode(value);
        }
    }

    public static class DependencyLockingUpdateOption
    extends ListBuildOption<StartParameterInternal> {
        public DependencyLockingUpdateOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"update-locks", (String)"Perform a partial update of the dependency lock, letting passed in module notations change version.").incubating()});
        }

        public void applyTo(List<String> modulesToUpdate, StartParameterInternal settings, Origin origin) {
            settings.setLockedDependenciesToUpdate(modulesToUpdate);
        }
    }

    public static class RefreshKeysOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "refresh-keys";

        public RefreshKeysOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Refresh the public keys used for dependency verification.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRefreshKeys(true);
        }
    }

    public static class ExportKeysOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "export-keys";

        public ExportKeysOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Exports the public keys used for dependency verification.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setExportKeys(true);
        }
    }

    public static class ConfigurationCacheProblemsOption
    extends EnumBuildOption<Value, StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache.problems";
        public static final String DEPRECATED_PROPERTY_NAME = "org.gradle.unsafe.configuration-cache-problems";
        public static final String LONG_OPTION = "configuration-cache-problems";

        public ConfigurationCacheProblemsOption() {
            super(LONG_OPTION, Value.class, (Enum[])Value.values(), PROPERTY_NAME, DEPRECATED_PROPERTY_NAME, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Configures how the configuration cache handles problems (fail or warn). Defaults to fail.")});
        }

        public void applyTo(Value value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheProblems(value);
        }

        public static enum Value {
            FAIL,
            WARN;

        }
    }

    public static class ConfigurationCacheOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache";
        public static final String DEPRECATED_PROPERTY_NAME = "org.gradle.unsafe.configuration-cache";
        public static final String LONG_OPTION = "configuration-cache";

        public ConfigurationCacheOption() {
            super(PROPERTY_NAME, DEPRECATED_PROPERTY_NAME, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Enables the configuration cache. Gradle will try to reuse the build configuration from previous builds.", (String)"Disables the configuration cache.")});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCache((Option.Value<Boolean>)Option.Value.value((Object)value));
        }
    }

    public static class ConfigurationCacheIgnoreInputsDuringStore
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache.inputs.unsafe.ignore.in-serialization";

        public ConfigurationCacheIgnoreInputsDuringStore() {
            super(PROPERTY_NAME);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheIgnoreInputsDuringStore(value);
        }
    }

    public static class ConfigurationCacheMaxProblemsOption
    extends IntegerBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache.max-problems";
        public static final String DEPRECATED_PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.max-problems";

        public ConfigurationCacheMaxProblemsOption() {
            super(PROPERTY_NAME, DEPRECATED_PROPERTY_NAME);
        }

        public void applyTo(int value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheMaxProblems(value);
        }
    }

    public static class ConfigurationCacheIgnoredFileSystemCheckInputs
    extends StringBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache.inputs.unsafe.ignore.file-system-checks";

        public ConfigurationCacheIgnoredFileSystemCheckInputs() {
            super(PROPERTY_NAME);
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheIgnoredFileSystemCheckInputs(value);
        }
    }

    public static class ConfigurationCacheDebugOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache.internal.debug";
        public static final String DEPRECATED_PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.debug";

        public ConfigurationCacheDebugOption() {
            super(PROPERTY_NAME, DEPRECATED_PROPERTY_NAME, new BooleanCommandLineOptionConfiguration[0]);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheDebug(value);
        }
    }

    public static class ConfigurationCacheParallelOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache.parallel";

        public ConfigurationCacheParallelOption() {
            super(PROPERTY_NAME);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheParallel(value);
        }
    }

    public static class ConfigurationCacheRecreateOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache.internal.recreate-cache";
        public static final String DEPRECATED_PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.recreate-cache";

        public ConfigurationCacheRecreateOption() {
            super(PROPERTY_NAME, DEPRECATED_PROPERTY_NAME, new BooleanCommandLineOptionConfiguration[0]);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheRecreateCache(value);
        }
    }

    public static class ConfigurationCacheQuietOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache.internal.quiet";
        public static final String DEPRECATED_PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.quiet";

        public ConfigurationCacheQuietOption() {
            super(PROPERTY_NAME, DEPRECATED_PROPERTY_NAME, new BooleanCommandLineOptionConfiguration[0]);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheQuiet(value);
        }
    }

    public static class ConfigurationCacheEntriesPerKeyOption
    extends IntegerBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.configuration-cache.entries-per-key";

        public ConfigurationCacheEntriesPerKeyOption() {
            super(PROPERTY_NAME);
        }

        public void applyTo(int value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheEntriesPerKey(value);
        }
    }

    public static class IsolatedProjectsOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.isolated-projects";

        public IsolatedProjectsOption() {
            super(PROPERTY_NAME);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setIsolatedProjects((Option.Value<Boolean>)Option.Value.value((Object)value));
        }
    }

    public static class ProblemReportGenerationOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "problems-report";
        public static final String GRADLE_PROPERTY = "org.gradle.problems.report";

        public ProblemReportGenerationOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"(Experimental) enables HTML problems report", (String)"(Experimental) disables HTML problems report")});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.enableProblemReportGeneration(value);
        }
    }

    public static class PropertyUpgradeReportOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "property-upgrade-report";

        public PropertyUpgradeReportOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"(Experimental) Runs build with experimental property upgrade report.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setPropertyUpgradeReportEnabled(true);
        }
    }
}

