// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceHTTPResponseRuleFrontendOKCode is the HTTP code returned for type ReplaceHTTPResponseRuleFrontendOK
const ReplaceHTTPResponseRuleFrontendOKCode int = 200

/*
ReplaceHTTPResponseRuleFrontendOK HTTP Response Rule replaced

swagger:response replaceHttpResponseRuleFrontendOK
*/
type ReplaceHTTPResponseRuleFrontendOK struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPResponseRule `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleFrontendOK creates ReplaceHTTPResponseRuleFrontendOK with default headers values
func NewReplaceHTTPResponseRuleFrontendOK() *ReplaceHTTPResponseRuleFrontendOK {

	return &ReplaceHTTPResponseRuleFrontendOK{}
}

// WithPayload adds the payload to the replace Http response rule frontend o k response
func (o *ReplaceHTTPResponseRuleFrontendOK) WithPayload(payload *models.HTTPResponseRule) *ReplaceHTTPResponseRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http response rule frontend o k response
func (o *ReplaceHTTPResponseRuleFrontendOK) SetPayload(payload *models.HTTPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPResponseRuleFrontendAcceptedCode is the HTTP code returned for type ReplaceHTTPResponseRuleFrontendAccepted
const ReplaceHTTPResponseRuleFrontendAcceptedCode int = 202

/*
ReplaceHTTPResponseRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceHttpResponseRuleFrontendAccepted
*/
type ReplaceHTTPResponseRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPResponseRule `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleFrontendAccepted creates ReplaceHTTPResponseRuleFrontendAccepted with default headers values
func NewReplaceHTTPResponseRuleFrontendAccepted() *ReplaceHTTPResponseRuleFrontendAccepted {

	return &ReplaceHTTPResponseRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace Http response rule frontend accepted response
func (o *ReplaceHTTPResponseRuleFrontendAccepted) WithReloadID(reloadID string) *ReplaceHTTPResponseRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Http response rule frontend accepted response
func (o *ReplaceHTTPResponseRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Http response rule frontend accepted response
func (o *ReplaceHTTPResponseRuleFrontendAccepted) WithPayload(payload *models.HTTPResponseRule) *ReplaceHTTPResponseRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http response rule frontend accepted response
func (o *ReplaceHTTPResponseRuleFrontendAccepted) SetPayload(payload *models.HTTPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPResponseRuleFrontendBadRequestCode is the HTTP code returned for type ReplaceHTTPResponseRuleFrontendBadRequest
const ReplaceHTTPResponseRuleFrontendBadRequestCode int = 400

/*
ReplaceHTTPResponseRuleFrontendBadRequest Bad request

swagger:response replaceHttpResponseRuleFrontendBadRequest
*/
type ReplaceHTTPResponseRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleFrontendBadRequest creates ReplaceHTTPResponseRuleFrontendBadRequest with default headers values
func NewReplaceHTTPResponseRuleFrontendBadRequest() *ReplaceHTTPResponseRuleFrontendBadRequest {

	return &ReplaceHTTPResponseRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http response rule frontend bad request response
func (o *ReplaceHTTPResponseRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPResponseRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http response rule frontend bad request response
func (o *ReplaceHTTPResponseRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http response rule frontend bad request response
func (o *ReplaceHTTPResponseRuleFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceHTTPResponseRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http response rule frontend bad request response
func (o *ReplaceHTTPResponseRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPResponseRuleFrontendNotFoundCode is the HTTP code returned for type ReplaceHTTPResponseRuleFrontendNotFound
const ReplaceHTTPResponseRuleFrontendNotFoundCode int = 404

/*
ReplaceHTTPResponseRuleFrontendNotFound The specified resource was not found

swagger:response replaceHttpResponseRuleFrontendNotFound
*/
type ReplaceHTTPResponseRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleFrontendNotFound creates ReplaceHTTPResponseRuleFrontendNotFound with default headers values
func NewReplaceHTTPResponseRuleFrontendNotFound() *ReplaceHTTPResponseRuleFrontendNotFound {

	return &ReplaceHTTPResponseRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http response rule frontend not found response
func (o *ReplaceHTTPResponseRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPResponseRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http response rule frontend not found response
func (o *ReplaceHTTPResponseRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http response rule frontend not found response
func (o *ReplaceHTTPResponseRuleFrontendNotFound) WithPayload(payload *models.Error) *ReplaceHTTPResponseRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http response rule frontend not found response
func (o *ReplaceHTTPResponseRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceHTTPResponseRuleFrontendDefault General Error

swagger:response replaceHttpResponseRuleFrontendDefault
*/
type ReplaceHTTPResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleFrontendDefault creates ReplaceHTTPResponseRuleFrontendDefault with default headers values
func NewReplaceHTTPResponseRuleFrontendDefault(code int) *ReplaceHTTPResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceHTTPResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace HTTP response rule frontend default response
func (o *ReplaceHTTPResponseRuleFrontendDefault) WithStatusCode(code int) *ReplaceHTTPResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace HTTP response rule frontend default response
func (o *ReplaceHTTPResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace HTTP response rule frontend default response
func (o *ReplaceHTTPResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace HTTP response rule frontend default response
func (o *ReplaceHTTPResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace HTTP response rule frontend default response
func (o *ReplaceHTTPResponseRuleFrontendDefault) WithPayload(payload *models.Error) *ReplaceHTTPResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace HTTP response rule frontend default response
func (o *ReplaceHTTPResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
