/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import sun.lwawt.macosx.CMenuBar;
import sun.lwawt.macosx.CMenuComponent;
import sun.lwawt.macosx.CMenuItem;
import sun.lwawt.macosx.LWCToolkit;

public class CMenu
extends CMenuItem
implements MenuPeer {
    public CMenu(Menu menu) {
        super(menu);
    }

    @Override
    protected final void initialize(MenuItem menuItem) {
        this.setLabel(menuItem.getLabel());
        this.setEnabled(menuItem.isEnabled());
    }

    @Override
    public final void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Menu menu = (Menu)this.getTarget();
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = menu.getItem(i);
            MenuItemPeer menuItemPeer = (MenuItemPeer)LWCToolkit.targetToPeer(menuItem);
            if (menuItemPeer == null) continue;
            menuItemPeer.setEnabled(bl && menuItem.isEnabled());
        }
    }

    @Override
    long createModel() {
        CMenuComponent cMenuComponent = (CMenuComponent)LWCToolkit.targetToPeer(this.getTarget().getParent());
        if (cMenuComponent instanceof CMenu) {
            return cMenuComponent.executeGet(this::nativeCreateSubMenu);
        }
        if (cMenuComponent instanceof CMenuBar) {
            MenuBar menuBar = (MenuBar)this.getTarget().getParent();
            boolean bl = menuBar.getHelpMenu() == this.getTarget();
            int n = ((CMenuBar)cMenuComponent).getNextInsertionIndex();
            return cMenuComponent.executeGet(l -> this.nativeCreateMenu(l, bl, n));
        }
        throw new InternalError("Parent must be CMenu or CMenuBar");
    }

    @Override
    public final void addItem(MenuItem menuItem) {
    }

    @Override
    public final void delItem(int n) {
        this.execute(l -> this.nativeDeleteItem(l, n));
    }

    @Override
    public final void setLabel(String string) {
        this.execute(l -> this.nativeSetMenuTitle(l, string));
        super.setLabel(string);
    }

    @Override
    public final void addSeparator() {
        this.execute(this::nativeAddSeparator);
    }

    public final long getNativeMenu() {
        return this.executeGet(this::nativeGetNSMenu);
    }

    private native long nativeCreateMenu(long var1, boolean var3, int var4);

    private native long nativeCreateSubMenu(long var1);

    private native void nativeSetMenuTitle(long var1, String var3);

    private native void nativeAddSeparator(long var1);

    private native void nativeDeleteItem(long var1, int var3);

    private native long nativeGetNSMenu(long var1);
}

