/*
 * This file is part of csharp-gentoodotnetinfo - .NET information tool for Gentoo.
 * Copyright (c) 20233-2024, Maciej Barć <xgqt@gentoo.org>
 * Licensed under the GNU GPL v2 License
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * csharp-gentoodotnetinfo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * csharp-gentoodotnetinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with csharp-gentoodotnetinfo.  If not, see <https://www.gnu.org/licenses/>.
 */

using System;
using Gentoo.DotNet.GentooDotnetInfo.Info;
using Gentoo.DotNet.GentooDotnetInfo.Util;

namespace Gentoo.DotNet.GentooDotnetInfo.Action
{

    public class GentooDotnetInfoAction
    {

        private readonly OperatingSystemInfo _operatingSystemInfo = new();

        private readonly LimitsSystemInfo _limitsSystemInfo = new();

        private readonly PlatformInfo _platformInfo = new();

        private readonly DotnetSDKInfo _dotnetSDKInfo = new();

        private readonly DotnetRuntimeInfo _dotnetRuntimeInfo = new();

        public GentooDotnetInfoAction()
        {

        }

        private void ShowVariable(String variableCommentary, String variableValue)
        {
            if (variableValue is null)
            {
                EWrite.Warn($"{variableCommentary}: unknown");
            }
            else
            {
                EWrite.Info($"{variableCommentary}: {variableValue}");
            }
        }

        public void Write()
        {
            String osProcessArchitecture = _operatingSystemInfo.OSProcessArchitecture;
            String osProcessorCount = _operatingSystemInfo.OSProcessorCount;
            String osVersion = _operatingSystemInfo.OSVersion;
            String osLocale = _operatingSystemInfo.Locale;

            String limitsMaxDescriptors = _limitsSystemInfo.MaxDescriptors;
            String limitsMaxPid = _limitsSystemInfo.MaxPid;

            String platformType = _platformInfo.PlatformType;
            String platformName = _platformInfo.PlatformName;
            String platformVersion = _platformInfo.PlatformVersion;

            String frameworkVersion = _dotnetSDKInfo.FrameworkVersion;
            String frameworkDescription = _dotnetSDKInfo.FrameworkDescription;

            String runtimeIdentifier = _dotnetRuntimeInfo.RuntimeIdentifier;
            String runtimeProcessName = _dotnetRuntimeInfo.ProcessName;
            String runtimeProcessFileName = _dotnetRuntimeInfo.ProcessFileName;
            String runtimeDirectory = _dotnetRuntimeInfo.RuntimeDirectory;

            EWrite.Info("Operating System:");
            ShowVariable("  Process Architecture", osProcessArchitecture);
            ShowVariable("  Processor Count", osProcessorCount);
            ShowVariable("  OS Version", osVersion);
            ShowVariable("  Locale", osLocale);

            EWrite.Info("Limits:");
            ShowVariable("  Descriptors", limitsMaxDescriptors);
            ShowVariable("  PIDs", limitsMaxPid);

            EWrite.Info("Platform:");
            ShowVariable("  Type", platformType);
            ShowVariable("  Name", platformName);
            ShowVariable("  Version", platformVersion);

            EWrite.Info("Dotnet SDK:");
            ShowVariable("  Version", frameworkVersion);
            ShowVariable("  Framework Description", frameworkDescription);

            EWrite.Info("Dotnet Runtime:");
            ShowVariable("  Identifier", runtimeIdentifier);
            ShowVariable("  Process Name", runtimeProcessName);
            ShowVariable("  Process File Name", runtimeProcessFileName);
            ShowVariable("  Runtime Directory", runtimeDirectory);
        }

    }

}
