/*
 * Decompiled with CFR 0.152.
 */
package dev.dirs;

import dev.dirs.UnsupportedOperatingSystemException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;

final class Util {
    static final String operatingSystemName = System.getProperty("os.name");
    static final char operatingSystem;
    static final char LIN = 'l';
    static final char MAC = 'm';
    static final char WIN = 'w';
    static final char BSD = 'b';
    static final char SOLARIS = 's';
    static final char IBMI = 'i';
    static final String UTF8_BOM = "\ufeff";
    private static Object base64Encoder;
    private static Method base64EncodeMethod;
    static final String SCRIPT_START_BASE64;

    private Util() {
        throw new Error();
    }

    static void requireNonNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static boolean isNullOrEmpty(String string2) {
        return string2 == null || string2.isEmpty();
    }

    static String defaultIfNullOrEmpty(String string2, String string3, String string4) {
        Util.requireNonNull(string4);
        if (Util.isNullOrEmpty(string2)) {
            return Util.ensureSingleSlash(string3, string4);
        }
        return string2;
    }

    static String defaultIfNullOrEmptyExtended(String string2, String string3, String string4, String string5) {
        Util.requireNonNull(string3);
        Util.requireNonNull(string4);
        Util.requireNonNull(string5);
        if (Util.isNullOrEmpty(string2)) {
            return Util.ensureSingleSlash(string4, string5);
        }
        return Util.ensureSingleSlash(string2, string3);
    }

    static String ensureSingleSlash(String string2, String string3) {
        boolean bl = string2.endsWith("/");
        boolean bl2 = string3.startsWith("/");
        if (bl && bl2) {
            StringBuilder stringBuilder = new StringBuilder(string2.length() + string3.length() - 1);
            stringBuilder.append(string2, 0, string2.length() - 1).append(string3);
            return stringBuilder.toString();
        }
        if (!bl && !bl2) {
            return string2 + '/' + string3;
        }
        return string2 + string3;
    }

    static String linuxRuntimeDir(String string2) {
        String string3 = System.getenv("XDG_RUNTIME_DIR");
        if (Util.isNullOrEmpty(string3)) {
            return null;
        }
        if (string2 == null) {
            return string3;
        }
        return string3 + '/' + string2;
    }

    static String linuxExecutableDir(String string2, String string3) {
        String string4 = System.getenv("XDG_BIN_HOME");
        if (Util.isNullOrEmpty(string4)) {
            return Util.defaultIfNullOrEmptyExtended(string3, "/../bin/", string2, "/.local/bin/");
        }
        return string4;
    }

    static String[] getXDGUserDirs(String ... stringArray) {
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder(n * 22);
        String[] stringArray2 = new String[3];
        stringArray2[0] = "/bin/sh";
        stringArray2[1] = "-c";
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("xdg-user-dir ");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(';');
        }
        stringArray2[2] = stringBuilder.toString();
        try {
            return Util.runCommands(n, Charset.defaultCharset(), stringArray2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static String[] getWinDirs(String ... stringArray) {
        String[] stringArray2;
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder(n * 68);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("[Dir]::GetKnownFolderPath(\"");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("\")\n");
        }
        String string2 = SCRIPT_START_BASE64 + Util.toUTF16LEBase64(stringBuilder + "}");
        String string3 = System.getenv("Path");
        String[] stringArray3 = stringArray2 = string3 == null ? new String[]{} : string3.split(File.pathSeparator);
        if (stringArray2.length == 0) {
            return Util.windowsFallback(n, string2);
        }
        try {
            return Util.runWinCommands(n, stringArray2, string2);
        }
        catch (IOException iOException) {
            return Util.windowsFallback(n, string2);
        }
    }

    private static String toUTF16LEBase64(String string2) {
        byte[] byArray = string2.getBytes(Charset.forName("UTF-16LE"));
        if (base64EncodeMethod == null) {
            Util.initBase64Encoding();
        }
        try {
            return (String)base64EncodeMethod.invoke(base64Encoder, new Object[]{byArray});
        }
        catch (Exception exception) {
            throw new RuntimeException("Base64 encoding failed!", exception);
        }
    }

    private static void initBase64Encoding() {
        try {
            base64Encoder = Class.forName("java.util.Base64").getMethod("getEncoder", new Class[0]).invoke(null, new Object[0]);
            base64EncodeMethod = base64Encoder.getClass().getMethod("encodeToString", byte[].class);
        }
        catch (Exception exception) {
            try {
                base64EncodeMethod = Class.forName("sun.misc.BASE64Encoder").getMethod("encode", byte[].class);
            }
            catch (Exception exception2) {
                throw new RuntimeException("Could not find any viable Base64 encoder! (java.util.Base64 failed with: " + exception.getMessage() + ")", exception2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] runCommands(int n, Charset charset, String ... stringArray) throws IOException {
        Process process = new ProcessBuilder(stringArray).start();
        String[] stringArray2 = new String[n];
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), charset));
        try {
            for (int i = 0; i < n; ++i) {
                String string2 = bufferedReader.readLine();
                if (i == 0 && operatingSystem == 'w' && string2 != null && string2.startsWith(UTF8_BOM)) {
                    string2 = string2.substring(UTF8_BOM.length());
                }
                stringArray2[i] = string2;
            }
            String[] stringArray3 = stringArray2;
            return stringArray3;
        }
        finally {
            process.destroy();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static String[] runWinCommands(int n, String[] stringArray, String string2) throws IOException {
        String[] stringArray2 = new String[]{"powershell.exe", "pwsh.exe"};
        IOException iOException = null;
        for (String string3 : stringArray) {
            for (String string4 : stringArray2) {
                File file = new File(string3, string4);
                if (!file.exists()) continue;
                try {
                    String[] stringArray3 = Util.runCommands(n, Charset.forName("UTF-8"), file.toString(), "-version", "2", "-NoProfile", "-EncodedCommand", string2);
                    if (stringArray3[0] != null) {
                        return stringArray3;
                    }
                    stringArray3 = Util.runCommands(n, Charset.forName("UTF-8"), file.toString(), "-NoProfile", "-EncodedCommand", string2);
                    return stringArray3;
                }
                catch (IOException iOException2) {
                    iOException = iOException == null ? iOException2 : iOException;
                }
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        throw new IOException("no directories");
    }

    private static String[] windowsFallback(int n, String string2) {
        File file = new File("C:\\Program Files\\Powershell");
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        String string3 = System.getenv("SystemRoot");
        if (string3 == null) {
            string3 = "C:\\Windows";
        }
        stringArray2[0] = string3 + "\\System32\\WindowsPowerShell\\v1.0\\";
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = new File(file, stringArray[i]).toString();
        }
        try {
            return Util.runWinCommands(n, stringArray2, string2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't find pwsh.exe or powershell.exe on path or in default system locations", iOException);
        }
    }

    static String macOSApplicationPath(String string2, String string3, String string4) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder(Math.max(Util.stringLength(string2) + Util.stringLength(string3) + Util.stringLength(string4), 0));
        boolean bl2 = !Util.isNullOrEmpty(string2);
        boolean bl3 = !Util.isNullOrEmpty(string3);
        boolean bl4 = bl = !Util.isNullOrEmpty(string4);
        if (bl2) {
            stringBuilder.append(Util.trimLowercaseReplaceWhitespace(string2, "-", false));
            if (bl3 || bl) {
                stringBuilder.append('.');
            }
        }
        if (bl3) {
            stringBuilder.append(Util.trimLowercaseReplaceWhitespace(string3, "-", false));
            if (bl) {
                stringBuilder.append('.');
            }
        }
        if (bl) {
            stringBuilder.append(Util.trimLowercaseReplaceWhitespace(string4, "-", false));
        }
        return stringBuilder.toString();
    }

    static String windowsApplicationPath(String string2, String string3, String string4) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder(Math.max(Util.stringLength(string3) + Util.stringLength(string4), 0));
        boolean bl2 = !Util.isNullOrEmpty(string3);
        boolean bl3 = bl = !Util.isNullOrEmpty(string4);
        if (bl2) {
            stringBuilder.append(string3);
            if (bl) {
                stringBuilder.append('\\');
            }
        }
        if (bl) {
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    static String stripQualification(String string2) {
        int n = string2.lastIndexOf(46) + 1;
        return string2.substring(n);
    }

    static int stringLength(String string2) {
        if (string2 == null) {
            return -1;
        }
        return string2.length();
    }

    static String trimLowercaseReplaceWhitespace(String string2, String string3, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        boolean bl2 = false;
        int n = string2.codePointCount(0, string2.length());
        boolean bl3 = !string3.isEmpty();
        for (int i = 0; i < n; ++i) {
            int n2 = string2.codePointAt(i);
            if (n2 == 32) {
                if (!bl2 || !bl3 || !Util.codePointExistsAndNotSpace(string2, n, i + 1)) continue;
                stringBuilder.append('-');
                bl2 = false;
                continue;
            }
            stringBuilder.appendCodePoint(bl ? Character.toLowerCase(n2) : n2);
            bl2 = true;
        }
        return stringBuilder.toString();
    }

    private static boolean codePointExistsAndNotSpace(String string2, int n, int n2) {
        return n2 < n && string2.codePointAt(n2) != 32;
    }

    static {
        String string2 = operatingSystemName.toLowerCase(Locale.ROOT);
        if (string2.contains("linux")) {
            operatingSystem = (char)108;
        } else if (string2.contains("mac")) {
            operatingSystem = (char)109;
        } else if (string2.contains("windows")) {
            operatingSystem = (char)119;
        } else if (string2.contains("bsd")) {
            operatingSystem = (char)98;
        } else if (string2.contains("sunos")) {
            operatingSystem = (char)115;
        } else if (string2.contains("os/400") || string2.contains("os400")) {
            operatingSystem = (char)105;
        } else {
            throw new UnsupportedOperatingSystemException("directories are not supported on " + operatingSystemName);
        }
        base64Encoder = null;
        base64EncodeMethod = null;
        SCRIPT_START_BASE64 = operatingSystem == 'w' ? Util.toUTF16LEBase64("& {\n[Console]::OutputEncoding = [System.Text.Encoding]::UTF8\nAdd-Type @\"\nusing System;\nusing System.Runtime.InteropServices;\npublic class Dir {\n  [DllImport(\"shell32.dll\")]\n  private static extern int SHGetKnownFolderPath([MarshalAs(UnmanagedType.LPStruct)] Guid rfid, uint dwFlags, IntPtr hToken, out IntPtr pszPath);\n  public static string GetKnownFolderPath(string rfid) {\n    IntPtr pszPath;\n    if (SHGetKnownFolderPath(new Guid(rfid), 0, IntPtr.Zero, out pszPath) != 0) return \"\";\n    string path = Marshal.PtrToStringUni(pszPath);\n    Marshal.FreeCoTaskMem(pszPath);\n    return path;\n  }\n}\n\"@\n") : null;
    }
}

