module Maskable (
  Maskable(..) )
where

import Bit (Bit)
import Maskbits (Maskbits)

-- | Any string of bits should be maskable by some number of netmask
--   bits. The convention of the Maskable typeclass follows CIDR
--   notation, where the number of mask bits (the number after the
--   slash) denotes how many bits are reserved for the network.
--
--   So, a mask of 32 applied to an address of 127.0.0.1 will again
--   return 127.0.0.1. Likewise, 31 mask bits applied to 127.0.0.1
--   should return 127.0.0.0, since 127.0.0.1/31 matches both
--   127.0.0.0 and 127.0.0.1. In this case, the final '0' or '1' is
--   the host part of the address. The '127.0.0' is thus the network
--   part.
--
--   The Bit argument allows us to specify whether the host bits
--   should be replaced with either Zero or One.
--
class Maskable a where
    apply_mask :: a -> Maskbits -> Bit -> a
