/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package driver

import (
	"context"

	"github.com/container-storage-interface/spec/lib/go/csi"
	mock "github.com/stretchr/testify/mock"
)

// NewMockIdentityServer creates a new instance of MockIdentityServer. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockIdentityServer(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockIdentityServer {
	mock := &MockIdentityServer{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockIdentityServer is an autogenerated mock type for the IdentityServer type
type MockIdentityServer struct {
	mock.Mock
}

type MockIdentityServer_Expecter struct {
	mock *mock.Mock
}

func (_m *MockIdentityServer) EXPECT() *MockIdentityServer_Expecter {
	return &MockIdentityServer_Expecter{mock: &_m.Mock}
}

// GetPluginCapabilities provides a mock function for the type MockIdentityServer
func (_mock *MockIdentityServer) GetPluginCapabilities(context1 context.Context, getPluginCapabilitiesRequest *csi.GetPluginCapabilitiesRequest) (*csi.GetPluginCapabilitiesResponse, error) {
	ret := _mock.Called(context1, getPluginCapabilitiesRequest)

	if len(ret) == 0 {
		panic("no return value specified for GetPluginCapabilities")
	}

	var r0 *csi.GetPluginCapabilitiesResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.GetPluginCapabilitiesRequest) (*csi.GetPluginCapabilitiesResponse, error)); ok {
		return returnFunc(context1, getPluginCapabilitiesRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.GetPluginCapabilitiesRequest) *csi.GetPluginCapabilitiesResponse); ok {
		r0 = returnFunc(context1, getPluginCapabilitiesRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.GetPluginCapabilitiesResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.GetPluginCapabilitiesRequest) error); ok {
		r1 = returnFunc(context1, getPluginCapabilitiesRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockIdentityServer_GetPluginCapabilities_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPluginCapabilities'
type MockIdentityServer_GetPluginCapabilities_Call struct {
	*mock.Call
}

// GetPluginCapabilities is a helper method to define mock.On call
//   - context1 context.Context
//   - getPluginCapabilitiesRequest *csi.GetPluginCapabilitiesRequest
func (_e *MockIdentityServer_Expecter) GetPluginCapabilities(context1 interface{}, getPluginCapabilitiesRequest interface{}) *MockIdentityServer_GetPluginCapabilities_Call {
	return &MockIdentityServer_GetPluginCapabilities_Call{Call: _e.mock.On("GetPluginCapabilities", context1, getPluginCapabilitiesRequest)}
}

func (_c *MockIdentityServer_GetPluginCapabilities_Call) Run(run func(context1 context.Context, getPluginCapabilitiesRequest *csi.GetPluginCapabilitiesRequest)) *MockIdentityServer_GetPluginCapabilities_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.GetPluginCapabilitiesRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.GetPluginCapabilitiesRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockIdentityServer_GetPluginCapabilities_Call) Return(getPluginCapabilitiesResponse *csi.GetPluginCapabilitiesResponse, err error) *MockIdentityServer_GetPluginCapabilities_Call {
	_c.Call.Return(getPluginCapabilitiesResponse, err)
	return _c
}

func (_c *MockIdentityServer_GetPluginCapabilities_Call) RunAndReturn(run func(context1 context.Context, getPluginCapabilitiesRequest *csi.GetPluginCapabilitiesRequest) (*csi.GetPluginCapabilitiesResponse, error)) *MockIdentityServer_GetPluginCapabilities_Call {
	_c.Call.Return(run)
	return _c
}

// GetPluginInfo provides a mock function for the type MockIdentityServer
func (_mock *MockIdentityServer) GetPluginInfo(context1 context.Context, getPluginInfoRequest *csi.GetPluginInfoRequest) (*csi.GetPluginInfoResponse, error) {
	ret := _mock.Called(context1, getPluginInfoRequest)

	if len(ret) == 0 {
		panic("no return value specified for GetPluginInfo")
	}

	var r0 *csi.GetPluginInfoResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.GetPluginInfoRequest) (*csi.GetPluginInfoResponse, error)); ok {
		return returnFunc(context1, getPluginInfoRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.GetPluginInfoRequest) *csi.GetPluginInfoResponse); ok {
		r0 = returnFunc(context1, getPluginInfoRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.GetPluginInfoResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.GetPluginInfoRequest) error); ok {
		r1 = returnFunc(context1, getPluginInfoRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockIdentityServer_GetPluginInfo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPluginInfo'
type MockIdentityServer_GetPluginInfo_Call struct {
	*mock.Call
}

// GetPluginInfo is a helper method to define mock.On call
//   - context1 context.Context
//   - getPluginInfoRequest *csi.GetPluginInfoRequest
func (_e *MockIdentityServer_Expecter) GetPluginInfo(context1 interface{}, getPluginInfoRequest interface{}) *MockIdentityServer_GetPluginInfo_Call {
	return &MockIdentityServer_GetPluginInfo_Call{Call: _e.mock.On("GetPluginInfo", context1, getPluginInfoRequest)}
}

func (_c *MockIdentityServer_GetPluginInfo_Call) Run(run func(context1 context.Context, getPluginInfoRequest *csi.GetPluginInfoRequest)) *MockIdentityServer_GetPluginInfo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.GetPluginInfoRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.GetPluginInfoRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockIdentityServer_GetPluginInfo_Call) Return(getPluginInfoResponse *csi.GetPluginInfoResponse, err error) *MockIdentityServer_GetPluginInfo_Call {
	_c.Call.Return(getPluginInfoResponse, err)
	return _c
}

func (_c *MockIdentityServer_GetPluginInfo_Call) RunAndReturn(run func(context1 context.Context, getPluginInfoRequest *csi.GetPluginInfoRequest) (*csi.GetPluginInfoResponse, error)) *MockIdentityServer_GetPluginInfo_Call {
	_c.Call.Return(run)
	return _c
}

// Probe provides a mock function for the type MockIdentityServer
func (_mock *MockIdentityServer) Probe(context1 context.Context, probeRequest *csi.ProbeRequest) (*csi.ProbeResponse, error) {
	ret := _mock.Called(context1, probeRequest)

	if len(ret) == 0 {
		panic("no return value specified for Probe")
	}

	var r0 *csi.ProbeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ProbeRequest) (*csi.ProbeResponse, error)); ok {
		return returnFunc(context1, probeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ProbeRequest) *csi.ProbeResponse); ok {
		r0 = returnFunc(context1, probeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ProbeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ProbeRequest) error); ok {
		r1 = returnFunc(context1, probeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockIdentityServer_Probe_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Probe'
type MockIdentityServer_Probe_Call struct {
	*mock.Call
}

// Probe is a helper method to define mock.On call
//   - context1 context.Context
//   - probeRequest *csi.ProbeRequest
func (_e *MockIdentityServer_Expecter) Probe(context1 interface{}, probeRequest interface{}) *MockIdentityServer_Probe_Call {
	return &MockIdentityServer_Probe_Call{Call: _e.mock.On("Probe", context1, probeRequest)}
}

func (_c *MockIdentityServer_Probe_Call) Run(run func(context1 context.Context, probeRequest *csi.ProbeRequest)) *MockIdentityServer_Probe_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ProbeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ProbeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockIdentityServer_Probe_Call) Return(probeResponse *csi.ProbeResponse, err error) *MockIdentityServer_Probe_Call {
	_c.Call.Return(probeResponse, err)
	return _c
}

func (_c *MockIdentityServer_Probe_Call) RunAndReturn(run func(context1 context.Context, probeRequest *csi.ProbeRequest) (*csi.ProbeResponse, error)) *MockIdentityServer_Probe_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockControllerServer creates a new instance of MockControllerServer. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockControllerServer(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockControllerServer {
	mock := &MockControllerServer{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockControllerServer is an autogenerated mock type for the ControllerServer type
type MockControllerServer struct {
	mock.Mock
}

type MockControllerServer_Expecter struct {
	mock *mock.Mock
}

func (_m *MockControllerServer) EXPECT() *MockControllerServer_Expecter {
	return &MockControllerServer_Expecter{mock: &_m.Mock}
}

// ControllerExpandVolume provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) ControllerExpandVolume(context1 context.Context, controllerExpandVolumeRequest *csi.ControllerExpandVolumeRequest) (*csi.ControllerExpandVolumeResponse, error) {
	ret := _mock.Called(context1, controllerExpandVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for ControllerExpandVolume")
	}

	var r0 *csi.ControllerExpandVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerExpandVolumeRequest) (*csi.ControllerExpandVolumeResponse, error)); ok {
		return returnFunc(context1, controllerExpandVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerExpandVolumeRequest) *csi.ControllerExpandVolumeResponse); ok {
		r0 = returnFunc(context1, controllerExpandVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerExpandVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ControllerExpandVolumeRequest) error); ok {
		r1 = returnFunc(context1, controllerExpandVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_ControllerExpandVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerExpandVolume'
type MockControllerServer_ControllerExpandVolume_Call struct {
	*mock.Call
}

// ControllerExpandVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - controllerExpandVolumeRequest *csi.ControllerExpandVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerExpandVolume(context1 interface{}, controllerExpandVolumeRequest interface{}) *MockControllerServer_ControllerExpandVolume_Call {
	return &MockControllerServer_ControllerExpandVolume_Call{Call: _e.mock.On("ControllerExpandVolume", context1, controllerExpandVolumeRequest)}
}

func (_c *MockControllerServer_ControllerExpandVolume_Call) Run(run func(context1 context.Context, controllerExpandVolumeRequest *csi.ControllerExpandVolumeRequest)) *MockControllerServer_ControllerExpandVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ControllerExpandVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ControllerExpandVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_ControllerExpandVolume_Call) Return(controllerExpandVolumeResponse *csi.ControllerExpandVolumeResponse, err error) *MockControllerServer_ControllerExpandVolume_Call {
	_c.Call.Return(controllerExpandVolumeResponse, err)
	return _c
}

func (_c *MockControllerServer_ControllerExpandVolume_Call) RunAndReturn(run func(context1 context.Context, controllerExpandVolumeRequest *csi.ControllerExpandVolumeRequest) (*csi.ControllerExpandVolumeResponse, error)) *MockControllerServer_ControllerExpandVolume_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerGetCapabilities provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) ControllerGetCapabilities(context1 context.Context, controllerGetCapabilitiesRequest *csi.ControllerGetCapabilitiesRequest) (*csi.ControllerGetCapabilitiesResponse, error) {
	ret := _mock.Called(context1, controllerGetCapabilitiesRequest)

	if len(ret) == 0 {
		panic("no return value specified for ControllerGetCapabilities")
	}

	var r0 *csi.ControllerGetCapabilitiesResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerGetCapabilitiesRequest) (*csi.ControllerGetCapabilitiesResponse, error)); ok {
		return returnFunc(context1, controllerGetCapabilitiesRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerGetCapabilitiesRequest) *csi.ControllerGetCapabilitiesResponse); ok {
		r0 = returnFunc(context1, controllerGetCapabilitiesRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerGetCapabilitiesResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ControllerGetCapabilitiesRequest) error); ok {
		r1 = returnFunc(context1, controllerGetCapabilitiesRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_ControllerGetCapabilities_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerGetCapabilities'
type MockControllerServer_ControllerGetCapabilities_Call struct {
	*mock.Call
}

// ControllerGetCapabilities is a helper method to define mock.On call
//   - context1 context.Context
//   - controllerGetCapabilitiesRequest *csi.ControllerGetCapabilitiesRequest
func (_e *MockControllerServer_Expecter) ControllerGetCapabilities(context1 interface{}, controllerGetCapabilitiesRequest interface{}) *MockControllerServer_ControllerGetCapabilities_Call {
	return &MockControllerServer_ControllerGetCapabilities_Call{Call: _e.mock.On("ControllerGetCapabilities", context1, controllerGetCapabilitiesRequest)}
}

func (_c *MockControllerServer_ControllerGetCapabilities_Call) Run(run func(context1 context.Context, controllerGetCapabilitiesRequest *csi.ControllerGetCapabilitiesRequest)) *MockControllerServer_ControllerGetCapabilities_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ControllerGetCapabilitiesRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ControllerGetCapabilitiesRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_ControllerGetCapabilities_Call) Return(controllerGetCapabilitiesResponse *csi.ControllerGetCapabilitiesResponse, err error) *MockControllerServer_ControllerGetCapabilities_Call {
	_c.Call.Return(controllerGetCapabilitiesResponse, err)
	return _c
}

func (_c *MockControllerServer_ControllerGetCapabilities_Call) RunAndReturn(run func(context1 context.Context, controllerGetCapabilitiesRequest *csi.ControllerGetCapabilitiesRequest) (*csi.ControllerGetCapabilitiesResponse, error)) *MockControllerServer_ControllerGetCapabilities_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerGetVolume provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) ControllerGetVolume(context1 context.Context, controllerGetVolumeRequest *csi.ControllerGetVolumeRequest) (*csi.ControllerGetVolumeResponse, error) {
	ret := _mock.Called(context1, controllerGetVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for ControllerGetVolume")
	}

	var r0 *csi.ControllerGetVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerGetVolumeRequest) (*csi.ControllerGetVolumeResponse, error)); ok {
		return returnFunc(context1, controllerGetVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerGetVolumeRequest) *csi.ControllerGetVolumeResponse); ok {
		r0 = returnFunc(context1, controllerGetVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerGetVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ControllerGetVolumeRequest) error); ok {
		r1 = returnFunc(context1, controllerGetVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_ControllerGetVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerGetVolume'
type MockControllerServer_ControllerGetVolume_Call struct {
	*mock.Call
}

// ControllerGetVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - controllerGetVolumeRequest *csi.ControllerGetVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerGetVolume(context1 interface{}, controllerGetVolumeRequest interface{}) *MockControllerServer_ControllerGetVolume_Call {
	return &MockControllerServer_ControllerGetVolume_Call{Call: _e.mock.On("ControllerGetVolume", context1, controllerGetVolumeRequest)}
}

func (_c *MockControllerServer_ControllerGetVolume_Call) Run(run func(context1 context.Context, controllerGetVolumeRequest *csi.ControllerGetVolumeRequest)) *MockControllerServer_ControllerGetVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ControllerGetVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ControllerGetVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_ControllerGetVolume_Call) Return(controllerGetVolumeResponse *csi.ControllerGetVolumeResponse, err error) *MockControllerServer_ControllerGetVolume_Call {
	_c.Call.Return(controllerGetVolumeResponse, err)
	return _c
}

func (_c *MockControllerServer_ControllerGetVolume_Call) RunAndReturn(run func(context1 context.Context, controllerGetVolumeRequest *csi.ControllerGetVolumeRequest) (*csi.ControllerGetVolumeResponse, error)) *MockControllerServer_ControllerGetVolume_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerModifyVolume provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) ControllerModifyVolume(context1 context.Context, controllerModifyVolumeRequest *csi.ControllerModifyVolumeRequest) (*csi.ControllerModifyVolumeResponse, error) {
	ret := _mock.Called(context1, controllerModifyVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for ControllerModifyVolume")
	}

	var r0 *csi.ControllerModifyVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerModifyVolumeRequest) (*csi.ControllerModifyVolumeResponse, error)); ok {
		return returnFunc(context1, controllerModifyVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerModifyVolumeRequest) *csi.ControllerModifyVolumeResponse); ok {
		r0 = returnFunc(context1, controllerModifyVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerModifyVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ControllerModifyVolumeRequest) error); ok {
		r1 = returnFunc(context1, controllerModifyVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_ControllerModifyVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerModifyVolume'
type MockControllerServer_ControllerModifyVolume_Call struct {
	*mock.Call
}

// ControllerModifyVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - controllerModifyVolumeRequest *csi.ControllerModifyVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerModifyVolume(context1 interface{}, controllerModifyVolumeRequest interface{}) *MockControllerServer_ControllerModifyVolume_Call {
	return &MockControllerServer_ControllerModifyVolume_Call{Call: _e.mock.On("ControllerModifyVolume", context1, controllerModifyVolumeRequest)}
}

func (_c *MockControllerServer_ControllerModifyVolume_Call) Run(run func(context1 context.Context, controllerModifyVolumeRequest *csi.ControllerModifyVolumeRequest)) *MockControllerServer_ControllerModifyVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ControllerModifyVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ControllerModifyVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_ControllerModifyVolume_Call) Return(controllerModifyVolumeResponse *csi.ControllerModifyVolumeResponse, err error) *MockControllerServer_ControllerModifyVolume_Call {
	_c.Call.Return(controllerModifyVolumeResponse, err)
	return _c
}

func (_c *MockControllerServer_ControllerModifyVolume_Call) RunAndReturn(run func(context1 context.Context, controllerModifyVolumeRequest *csi.ControllerModifyVolumeRequest) (*csi.ControllerModifyVolumeResponse, error)) *MockControllerServer_ControllerModifyVolume_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerPublishVolume provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) ControllerPublishVolume(context1 context.Context, controllerPublishVolumeRequest *csi.ControllerPublishVolumeRequest) (*csi.ControllerPublishVolumeResponse, error) {
	ret := _mock.Called(context1, controllerPublishVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for ControllerPublishVolume")
	}

	var r0 *csi.ControllerPublishVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerPublishVolumeRequest) (*csi.ControllerPublishVolumeResponse, error)); ok {
		return returnFunc(context1, controllerPublishVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerPublishVolumeRequest) *csi.ControllerPublishVolumeResponse); ok {
		r0 = returnFunc(context1, controllerPublishVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerPublishVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ControllerPublishVolumeRequest) error); ok {
		r1 = returnFunc(context1, controllerPublishVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_ControllerPublishVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerPublishVolume'
type MockControllerServer_ControllerPublishVolume_Call struct {
	*mock.Call
}

// ControllerPublishVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - controllerPublishVolumeRequest *csi.ControllerPublishVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerPublishVolume(context1 interface{}, controllerPublishVolumeRequest interface{}) *MockControllerServer_ControllerPublishVolume_Call {
	return &MockControllerServer_ControllerPublishVolume_Call{Call: _e.mock.On("ControllerPublishVolume", context1, controllerPublishVolumeRequest)}
}

func (_c *MockControllerServer_ControllerPublishVolume_Call) Run(run func(context1 context.Context, controllerPublishVolumeRequest *csi.ControllerPublishVolumeRequest)) *MockControllerServer_ControllerPublishVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ControllerPublishVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ControllerPublishVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_ControllerPublishVolume_Call) Return(controllerPublishVolumeResponse *csi.ControllerPublishVolumeResponse, err error) *MockControllerServer_ControllerPublishVolume_Call {
	_c.Call.Return(controllerPublishVolumeResponse, err)
	return _c
}

func (_c *MockControllerServer_ControllerPublishVolume_Call) RunAndReturn(run func(context1 context.Context, controllerPublishVolumeRequest *csi.ControllerPublishVolumeRequest) (*csi.ControllerPublishVolumeResponse, error)) *MockControllerServer_ControllerPublishVolume_Call {
	_c.Call.Return(run)
	return _c
}

// ControllerUnpublishVolume provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) ControllerUnpublishVolume(context1 context.Context, controllerUnpublishVolumeRequest *csi.ControllerUnpublishVolumeRequest) (*csi.ControllerUnpublishVolumeResponse, error) {
	ret := _mock.Called(context1, controllerUnpublishVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for ControllerUnpublishVolume")
	}

	var r0 *csi.ControllerUnpublishVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerUnpublishVolumeRequest) (*csi.ControllerUnpublishVolumeResponse, error)); ok {
		return returnFunc(context1, controllerUnpublishVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ControllerUnpublishVolumeRequest) *csi.ControllerUnpublishVolumeResponse); ok {
		r0 = returnFunc(context1, controllerUnpublishVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ControllerUnpublishVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ControllerUnpublishVolumeRequest) error); ok {
		r1 = returnFunc(context1, controllerUnpublishVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_ControllerUnpublishVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ControllerUnpublishVolume'
type MockControllerServer_ControllerUnpublishVolume_Call struct {
	*mock.Call
}

// ControllerUnpublishVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - controllerUnpublishVolumeRequest *csi.ControllerUnpublishVolumeRequest
func (_e *MockControllerServer_Expecter) ControllerUnpublishVolume(context1 interface{}, controllerUnpublishVolumeRequest interface{}) *MockControllerServer_ControllerUnpublishVolume_Call {
	return &MockControllerServer_ControllerUnpublishVolume_Call{Call: _e.mock.On("ControllerUnpublishVolume", context1, controllerUnpublishVolumeRequest)}
}

func (_c *MockControllerServer_ControllerUnpublishVolume_Call) Run(run func(context1 context.Context, controllerUnpublishVolumeRequest *csi.ControllerUnpublishVolumeRequest)) *MockControllerServer_ControllerUnpublishVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ControllerUnpublishVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ControllerUnpublishVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_ControllerUnpublishVolume_Call) Return(controllerUnpublishVolumeResponse *csi.ControllerUnpublishVolumeResponse, err error) *MockControllerServer_ControllerUnpublishVolume_Call {
	_c.Call.Return(controllerUnpublishVolumeResponse, err)
	return _c
}

func (_c *MockControllerServer_ControllerUnpublishVolume_Call) RunAndReturn(run func(context1 context.Context, controllerUnpublishVolumeRequest *csi.ControllerUnpublishVolumeRequest) (*csi.ControllerUnpublishVolumeResponse, error)) *MockControllerServer_ControllerUnpublishVolume_Call {
	_c.Call.Return(run)
	return _c
}

// CreateSnapshot provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) CreateSnapshot(context1 context.Context, createSnapshotRequest *csi.CreateSnapshotRequest) (*csi.CreateSnapshotResponse, error) {
	ret := _mock.Called(context1, createSnapshotRequest)

	if len(ret) == 0 {
		panic("no return value specified for CreateSnapshot")
	}

	var r0 *csi.CreateSnapshotResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.CreateSnapshotRequest) (*csi.CreateSnapshotResponse, error)); ok {
		return returnFunc(context1, createSnapshotRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.CreateSnapshotRequest) *csi.CreateSnapshotResponse); ok {
		r0 = returnFunc(context1, createSnapshotRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.CreateSnapshotResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.CreateSnapshotRequest) error); ok {
		r1 = returnFunc(context1, createSnapshotRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_CreateSnapshot_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CreateSnapshot'
type MockControllerServer_CreateSnapshot_Call struct {
	*mock.Call
}

// CreateSnapshot is a helper method to define mock.On call
//   - context1 context.Context
//   - createSnapshotRequest *csi.CreateSnapshotRequest
func (_e *MockControllerServer_Expecter) CreateSnapshot(context1 interface{}, createSnapshotRequest interface{}) *MockControllerServer_CreateSnapshot_Call {
	return &MockControllerServer_CreateSnapshot_Call{Call: _e.mock.On("CreateSnapshot", context1, createSnapshotRequest)}
}

func (_c *MockControllerServer_CreateSnapshot_Call) Run(run func(context1 context.Context, createSnapshotRequest *csi.CreateSnapshotRequest)) *MockControllerServer_CreateSnapshot_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.CreateSnapshotRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.CreateSnapshotRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_CreateSnapshot_Call) Return(createSnapshotResponse *csi.CreateSnapshotResponse, err error) *MockControllerServer_CreateSnapshot_Call {
	_c.Call.Return(createSnapshotResponse, err)
	return _c
}

func (_c *MockControllerServer_CreateSnapshot_Call) RunAndReturn(run func(context1 context.Context, createSnapshotRequest *csi.CreateSnapshotRequest) (*csi.CreateSnapshotResponse, error)) *MockControllerServer_CreateSnapshot_Call {
	_c.Call.Return(run)
	return _c
}

// CreateVolume provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) CreateVolume(context1 context.Context, createVolumeRequest *csi.CreateVolumeRequest) (*csi.CreateVolumeResponse, error) {
	ret := _mock.Called(context1, createVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for CreateVolume")
	}

	var r0 *csi.CreateVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.CreateVolumeRequest) (*csi.CreateVolumeResponse, error)); ok {
		return returnFunc(context1, createVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.CreateVolumeRequest) *csi.CreateVolumeResponse); ok {
		r0 = returnFunc(context1, createVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.CreateVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.CreateVolumeRequest) error); ok {
		r1 = returnFunc(context1, createVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_CreateVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'CreateVolume'
type MockControllerServer_CreateVolume_Call struct {
	*mock.Call
}

// CreateVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - createVolumeRequest *csi.CreateVolumeRequest
func (_e *MockControllerServer_Expecter) CreateVolume(context1 interface{}, createVolumeRequest interface{}) *MockControllerServer_CreateVolume_Call {
	return &MockControllerServer_CreateVolume_Call{Call: _e.mock.On("CreateVolume", context1, createVolumeRequest)}
}

func (_c *MockControllerServer_CreateVolume_Call) Run(run func(context1 context.Context, createVolumeRequest *csi.CreateVolumeRequest)) *MockControllerServer_CreateVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.CreateVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.CreateVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_CreateVolume_Call) Return(createVolumeResponse *csi.CreateVolumeResponse, err error) *MockControllerServer_CreateVolume_Call {
	_c.Call.Return(createVolumeResponse, err)
	return _c
}

func (_c *MockControllerServer_CreateVolume_Call) RunAndReturn(run func(context1 context.Context, createVolumeRequest *csi.CreateVolumeRequest) (*csi.CreateVolumeResponse, error)) *MockControllerServer_CreateVolume_Call {
	_c.Call.Return(run)
	return _c
}

// DeleteSnapshot provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) DeleteSnapshot(context1 context.Context, deleteSnapshotRequest *csi.DeleteSnapshotRequest) (*csi.DeleteSnapshotResponse, error) {
	ret := _mock.Called(context1, deleteSnapshotRequest)

	if len(ret) == 0 {
		panic("no return value specified for DeleteSnapshot")
	}

	var r0 *csi.DeleteSnapshotResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.DeleteSnapshotRequest) (*csi.DeleteSnapshotResponse, error)); ok {
		return returnFunc(context1, deleteSnapshotRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.DeleteSnapshotRequest) *csi.DeleteSnapshotResponse); ok {
		r0 = returnFunc(context1, deleteSnapshotRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.DeleteSnapshotResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.DeleteSnapshotRequest) error); ok {
		r1 = returnFunc(context1, deleteSnapshotRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_DeleteSnapshot_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeleteSnapshot'
type MockControllerServer_DeleteSnapshot_Call struct {
	*mock.Call
}

// DeleteSnapshot is a helper method to define mock.On call
//   - context1 context.Context
//   - deleteSnapshotRequest *csi.DeleteSnapshotRequest
func (_e *MockControllerServer_Expecter) DeleteSnapshot(context1 interface{}, deleteSnapshotRequest interface{}) *MockControllerServer_DeleteSnapshot_Call {
	return &MockControllerServer_DeleteSnapshot_Call{Call: _e.mock.On("DeleteSnapshot", context1, deleteSnapshotRequest)}
}

func (_c *MockControllerServer_DeleteSnapshot_Call) Run(run func(context1 context.Context, deleteSnapshotRequest *csi.DeleteSnapshotRequest)) *MockControllerServer_DeleteSnapshot_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.DeleteSnapshotRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.DeleteSnapshotRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_DeleteSnapshot_Call) Return(deleteSnapshotResponse *csi.DeleteSnapshotResponse, err error) *MockControllerServer_DeleteSnapshot_Call {
	_c.Call.Return(deleteSnapshotResponse, err)
	return _c
}

func (_c *MockControllerServer_DeleteSnapshot_Call) RunAndReturn(run func(context1 context.Context, deleteSnapshotRequest *csi.DeleteSnapshotRequest) (*csi.DeleteSnapshotResponse, error)) *MockControllerServer_DeleteSnapshot_Call {
	_c.Call.Return(run)
	return _c
}

// DeleteVolume provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) DeleteVolume(context1 context.Context, deleteVolumeRequest *csi.DeleteVolumeRequest) (*csi.DeleteVolumeResponse, error) {
	ret := _mock.Called(context1, deleteVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for DeleteVolume")
	}

	var r0 *csi.DeleteVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.DeleteVolumeRequest) (*csi.DeleteVolumeResponse, error)); ok {
		return returnFunc(context1, deleteVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.DeleteVolumeRequest) *csi.DeleteVolumeResponse); ok {
		r0 = returnFunc(context1, deleteVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.DeleteVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.DeleteVolumeRequest) error); ok {
		r1 = returnFunc(context1, deleteVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_DeleteVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DeleteVolume'
type MockControllerServer_DeleteVolume_Call struct {
	*mock.Call
}

// DeleteVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - deleteVolumeRequest *csi.DeleteVolumeRequest
func (_e *MockControllerServer_Expecter) DeleteVolume(context1 interface{}, deleteVolumeRequest interface{}) *MockControllerServer_DeleteVolume_Call {
	return &MockControllerServer_DeleteVolume_Call{Call: _e.mock.On("DeleteVolume", context1, deleteVolumeRequest)}
}

func (_c *MockControllerServer_DeleteVolume_Call) Run(run func(context1 context.Context, deleteVolumeRequest *csi.DeleteVolumeRequest)) *MockControllerServer_DeleteVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.DeleteVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.DeleteVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_DeleteVolume_Call) Return(deleteVolumeResponse *csi.DeleteVolumeResponse, err error) *MockControllerServer_DeleteVolume_Call {
	_c.Call.Return(deleteVolumeResponse, err)
	return _c
}

func (_c *MockControllerServer_DeleteVolume_Call) RunAndReturn(run func(context1 context.Context, deleteVolumeRequest *csi.DeleteVolumeRequest) (*csi.DeleteVolumeResponse, error)) *MockControllerServer_DeleteVolume_Call {
	_c.Call.Return(run)
	return _c
}

// GetCapacity provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) GetCapacity(context1 context.Context, getCapacityRequest *csi.GetCapacityRequest) (*csi.GetCapacityResponse, error) {
	ret := _mock.Called(context1, getCapacityRequest)

	if len(ret) == 0 {
		panic("no return value specified for GetCapacity")
	}

	var r0 *csi.GetCapacityResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.GetCapacityRequest) (*csi.GetCapacityResponse, error)); ok {
		return returnFunc(context1, getCapacityRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.GetCapacityRequest) *csi.GetCapacityResponse); ok {
		r0 = returnFunc(context1, getCapacityRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.GetCapacityResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.GetCapacityRequest) error); ok {
		r1 = returnFunc(context1, getCapacityRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_GetCapacity_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetCapacity'
type MockControllerServer_GetCapacity_Call struct {
	*mock.Call
}

// GetCapacity is a helper method to define mock.On call
//   - context1 context.Context
//   - getCapacityRequest *csi.GetCapacityRequest
func (_e *MockControllerServer_Expecter) GetCapacity(context1 interface{}, getCapacityRequest interface{}) *MockControllerServer_GetCapacity_Call {
	return &MockControllerServer_GetCapacity_Call{Call: _e.mock.On("GetCapacity", context1, getCapacityRequest)}
}

func (_c *MockControllerServer_GetCapacity_Call) Run(run func(context1 context.Context, getCapacityRequest *csi.GetCapacityRequest)) *MockControllerServer_GetCapacity_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.GetCapacityRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.GetCapacityRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_GetCapacity_Call) Return(getCapacityResponse *csi.GetCapacityResponse, err error) *MockControllerServer_GetCapacity_Call {
	_c.Call.Return(getCapacityResponse, err)
	return _c
}

func (_c *MockControllerServer_GetCapacity_Call) RunAndReturn(run func(context1 context.Context, getCapacityRequest *csi.GetCapacityRequest) (*csi.GetCapacityResponse, error)) *MockControllerServer_GetCapacity_Call {
	_c.Call.Return(run)
	return _c
}

// ListSnapshots provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) ListSnapshots(context1 context.Context, listSnapshotsRequest *csi.ListSnapshotsRequest) (*csi.ListSnapshotsResponse, error) {
	ret := _mock.Called(context1, listSnapshotsRequest)

	if len(ret) == 0 {
		panic("no return value specified for ListSnapshots")
	}

	var r0 *csi.ListSnapshotsResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ListSnapshotsRequest) (*csi.ListSnapshotsResponse, error)); ok {
		return returnFunc(context1, listSnapshotsRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ListSnapshotsRequest) *csi.ListSnapshotsResponse); ok {
		r0 = returnFunc(context1, listSnapshotsRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ListSnapshotsResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ListSnapshotsRequest) error); ok {
		r1 = returnFunc(context1, listSnapshotsRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_ListSnapshots_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ListSnapshots'
type MockControllerServer_ListSnapshots_Call struct {
	*mock.Call
}

// ListSnapshots is a helper method to define mock.On call
//   - context1 context.Context
//   - listSnapshotsRequest *csi.ListSnapshotsRequest
func (_e *MockControllerServer_Expecter) ListSnapshots(context1 interface{}, listSnapshotsRequest interface{}) *MockControllerServer_ListSnapshots_Call {
	return &MockControllerServer_ListSnapshots_Call{Call: _e.mock.On("ListSnapshots", context1, listSnapshotsRequest)}
}

func (_c *MockControllerServer_ListSnapshots_Call) Run(run func(context1 context.Context, listSnapshotsRequest *csi.ListSnapshotsRequest)) *MockControllerServer_ListSnapshots_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ListSnapshotsRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ListSnapshotsRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_ListSnapshots_Call) Return(listSnapshotsResponse *csi.ListSnapshotsResponse, err error) *MockControllerServer_ListSnapshots_Call {
	_c.Call.Return(listSnapshotsResponse, err)
	return _c
}

func (_c *MockControllerServer_ListSnapshots_Call) RunAndReturn(run func(context1 context.Context, listSnapshotsRequest *csi.ListSnapshotsRequest) (*csi.ListSnapshotsResponse, error)) *MockControllerServer_ListSnapshots_Call {
	_c.Call.Return(run)
	return _c
}

// ListVolumes provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) ListVolumes(context1 context.Context, listVolumesRequest *csi.ListVolumesRequest) (*csi.ListVolumesResponse, error) {
	ret := _mock.Called(context1, listVolumesRequest)

	if len(ret) == 0 {
		panic("no return value specified for ListVolumes")
	}

	var r0 *csi.ListVolumesResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ListVolumesRequest) (*csi.ListVolumesResponse, error)); ok {
		return returnFunc(context1, listVolumesRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ListVolumesRequest) *csi.ListVolumesResponse); ok {
		r0 = returnFunc(context1, listVolumesRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ListVolumesResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ListVolumesRequest) error); ok {
		r1 = returnFunc(context1, listVolumesRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_ListVolumes_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ListVolumes'
type MockControllerServer_ListVolumes_Call struct {
	*mock.Call
}

// ListVolumes is a helper method to define mock.On call
//   - context1 context.Context
//   - listVolumesRequest *csi.ListVolumesRequest
func (_e *MockControllerServer_Expecter) ListVolumes(context1 interface{}, listVolumesRequest interface{}) *MockControllerServer_ListVolumes_Call {
	return &MockControllerServer_ListVolumes_Call{Call: _e.mock.On("ListVolumes", context1, listVolumesRequest)}
}

func (_c *MockControllerServer_ListVolumes_Call) Run(run func(context1 context.Context, listVolumesRequest *csi.ListVolumesRequest)) *MockControllerServer_ListVolumes_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ListVolumesRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ListVolumesRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_ListVolumes_Call) Return(listVolumesResponse *csi.ListVolumesResponse, err error) *MockControllerServer_ListVolumes_Call {
	_c.Call.Return(listVolumesResponse, err)
	return _c
}

func (_c *MockControllerServer_ListVolumes_Call) RunAndReturn(run func(context1 context.Context, listVolumesRequest *csi.ListVolumesRequest) (*csi.ListVolumesResponse, error)) *MockControllerServer_ListVolumes_Call {
	_c.Call.Return(run)
	return _c
}

// ValidateVolumeCapabilities provides a mock function for the type MockControllerServer
func (_mock *MockControllerServer) ValidateVolumeCapabilities(context1 context.Context, validateVolumeCapabilitiesRequest *csi.ValidateVolumeCapabilitiesRequest) (*csi.ValidateVolumeCapabilitiesResponse, error) {
	ret := _mock.Called(context1, validateVolumeCapabilitiesRequest)

	if len(ret) == 0 {
		panic("no return value specified for ValidateVolumeCapabilities")
	}

	var r0 *csi.ValidateVolumeCapabilitiesResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ValidateVolumeCapabilitiesRequest) (*csi.ValidateVolumeCapabilitiesResponse, error)); ok {
		return returnFunc(context1, validateVolumeCapabilitiesRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.ValidateVolumeCapabilitiesRequest) *csi.ValidateVolumeCapabilitiesResponse); ok {
		r0 = returnFunc(context1, validateVolumeCapabilitiesRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.ValidateVolumeCapabilitiesResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.ValidateVolumeCapabilitiesRequest) error); ok {
		r1 = returnFunc(context1, validateVolumeCapabilitiesRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockControllerServer_ValidateVolumeCapabilities_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ValidateVolumeCapabilities'
type MockControllerServer_ValidateVolumeCapabilities_Call struct {
	*mock.Call
}

// ValidateVolumeCapabilities is a helper method to define mock.On call
//   - context1 context.Context
//   - validateVolumeCapabilitiesRequest *csi.ValidateVolumeCapabilitiesRequest
func (_e *MockControllerServer_Expecter) ValidateVolumeCapabilities(context1 interface{}, validateVolumeCapabilitiesRequest interface{}) *MockControllerServer_ValidateVolumeCapabilities_Call {
	return &MockControllerServer_ValidateVolumeCapabilities_Call{Call: _e.mock.On("ValidateVolumeCapabilities", context1, validateVolumeCapabilitiesRequest)}
}

func (_c *MockControllerServer_ValidateVolumeCapabilities_Call) Run(run func(context1 context.Context, validateVolumeCapabilitiesRequest *csi.ValidateVolumeCapabilitiesRequest)) *MockControllerServer_ValidateVolumeCapabilities_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.ValidateVolumeCapabilitiesRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.ValidateVolumeCapabilitiesRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockControllerServer_ValidateVolumeCapabilities_Call) Return(validateVolumeCapabilitiesResponse *csi.ValidateVolumeCapabilitiesResponse, err error) *MockControllerServer_ValidateVolumeCapabilities_Call {
	_c.Call.Return(validateVolumeCapabilitiesResponse, err)
	return _c
}

func (_c *MockControllerServer_ValidateVolumeCapabilities_Call) RunAndReturn(run func(context1 context.Context, validateVolumeCapabilitiesRequest *csi.ValidateVolumeCapabilitiesRequest) (*csi.ValidateVolumeCapabilitiesResponse, error)) *MockControllerServer_ValidateVolumeCapabilities_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockNodeServer creates a new instance of MockNodeServer. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockNodeServer(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockNodeServer {
	mock := &MockNodeServer{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockNodeServer is an autogenerated mock type for the NodeServer type
type MockNodeServer struct {
	mock.Mock
}

type MockNodeServer_Expecter struct {
	mock *mock.Mock
}

func (_m *MockNodeServer) EXPECT() *MockNodeServer_Expecter {
	return &MockNodeServer_Expecter{mock: &_m.Mock}
}

// NodeExpandVolume provides a mock function for the type MockNodeServer
func (_mock *MockNodeServer) NodeExpandVolume(context1 context.Context, nodeExpandVolumeRequest *csi.NodeExpandVolumeRequest) (*csi.NodeExpandVolumeResponse, error) {
	ret := _mock.Called(context1, nodeExpandVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for NodeExpandVolume")
	}

	var r0 *csi.NodeExpandVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeExpandVolumeRequest) (*csi.NodeExpandVolumeResponse, error)); ok {
		return returnFunc(context1, nodeExpandVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeExpandVolumeRequest) *csi.NodeExpandVolumeResponse); ok {
		r0 = returnFunc(context1, nodeExpandVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.NodeExpandVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.NodeExpandVolumeRequest) error); ok {
		r1 = returnFunc(context1, nodeExpandVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockNodeServer_NodeExpandVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NodeExpandVolume'
type MockNodeServer_NodeExpandVolume_Call struct {
	*mock.Call
}

// NodeExpandVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - nodeExpandVolumeRequest *csi.NodeExpandVolumeRequest
func (_e *MockNodeServer_Expecter) NodeExpandVolume(context1 interface{}, nodeExpandVolumeRequest interface{}) *MockNodeServer_NodeExpandVolume_Call {
	return &MockNodeServer_NodeExpandVolume_Call{Call: _e.mock.On("NodeExpandVolume", context1, nodeExpandVolumeRequest)}
}

func (_c *MockNodeServer_NodeExpandVolume_Call) Run(run func(context1 context.Context, nodeExpandVolumeRequest *csi.NodeExpandVolumeRequest)) *MockNodeServer_NodeExpandVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.NodeExpandVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.NodeExpandVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockNodeServer_NodeExpandVolume_Call) Return(nodeExpandVolumeResponse *csi.NodeExpandVolumeResponse, err error) *MockNodeServer_NodeExpandVolume_Call {
	_c.Call.Return(nodeExpandVolumeResponse, err)
	return _c
}

func (_c *MockNodeServer_NodeExpandVolume_Call) RunAndReturn(run func(context1 context.Context, nodeExpandVolumeRequest *csi.NodeExpandVolumeRequest) (*csi.NodeExpandVolumeResponse, error)) *MockNodeServer_NodeExpandVolume_Call {
	_c.Call.Return(run)
	return _c
}

// NodeGetCapabilities provides a mock function for the type MockNodeServer
func (_mock *MockNodeServer) NodeGetCapabilities(context1 context.Context, nodeGetCapabilitiesRequest *csi.NodeGetCapabilitiesRequest) (*csi.NodeGetCapabilitiesResponse, error) {
	ret := _mock.Called(context1, nodeGetCapabilitiesRequest)

	if len(ret) == 0 {
		panic("no return value specified for NodeGetCapabilities")
	}

	var r0 *csi.NodeGetCapabilitiesResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeGetCapabilitiesRequest) (*csi.NodeGetCapabilitiesResponse, error)); ok {
		return returnFunc(context1, nodeGetCapabilitiesRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeGetCapabilitiesRequest) *csi.NodeGetCapabilitiesResponse); ok {
		r0 = returnFunc(context1, nodeGetCapabilitiesRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.NodeGetCapabilitiesResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.NodeGetCapabilitiesRequest) error); ok {
		r1 = returnFunc(context1, nodeGetCapabilitiesRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockNodeServer_NodeGetCapabilities_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NodeGetCapabilities'
type MockNodeServer_NodeGetCapabilities_Call struct {
	*mock.Call
}

// NodeGetCapabilities is a helper method to define mock.On call
//   - context1 context.Context
//   - nodeGetCapabilitiesRequest *csi.NodeGetCapabilitiesRequest
func (_e *MockNodeServer_Expecter) NodeGetCapabilities(context1 interface{}, nodeGetCapabilitiesRequest interface{}) *MockNodeServer_NodeGetCapabilities_Call {
	return &MockNodeServer_NodeGetCapabilities_Call{Call: _e.mock.On("NodeGetCapabilities", context1, nodeGetCapabilitiesRequest)}
}

func (_c *MockNodeServer_NodeGetCapabilities_Call) Run(run func(context1 context.Context, nodeGetCapabilitiesRequest *csi.NodeGetCapabilitiesRequest)) *MockNodeServer_NodeGetCapabilities_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.NodeGetCapabilitiesRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.NodeGetCapabilitiesRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockNodeServer_NodeGetCapabilities_Call) Return(nodeGetCapabilitiesResponse *csi.NodeGetCapabilitiesResponse, err error) *MockNodeServer_NodeGetCapabilities_Call {
	_c.Call.Return(nodeGetCapabilitiesResponse, err)
	return _c
}

func (_c *MockNodeServer_NodeGetCapabilities_Call) RunAndReturn(run func(context1 context.Context, nodeGetCapabilitiesRequest *csi.NodeGetCapabilitiesRequest) (*csi.NodeGetCapabilitiesResponse, error)) *MockNodeServer_NodeGetCapabilities_Call {
	_c.Call.Return(run)
	return _c
}

// NodeGetInfo provides a mock function for the type MockNodeServer
func (_mock *MockNodeServer) NodeGetInfo(context1 context.Context, nodeGetInfoRequest *csi.NodeGetInfoRequest) (*csi.NodeGetInfoResponse, error) {
	ret := _mock.Called(context1, nodeGetInfoRequest)

	if len(ret) == 0 {
		panic("no return value specified for NodeGetInfo")
	}

	var r0 *csi.NodeGetInfoResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeGetInfoRequest) (*csi.NodeGetInfoResponse, error)); ok {
		return returnFunc(context1, nodeGetInfoRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeGetInfoRequest) *csi.NodeGetInfoResponse); ok {
		r0 = returnFunc(context1, nodeGetInfoRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.NodeGetInfoResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.NodeGetInfoRequest) error); ok {
		r1 = returnFunc(context1, nodeGetInfoRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockNodeServer_NodeGetInfo_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NodeGetInfo'
type MockNodeServer_NodeGetInfo_Call struct {
	*mock.Call
}

// NodeGetInfo is a helper method to define mock.On call
//   - context1 context.Context
//   - nodeGetInfoRequest *csi.NodeGetInfoRequest
func (_e *MockNodeServer_Expecter) NodeGetInfo(context1 interface{}, nodeGetInfoRequest interface{}) *MockNodeServer_NodeGetInfo_Call {
	return &MockNodeServer_NodeGetInfo_Call{Call: _e.mock.On("NodeGetInfo", context1, nodeGetInfoRequest)}
}

func (_c *MockNodeServer_NodeGetInfo_Call) Run(run func(context1 context.Context, nodeGetInfoRequest *csi.NodeGetInfoRequest)) *MockNodeServer_NodeGetInfo_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.NodeGetInfoRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.NodeGetInfoRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockNodeServer_NodeGetInfo_Call) Return(nodeGetInfoResponse *csi.NodeGetInfoResponse, err error) *MockNodeServer_NodeGetInfo_Call {
	_c.Call.Return(nodeGetInfoResponse, err)
	return _c
}

func (_c *MockNodeServer_NodeGetInfo_Call) RunAndReturn(run func(context1 context.Context, nodeGetInfoRequest *csi.NodeGetInfoRequest) (*csi.NodeGetInfoResponse, error)) *MockNodeServer_NodeGetInfo_Call {
	_c.Call.Return(run)
	return _c
}

// NodeGetVolumeStats provides a mock function for the type MockNodeServer
func (_mock *MockNodeServer) NodeGetVolumeStats(context1 context.Context, nodeGetVolumeStatsRequest *csi.NodeGetVolumeStatsRequest) (*csi.NodeGetVolumeStatsResponse, error) {
	ret := _mock.Called(context1, nodeGetVolumeStatsRequest)

	if len(ret) == 0 {
		panic("no return value specified for NodeGetVolumeStats")
	}

	var r0 *csi.NodeGetVolumeStatsResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeGetVolumeStatsRequest) (*csi.NodeGetVolumeStatsResponse, error)); ok {
		return returnFunc(context1, nodeGetVolumeStatsRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeGetVolumeStatsRequest) *csi.NodeGetVolumeStatsResponse); ok {
		r0 = returnFunc(context1, nodeGetVolumeStatsRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.NodeGetVolumeStatsResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.NodeGetVolumeStatsRequest) error); ok {
		r1 = returnFunc(context1, nodeGetVolumeStatsRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockNodeServer_NodeGetVolumeStats_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NodeGetVolumeStats'
type MockNodeServer_NodeGetVolumeStats_Call struct {
	*mock.Call
}

// NodeGetVolumeStats is a helper method to define mock.On call
//   - context1 context.Context
//   - nodeGetVolumeStatsRequest *csi.NodeGetVolumeStatsRequest
func (_e *MockNodeServer_Expecter) NodeGetVolumeStats(context1 interface{}, nodeGetVolumeStatsRequest interface{}) *MockNodeServer_NodeGetVolumeStats_Call {
	return &MockNodeServer_NodeGetVolumeStats_Call{Call: _e.mock.On("NodeGetVolumeStats", context1, nodeGetVolumeStatsRequest)}
}

func (_c *MockNodeServer_NodeGetVolumeStats_Call) Run(run func(context1 context.Context, nodeGetVolumeStatsRequest *csi.NodeGetVolumeStatsRequest)) *MockNodeServer_NodeGetVolumeStats_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.NodeGetVolumeStatsRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.NodeGetVolumeStatsRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockNodeServer_NodeGetVolumeStats_Call) Return(nodeGetVolumeStatsResponse *csi.NodeGetVolumeStatsResponse, err error) *MockNodeServer_NodeGetVolumeStats_Call {
	_c.Call.Return(nodeGetVolumeStatsResponse, err)
	return _c
}

func (_c *MockNodeServer_NodeGetVolumeStats_Call) RunAndReturn(run func(context1 context.Context, nodeGetVolumeStatsRequest *csi.NodeGetVolumeStatsRequest) (*csi.NodeGetVolumeStatsResponse, error)) *MockNodeServer_NodeGetVolumeStats_Call {
	_c.Call.Return(run)
	return _c
}

// NodePublishVolume provides a mock function for the type MockNodeServer
func (_mock *MockNodeServer) NodePublishVolume(context1 context.Context, nodePublishVolumeRequest *csi.NodePublishVolumeRequest) (*csi.NodePublishVolumeResponse, error) {
	ret := _mock.Called(context1, nodePublishVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for NodePublishVolume")
	}

	var r0 *csi.NodePublishVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodePublishVolumeRequest) (*csi.NodePublishVolumeResponse, error)); ok {
		return returnFunc(context1, nodePublishVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodePublishVolumeRequest) *csi.NodePublishVolumeResponse); ok {
		r0 = returnFunc(context1, nodePublishVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.NodePublishVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.NodePublishVolumeRequest) error); ok {
		r1 = returnFunc(context1, nodePublishVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockNodeServer_NodePublishVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NodePublishVolume'
type MockNodeServer_NodePublishVolume_Call struct {
	*mock.Call
}

// NodePublishVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - nodePublishVolumeRequest *csi.NodePublishVolumeRequest
func (_e *MockNodeServer_Expecter) NodePublishVolume(context1 interface{}, nodePublishVolumeRequest interface{}) *MockNodeServer_NodePublishVolume_Call {
	return &MockNodeServer_NodePublishVolume_Call{Call: _e.mock.On("NodePublishVolume", context1, nodePublishVolumeRequest)}
}

func (_c *MockNodeServer_NodePublishVolume_Call) Run(run func(context1 context.Context, nodePublishVolumeRequest *csi.NodePublishVolumeRequest)) *MockNodeServer_NodePublishVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.NodePublishVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.NodePublishVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockNodeServer_NodePublishVolume_Call) Return(nodePublishVolumeResponse *csi.NodePublishVolumeResponse, err error) *MockNodeServer_NodePublishVolume_Call {
	_c.Call.Return(nodePublishVolumeResponse, err)
	return _c
}

func (_c *MockNodeServer_NodePublishVolume_Call) RunAndReturn(run func(context1 context.Context, nodePublishVolumeRequest *csi.NodePublishVolumeRequest) (*csi.NodePublishVolumeResponse, error)) *MockNodeServer_NodePublishVolume_Call {
	_c.Call.Return(run)
	return _c
}

// NodeStageVolume provides a mock function for the type MockNodeServer
func (_mock *MockNodeServer) NodeStageVolume(context1 context.Context, nodeStageVolumeRequest *csi.NodeStageVolumeRequest) (*csi.NodeStageVolumeResponse, error) {
	ret := _mock.Called(context1, nodeStageVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for NodeStageVolume")
	}

	var r0 *csi.NodeStageVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeStageVolumeRequest) (*csi.NodeStageVolumeResponse, error)); ok {
		return returnFunc(context1, nodeStageVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeStageVolumeRequest) *csi.NodeStageVolumeResponse); ok {
		r0 = returnFunc(context1, nodeStageVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.NodeStageVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.NodeStageVolumeRequest) error); ok {
		r1 = returnFunc(context1, nodeStageVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockNodeServer_NodeStageVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NodeStageVolume'
type MockNodeServer_NodeStageVolume_Call struct {
	*mock.Call
}

// NodeStageVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - nodeStageVolumeRequest *csi.NodeStageVolumeRequest
func (_e *MockNodeServer_Expecter) NodeStageVolume(context1 interface{}, nodeStageVolumeRequest interface{}) *MockNodeServer_NodeStageVolume_Call {
	return &MockNodeServer_NodeStageVolume_Call{Call: _e.mock.On("NodeStageVolume", context1, nodeStageVolumeRequest)}
}

func (_c *MockNodeServer_NodeStageVolume_Call) Run(run func(context1 context.Context, nodeStageVolumeRequest *csi.NodeStageVolumeRequest)) *MockNodeServer_NodeStageVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.NodeStageVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.NodeStageVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockNodeServer_NodeStageVolume_Call) Return(nodeStageVolumeResponse *csi.NodeStageVolumeResponse, err error) *MockNodeServer_NodeStageVolume_Call {
	_c.Call.Return(nodeStageVolumeResponse, err)
	return _c
}

func (_c *MockNodeServer_NodeStageVolume_Call) RunAndReturn(run func(context1 context.Context, nodeStageVolumeRequest *csi.NodeStageVolumeRequest) (*csi.NodeStageVolumeResponse, error)) *MockNodeServer_NodeStageVolume_Call {
	_c.Call.Return(run)
	return _c
}

// NodeUnpublishVolume provides a mock function for the type MockNodeServer
func (_mock *MockNodeServer) NodeUnpublishVolume(context1 context.Context, nodeUnpublishVolumeRequest *csi.NodeUnpublishVolumeRequest) (*csi.NodeUnpublishVolumeResponse, error) {
	ret := _mock.Called(context1, nodeUnpublishVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for NodeUnpublishVolume")
	}

	var r0 *csi.NodeUnpublishVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeUnpublishVolumeRequest) (*csi.NodeUnpublishVolumeResponse, error)); ok {
		return returnFunc(context1, nodeUnpublishVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeUnpublishVolumeRequest) *csi.NodeUnpublishVolumeResponse); ok {
		r0 = returnFunc(context1, nodeUnpublishVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.NodeUnpublishVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.NodeUnpublishVolumeRequest) error); ok {
		r1 = returnFunc(context1, nodeUnpublishVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockNodeServer_NodeUnpublishVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NodeUnpublishVolume'
type MockNodeServer_NodeUnpublishVolume_Call struct {
	*mock.Call
}

// NodeUnpublishVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - nodeUnpublishVolumeRequest *csi.NodeUnpublishVolumeRequest
func (_e *MockNodeServer_Expecter) NodeUnpublishVolume(context1 interface{}, nodeUnpublishVolumeRequest interface{}) *MockNodeServer_NodeUnpublishVolume_Call {
	return &MockNodeServer_NodeUnpublishVolume_Call{Call: _e.mock.On("NodeUnpublishVolume", context1, nodeUnpublishVolumeRequest)}
}

func (_c *MockNodeServer_NodeUnpublishVolume_Call) Run(run func(context1 context.Context, nodeUnpublishVolumeRequest *csi.NodeUnpublishVolumeRequest)) *MockNodeServer_NodeUnpublishVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.NodeUnpublishVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.NodeUnpublishVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockNodeServer_NodeUnpublishVolume_Call) Return(nodeUnpublishVolumeResponse *csi.NodeUnpublishVolumeResponse, err error) *MockNodeServer_NodeUnpublishVolume_Call {
	_c.Call.Return(nodeUnpublishVolumeResponse, err)
	return _c
}

func (_c *MockNodeServer_NodeUnpublishVolume_Call) RunAndReturn(run func(context1 context.Context, nodeUnpublishVolumeRequest *csi.NodeUnpublishVolumeRequest) (*csi.NodeUnpublishVolumeResponse, error)) *MockNodeServer_NodeUnpublishVolume_Call {
	_c.Call.Return(run)
	return _c
}

// NodeUnstageVolume provides a mock function for the type MockNodeServer
func (_mock *MockNodeServer) NodeUnstageVolume(context1 context.Context, nodeUnstageVolumeRequest *csi.NodeUnstageVolumeRequest) (*csi.NodeUnstageVolumeResponse, error) {
	ret := _mock.Called(context1, nodeUnstageVolumeRequest)

	if len(ret) == 0 {
		panic("no return value specified for NodeUnstageVolume")
	}

	var r0 *csi.NodeUnstageVolumeResponse
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeUnstageVolumeRequest) (*csi.NodeUnstageVolumeResponse, error)); ok {
		return returnFunc(context1, nodeUnstageVolumeRequest)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *csi.NodeUnstageVolumeRequest) *csi.NodeUnstageVolumeResponse); ok {
		r0 = returnFunc(context1, nodeUnstageVolumeRequest)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*csi.NodeUnstageVolumeResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *csi.NodeUnstageVolumeRequest) error); ok {
		r1 = returnFunc(context1, nodeUnstageVolumeRequest)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockNodeServer_NodeUnstageVolume_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NodeUnstageVolume'
type MockNodeServer_NodeUnstageVolume_Call struct {
	*mock.Call
}

// NodeUnstageVolume is a helper method to define mock.On call
//   - context1 context.Context
//   - nodeUnstageVolumeRequest *csi.NodeUnstageVolumeRequest
func (_e *MockNodeServer_Expecter) NodeUnstageVolume(context1 interface{}, nodeUnstageVolumeRequest interface{}) *MockNodeServer_NodeUnstageVolume_Call {
	return &MockNodeServer_NodeUnstageVolume_Call{Call: _e.mock.On("NodeUnstageVolume", context1, nodeUnstageVolumeRequest)}
}

func (_c *MockNodeServer_NodeUnstageVolume_Call) Run(run func(context1 context.Context, nodeUnstageVolumeRequest *csi.NodeUnstageVolumeRequest)) *MockNodeServer_NodeUnstageVolume_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *csi.NodeUnstageVolumeRequest
		if args[1] != nil {
			arg1 = args[1].(*csi.NodeUnstageVolumeRequest)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockNodeServer_NodeUnstageVolume_Call) Return(nodeUnstageVolumeResponse *csi.NodeUnstageVolumeResponse, err error) *MockNodeServer_NodeUnstageVolume_Call {
	_c.Call.Return(nodeUnstageVolumeResponse, err)
	return _c
}

func (_c *MockNodeServer_NodeUnstageVolume_Call) RunAndReturn(run func(context1 context.Context, nodeUnstageVolumeRequest *csi.NodeUnstageVolumeRequest) (*csi.NodeUnstageVolumeResponse, error)) *MockNodeServer_NodeUnstageVolume_Call {
	_c.Call.Return(run)
	return _c
}
