// SPDX-License-Identifier: GPL-2.0-or-later
/* ospfd memory type definitions
 *
 * Copyright (C) 2015  David Lamparter
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ospf_memory.h"

DEFINE_MGROUP(OSPFD, "ospfd");
DEFINE_MTYPE(OSPFD, OSPF_TOP, "OSPF top");
DEFINE_MTYPE(OSPFD, OSPF_AREA, "OSPF area");
DEFINE_MTYPE(OSPFD, OSPF_AREA_RANGE, "OSPF area range");
DEFINE_MTYPE(OSPFD, OSPF_NETWORK, "OSPF network");
DEFINE_MTYPE(OSPFD, OSPF_NEIGHBOR_STATIC, "OSPF static nbr");
DEFINE_MTYPE(OSPFD, OSPF_IF, "OSPF interface");
DEFINE_MTYPE(OSPFD, OSPF_NEIGHBOR, "OSPF neighbor");
DEFINE_MTYPE(OSPFD, OSPF_ROUTE, "OSPF route");
DEFINE_MTYPE(OSPFD, OSPF_TMP, "OSPF tmp mem");
DEFINE_MTYPE(OSPFD, OSPF_LSA, "OSPF LSA");
DEFINE_MTYPE(OSPFD, OSPF_LSA_DATA, "OSPF LSA data");
DEFINE_MTYPE(OSPFD, OSPF_LSDB, "OSPF LSDB");
DEFINE_MTYPE(OSPFD, OSPF_PACKET, "OSPF packet");
DEFINE_MTYPE(OSPFD, OSPF_FIFO, "OSPF FIFO queue");
DEFINE_MTYPE(OSPFD, OSPF_VERTEX, "OSPF vertex");
DEFINE_MTYPE(OSPFD, OSPF_VERTEX_PARENT, "OSPF vertex parent");
DEFINE_MTYPE(OSPFD, OSPF_NEXTHOP, "OSPF nexthop");
DEFINE_MTYPE(OSPFD, OSPF_PATH, "OSPF path");
DEFINE_MTYPE(OSPFD, OSPF_VL_DATA, "OSPF VL data");
DEFINE_MTYPE(OSPFD, OSPF_CRYPT_KEY, "OSPF crypt key");
DEFINE_MTYPE(OSPFD, OSPF_EXTERNAL_INFO, "OSPF ext. info");
DEFINE_MTYPE(OSPFD, OSPF_DISTANCE, "OSPF distance");
DEFINE_MTYPE(OSPFD, OSPF_IF_INFO, "OSPF if info");
DEFINE_MTYPE(OSPFD, OSPF_IF_PARAMS, "OSPF if params");
DEFINE_MTYPE(OSPFD, OSPF_MESSAGE, "OSPF message");
DEFINE_MTYPE(OSPFD, OSPF_MPLS_TE, "OSPF MPLS parameters");
DEFINE_MTYPE(OSPFD, OSPF_ROUTER_INFO, "OSPF Router Info parameters");
DEFINE_MTYPE(OSPFD, OSPF_PCE_PARAMS, "OSPF PCE parameters");
DEFINE_MTYPE(OSPFD, OSPF_EXT_PARAMS, "OSPF Extended parameters");
DEFINE_MTYPE(OSPFD, OSPF_SR_PARAMS, "OSPF Segment Routing parameters");
DEFINE_MTYPE(OSPFD, OSPF_GR_HELPER, "OSPF Graceful Restart Helper");
DEFINE_MTYPE(OSPFD, OSPF_EXTERNAL_RT_AGGR, "OSPF External Route Summarisation");
DEFINE_MTYPE(OSPFD, OSPF_P_SPACE, "OSPF TI-LFA P-Space");
DEFINE_MTYPE(OSPFD, OSPF_Q_SPACE, "OSPF TI-LFA Q-Space");
