// THIS FILE IS AUTOGENERATED.
// Any changes to this file will be overwritten.
// For more information about how codegen works, see font-codegen/README.md

#[allow(unused_imports)]
use crate::codegen_prelude::*;

/// The [Color Bitmap Data](https://learn.microsoft.com/en-us/typography/opentype/spec/cbdt) table
#[derive(Debug, Clone, Copy)]
#[doc(hidden)]
pub struct CbdtMarker {}

impl CbdtMarker {
    pub fn major_version_byte_range(&self) -> Range<usize> {
        let start = 0;
        start..start + u16::RAW_BYTE_LEN
    }

    pub fn minor_version_byte_range(&self) -> Range<usize> {
        let start = self.major_version_byte_range().end;
        start..start + u16::RAW_BYTE_LEN
    }
}

impl TopLevelTable for Cbdt<'_> {
    /// `CBDT`
    const TAG: Tag = Tag::new(b"CBDT");
}

impl<'a> FontRead<'a> for Cbdt<'a> {
    fn read(data: FontData<'a>) -> Result<Self, ReadError> {
        let mut cursor = data.cursor();
        cursor.advance::<u16>();
        cursor.advance::<u16>();
        cursor.finish(CbdtMarker {})
    }
}

/// The [Color Bitmap Data](https://learn.microsoft.com/en-us/typography/opentype/spec/cbdt) table
pub type Cbdt<'a> = TableRef<'a, CbdtMarker>;

#[allow(clippy::needless_lifetimes)]
impl<'a> Cbdt<'a> {
    /// Major version of the CBDT table, = 3.
    pub fn major_version(&self) -> u16 {
        let range = self.shape.major_version_byte_range();
        self.data.read_at(range.start).unwrap()
    }

    /// Minor version of CBDT table, = 0.
    pub fn minor_version(&self) -> u16 {
        let range = self.shape.minor_version_byte_range();
        self.data.read_at(range.start).unwrap()
    }
}

#[cfg(feature = "experimental_traverse")]
impl<'a> SomeTable<'a> for Cbdt<'a> {
    fn type_name(&self) -> &str {
        "Cbdt"
    }
    fn get_field(&self, idx: usize) -> Option<Field<'a>> {
        match idx {
            0usize => Some(Field::new("major_version", self.major_version())),
            1usize => Some(Field::new("minor_version", self.minor_version())),
            _ => None,
        }
    }
}

#[cfg(feature = "experimental_traverse")]
#[allow(clippy::needless_lifetimes)]
impl<'a> std::fmt::Debug for Cbdt<'a> {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        (self as &dyn SomeTable<'a>).fmt(f)
    }
}
