/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.reroute;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.master.IsAcknowledgedSupplier;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.xcontent.ToXContent;

public class ClusterRerouteResponse
extends ActionResponse
implements IsAcknowledgedSupplier,
ChunkedToXContentObject {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestSearchAction.class);
    public static final String STATE_FIELD_DEPRECATION_MESSAGE = "The [state] field in the response to the reroute API is deprecated and will be removed in a future version. Specify ?metric=none to adopt the future behaviour.";
    private final ClusterState state;
    private final RoutingExplanations explanations;
    private final boolean acknowledged;

    ClusterRerouteResponse(StreamInput in) throws IOException {
        super(in);
        this.acknowledged = in.readBoolean();
        this.state = ClusterState.readFrom(in, null);
        this.explanations = RoutingExplanations.readFrom(in);
    }

    ClusterRerouteResponse(boolean acknowledged, ClusterState state, RoutingExplanations explanations) {
        this.acknowledged = acknowledged;
        this.state = state;
        this.explanations = explanations;
    }

    public ClusterState getState() {
        return this.state;
    }

    public RoutingExplanations getExplanations() {
        return this.explanations;
    }

    @Override
    public final boolean isAcknowledged() {
        return this.acknowledged;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.acknowledged);
        this.state.writeTo(out);
        RoutingExplanations.writeTo(this.explanations, out);
    }

    private static boolean emitState(ToXContent.Params params) {
        return !Objects.equals(params.param("metric"), "none");
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        if (ClusterRerouteResponse.emitState(outerParams)) {
            deprecationLogger.critical(DeprecationCategory.API, "reroute_cluster_state", STATE_FIELD_DEPRECATION_MESSAGE, new Object[0]);
        }
        return Iterators.concat(Iterators.single((builder, params) -> builder.startObject().field("acknowledged", this.isAcknowledged())), ClusterRerouteResponse.emitState(outerParams) ? ChunkedToXContentHelper.object("state", this.state.toXContentChunked(outerParams)) : Collections.emptyIterator(), Iterators.single((builder, params) -> {
            if (params.paramAsBoolean("explain", false)) {
                this.explanations.toXContent(builder, params);
            }
            return builder.endObject();
        }));
    }
}

