/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.RemoteClusterStatsRequest;
import org.elasticsearch.action.admin.cluster.stats.RemoteClusterStatsResponse;
import org.elasticsearch.action.admin.cluster.stats.TransportClusterStatsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportRemoteClusterStatsAction
extends HandledTransportAction<RemoteClusterStatsRequest, RemoteClusterStatsResponse> {
    public static final String NAME = "cluster:monitor/stats/remote";
    public static final RemoteClusterActionType<RemoteClusterStatsResponse> REMOTE_TYPE = new RemoteClusterActionType<RemoteClusterStatsResponse>("cluster:monitor/stats/remote", RemoteClusterStatsResponse::new);
    private final Client client;
    private final TransportService transportService;

    @Inject
    public TransportRemoteClusterStatsAction(Client client, TransportService transportService, ActionFilters actionFilters) {
        super(NAME, transportService, actionFilters, RemoteClusterStatsRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.transportService = transportService;
    }

    @Override
    protected void doExecute(Task task, RemoteClusterStatsRequest request, ActionListener<RemoteClusterStatsResponse> listener) {
        new ParentTaskAssigningClient(this.client, this.transportService.getLocalNode(), task).execute(TransportClusterStatsAction.TYPE, ClusterStatsRequest.newRemoteClusterStatsRequest(), listener.map(clusterStatsResponse -> new RemoteClusterStatsResponse(clusterStatsResponse.getClusterUUID(), clusterStatsResponse.getStatus(), clusterStatsResponse.getNodesStats().getVersions(), clusterStatsResponse.getNodesStats().getCounts().getTotal(), clusterStatsResponse.getIndicesStats().getShards().getTotal(), clusterStatsResponse.getIndicesStats().getIndexCount(), clusterStatsResponse.getIndicesStats().getStore().sizeInBytes(), clusterStatsResponse.getNodesStats().getJvm().getHeapMax().getBytes(), clusterStatsResponse.getNodesStats().getOs().getMem().getTotal().getBytes())));
    }
}

