/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.master.TermOverridingStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public abstract class MasterNodeRequest<Request extends MasterNodeRequest<Request>>
extends ActionRequest {
    @Deprecated(forRemoval=true)
    public static final TimeValue TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT = TimeValue.timeValueSeconds((long)30L);
    public static final TimeValue INFINITE_MASTER_NODE_TIMEOUT = TimeValue.MINUS_ONE;
    private TimeValue masterNodeTimeout;
    private final long masterTerm;

    protected MasterNodeRequest(TimeValue masterNodeTimeout) {
        this.masterNodeTimeout = Objects.requireNonNull(masterNodeTimeout);
        this.masterTerm = 0L;
    }

    protected MasterNodeRequest(StreamInput in) throws IOException {
        super(in);
        this.masterNodeTimeout = in.readTimeValue();
        this.masterTerm = in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0) ? in.readVLong() : 0L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        long newMasterTerm = this.getNewMasterTerm(out);
        assert (this.hasReferences());
        assert (this.masterTerm <= newMasterTerm) : this.masterTerm + " vs " + newMasterTerm;
        super.writeTo(out);
        out.writeTimeValue(this.masterNodeTimeout);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
            out.writeVLong(newMasterTerm);
        }
    }

    private long getNewMasterTerm(StreamOutput out) {
        if (out instanceof TermOverridingStreamOutput) {
            TermOverridingStreamOutput termOverridingStreamOutput = (TermOverridingStreamOutput)out;
            return termOverridingStreamOutput.masterTerm;
        }
        return this.masterTerm;
    }

    public final Request masterNodeTimeout(TimeValue timeout) {
        this.masterNodeTimeout = Objects.requireNonNull(timeout);
        return (Request)this;
    }

    public final TimeValue masterNodeTimeout() {
        return this.masterNodeTimeout;
    }

    public final long masterTerm() {
        return this.masterTerm;
    }
}

