/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RerouteExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.command.BasePrimaryAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class AllocateStalePrimaryAllocationCommand
extends BasePrimaryAllocationCommand {
    public static final String NAME = "allocate_stale_primary";
    public static final ParseField COMMAND_NAME_FIELD = new ParseField("allocate_stale_primary", new String[0]);
    private static final ObjectParser<Builder, Void> STALE_PRIMARY_PARSER = BasePrimaryAllocationCommand.createAllocatePrimaryParser("allocate_stale_primary");

    public AllocateStalePrimaryAllocationCommand(String index, int shardId, String node, boolean acceptDataLoss) {
        super(index, shardId, node, acceptDataLoss);
    }

    public AllocateStalePrimaryAllocationCommand(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Optional<String> getMessage() {
        return Optional.of("allocated a stale primary for [" + this.index + "][" + this.shardId + "] on node [" + this.node + "] from user command");
    }

    public static AllocateStalePrimaryAllocationCommand fromXContent(XContentParser parser) throws IOException {
        return new Builder().parse(parser).build();
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        DiscoveryNode discoNode;
        try {
            discoNode = allocation.nodes().resolveNode(this.node);
        }
        catch (IllegalArgumentException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNode routingNode = routingNodes.node(discoNode.getId());
        if (routingNode == null) {
            return this.explainOrThrowMissingRoutingNode(allocation, explain, discoNode);
        }
        try {
            allocation.routingTable().shardRoutingTable(this.index, this.shardId).primaryShard();
        }
        catch (IndexNotFoundException | ShardNotFoundException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        ShardRouting shardRouting = null;
        for (ShardRouting shard : allocation.routingNodes().unassigned()) {
            if (!shard.getIndexName().equals(this.index) || shard.getId() != this.shardId || !shard.primary()) continue;
            shardRouting = shard;
            break;
        }
        if (shardRouting == null) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "primary [" + this.index + "][" + this.shardId + "] is already assigned");
        }
        if (!this.acceptDataLoss) {
            String dataLossWarning = "allocating an empty primary for [" + this.index + "][" + this.shardId + "] can result in data loss. Please confirm by setting the accept_data_loss parameter to true";
            return this.explainOrThrowRejectedCommand(explain, allocation, dataLossWarning);
        }
        if (shardRouting.recoverySource().getType() != RecoverySource.Type.EXISTING_STORE) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "trying to allocate an existing primary shard [" + this.index + "][" + this.shardId + "], while no such shard has ever been active");
        }
        this.initializeUnassignedShard(allocation, routingNodes, routingNode, shardRouting, null, RecoverySource.ExistingStoreRecoverySource.FORCE_STALE_PRIMARY_INSTANCE);
        return new RerouteExplanation(this, allocation.decision(Decision.YES, this.name() + " (allocation command)", "ignore deciders", new Object[0]));
    }

    public static class Builder
    extends BasePrimaryAllocationCommand.Builder<AllocateStalePrimaryAllocationCommand> {
        private Builder parse(XContentParser parser) throws IOException {
            return (Builder)STALE_PRIMARY_PARSER.parse(parser, (Object)this, null);
        }

        @Override
        public AllocateStalePrimaryAllocationCommand build() {
            this.validate();
            return new AllocateStalePrimaryAllocationCommand(this.index, this.shard, this.node, this.acceptDataLoss);
        }
    }
}

