/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.file;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.file.AbstractFileWatchingService;
import org.elasticsearch.gateway.GatewayService;

public abstract class MasterNodeFileWatchingService
extends AbstractFileWatchingService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(MasterNodeFileWatchingService.class);
    private final ClusterService clusterService;
    private volatile boolean active = false;

    protected MasterNodeFileWatchingService(ClusterService clusterService, Path watchedFile) {
        super(watchedFile);
        this.clusterService = clusterService;
    }

    @Override
    protected void doStart() {
        this.active = this.filesExists(this.watchedFileDir().getParent());
        if (!this.active) {
            return;
        }
        if (DiscoveryNode.isMasterNode(this.clusterService.getSettings())) {
            this.clusterService.addListener(this);
        }
    }

    @Override
    protected void doStop() {
        this.active = false;
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clusterChanged(ClusterChangedEvent event) {
        ClusterState clusterState = event.state();
        if (clusterState.nodes().isLocalNodeElectedMaster() && !clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            MasterNodeFileWatchingService masterNodeFileWatchingService = this;
            synchronized (masterNodeFileWatchingService) {
                if (this.watching() || !this.active) {
                    this.refreshExistingFileStateIfNeeded(clusterState);
                    return;
                }
                this.startWatcher();
            }
        } else if (event.previousState().nodes().isLocalNodeElectedMaster()) {
            this.stopWatcher();
        }
    }

    private void refreshExistingFileStateIfNeeded(ClusterState clusterState) {
        if (this.watching() && this.shouldRefreshFileState(clusterState) && this.filesExists(this.watchedFile())) {
            try {
                this.filesSetLastModifiedTime(this.watchedFile(), FileTime.from(Instant.now()));
            }
            catch (IOException e) {
                logger.warn("encountered I/O error trying to update file settings timestamp", (Throwable)e);
            }
        }
    }

    protected boolean shouldRefreshFileState(ClusterState clusterState) {
        return false;
    }

    @Override
    protected boolean filesExists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    protected boolean filesIsDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    protected <A extends BasicFileAttributes> A filesReadAttributes(Path path, Class<A> clazz) throws IOException {
        return Files.readAttributes(path, clazz, new LinkOption[0]);
    }

    @Override
    protected Stream<Path> filesList(Path dir) throws IOException {
        return Files.list(dir);
    }

    @Override
    protected Path filesSetLastModifiedTime(Path path, FileTime time) throws IOException {
        return Files.setLastModifiedTime(path, time);
    }

    @Override
    protected InputStream filesNewInputStream(Path path) throws IOException {
        return Files.newInputStream(path, new OpenOption[0]);
    }
}

