/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;

public interface VersionedNamedWriteable
extends NamedWriteable {
    @Override
    public String getWriteableName();

    public TransportVersion getMinimalSupportedVersion();

    public static <T extends VersionedNamedWriteable> boolean shouldSerialize(StreamOutput out, T custom) {
        return out.getTransportVersion().onOrAfter(custom.getMinimalSupportedVersion());
    }

    public static <T extends VersionedNamedWriteable> void writeVersionedWritables(StreamOutput out, Map<String, T> customs) throws IOException {
        int numberOfCustoms = 0;
        for (VersionedNamedWriteable value : customs.values()) {
            if (!VersionedNamedWriteable.shouldSerialize(out, value)) continue;
            ++numberOfCustoms;
        }
        out.writeVInt(numberOfCustoms);
        for (VersionedNamedWriteable value : customs.values()) {
            if (!VersionedNamedWriteable.shouldSerialize(out, value)) continue;
            out.writeNamedWriteable(value);
        }
    }
}

