/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.QueryParserHelper;
import org.elasticsearch.index.search.QueryStringQueryParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class QueryStringQueryBuilder
extends AbstractQueryBuilder<QueryStringQueryBuilder> {
    public static final String NAME = "query_string";
    public static final int DEFAULT_MAX_DETERMINED_STATES = 10000;
    public static final boolean DEFAULT_ENABLE_POSITION_INCREMENTS = true;
    public static final boolean DEFAULT_ESCAPE = false;
    public static final int DEFAULT_FUZZY_PREFIX_LENGTH = 0;
    public static final int DEFAULT_FUZZY_MAX_EXPANSIONS = 50;
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final Fuzziness DEFAULT_FUZZINESS = Fuzziness.AUTO;
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    public static final MultiMatchQueryBuilder.Type DEFAULT_TYPE = MultiMatchQueryBuilder.Type.BEST_FIELDS;
    public static final boolean DEFAULT_FUZZY_TRANSPOSITIONS = true;
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField BOOST_FIELD = new ParseField("boost", new String[0]);
    public static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    public static final ParseField DEFAULT_FIELD_FIELD = new ParseField("default_field", new String[0]);
    public static final ParseField DEFAULT_OPERATOR_FIELD = new ParseField("default_operator", new String[0]);
    public static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    public static final ParseField QUOTE_ANALYZER_FIELD = new ParseField("quote_analyzer", new String[0]);
    public static final ParseField ALLOW_LEADING_WILDCARD_FIELD = new ParseField("allow_leading_wildcard", new String[0]);
    public static final ParseField MAX_DETERMINIZED_STATES_FIELD = new ParseField("max_determinized_states", new String[0]);
    public static final ParseField ENABLE_POSITION_INCREMENTS_FIELD = new ParseField("enable_position_increments", new String[0]);
    public static final ParseField ESCAPE_FIELD = new ParseField("escape", new String[0]);
    public static final ParseField FUZZINESS_FIELD = new ParseField("fuzziness", new String[0]);
    public static final ParseField FUZZY_PREFIX_LENGTH_FIELD = new ParseField("fuzzy_prefix_length", new String[0]);
    public static final ParseField FUZZY_MAX_EXPANSIONS_FIELD = new ParseField("fuzzy_max_expansions", new String[0]);
    public static final ParseField FUZZY_REWRITE_FIELD = new ParseField("fuzzy_rewrite", new String[0]);
    public static final ParseField PHRASE_SLOP_FIELD = new ParseField("phrase_slop", new String[0]);
    public static final ParseField TIE_BREAKER_FIELD = new ParseField("tie_breaker", new String[0]);
    public static final ParseField ANALYZE_WILDCARD_FIELD = new ParseField("analyze_wildcard", new String[0]);
    public static final ParseField REWRITE_FIELD = new ParseField("rewrite", new String[0]);
    public static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    public static final ParseField QUOTE_FIELD_SUFFIX_FIELD = new ParseField("quote_field_suffix", new String[0]);
    public static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    public static final ParseField TIME_ZONE_FIELD = new ParseField("time_zone", new String[0]);
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField GENERATE_SYNONYMS_PHRASE_QUERY = new ParseField("auto_generate_synonyms_phrase_query", new String[0]);
    public static final ParseField FUZZY_TRANSPOSITIONS_FIELD = new ParseField("fuzzy_transpositions", new String[0]);
    private final String queryString;
    private String defaultField;
    private final Map<String, Float> fieldsAndWeights = new TreeMap<String, Float>();
    private Operator defaultOperator = DEFAULT_OPERATOR;
    private String analyzer;
    private String quoteAnalyzer;
    private String quoteFieldSuffix;
    private Boolean allowLeadingWildcard;
    private Boolean analyzeWildcard;
    private boolean enablePositionIncrements = true;
    private Fuzziness fuzziness = DEFAULT_FUZZINESS;
    private int fuzzyPrefixLength = 0;
    private int fuzzyMaxExpansions = 50;
    private String rewrite;
    private String fuzzyRewrite;
    private boolean escape = false;
    private int phraseSlop = 0;
    private MultiMatchQueryBuilder.Type type = DEFAULT_TYPE;
    private Float tieBreaker;
    private String minimumShouldMatch;
    private Boolean lenient;
    private ZoneId timeZone;
    private int maxDeterminizedStates = 10000;
    private boolean autoGenerateSynonymsPhraseQuery = true;
    private boolean fuzzyTranspositions = true;

    public QueryStringQueryBuilder(String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException("query text missing");
        }
        this.queryString = queryString;
    }

    public QueryStringQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryString = in.readString();
        this.defaultField = in.readOptionalString();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String field = in.readString();
            Float weight = Float.valueOf(in.readFloat());
            this.checkNegativeBoost(weight.floatValue());
            this.fieldsAndWeights.put(field, weight);
        }
        this.defaultOperator = Operator.readFromStream(in);
        this.analyzer = in.readOptionalString();
        this.quoteAnalyzer = in.readOptionalString();
        this.quoteFieldSuffix = in.readOptionalString();
        this.allowLeadingWildcard = in.readOptionalBoolean();
        this.analyzeWildcard = in.readOptionalBoolean();
        this.enablePositionIncrements = in.readBoolean();
        this.fuzziness = new Fuzziness(in);
        this.fuzzyPrefixLength = in.readVInt();
        this.fuzzyMaxExpansions = in.readVInt();
        this.fuzzyRewrite = in.readOptionalString();
        this.phraseSlop = in.readVInt();
        this.type = MultiMatchQueryBuilder.Type.readFromStream(in);
        this.tieBreaker = in.readOptionalFloat();
        this.rewrite = in.readOptionalString();
        this.minimumShouldMatch = in.readOptionalString();
        this.lenient = in.readOptionalBoolean();
        this.timeZone = in.readOptionalZoneId();
        this.escape = in.readBoolean();
        this.maxDeterminizedStates = in.readVInt();
        this.autoGenerateSynonymsPhraseQuery = in.readBoolean();
        this.fuzzyTranspositions = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.queryString);
        out.writeOptionalString(this.defaultField);
        out.writeMap(this.fieldsAndWeights, StreamOutput::writeFloat);
        this.defaultOperator.writeTo(out);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalString(this.quoteAnalyzer);
        out.writeOptionalString(this.quoteFieldSuffix);
        out.writeOptionalBoolean(this.allowLeadingWildcard);
        out.writeOptionalBoolean(this.analyzeWildcard);
        out.writeBoolean(this.enablePositionIncrements);
        this.fuzziness.writeTo(out);
        out.writeVInt(this.fuzzyPrefixLength);
        out.writeVInt(this.fuzzyMaxExpansions);
        out.writeOptionalString(this.fuzzyRewrite);
        out.writeVInt(this.phraseSlop);
        this.type.writeTo(out);
        out.writeOptionalFloat(this.tieBreaker);
        out.writeOptionalString(this.rewrite);
        out.writeOptionalString(this.minimumShouldMatch);
        out.writeOptionalBoolean(this.lenient);
        out.writeOptionalZoneId(this.timeZone);
        out.writeBoolean(this.escape);
        out.writeVInt(this.maxDeterminizedStates);
        out.writeBoolean(this.autoGenerateSynonymsPhraseQuery);
        out.writeBoolean(this.fuzzyTranspositions);
    }

    public String queryString() {
        return this.queryString;
    }

    public QueryStringQueryBuilder defaultField(String defaultField) {
        this.defaultField = defaultField;
        return this;
    }

    public String defaultField() {
        return this.defaultField;
    }

    public QueryStringQueryBuilder field(String field) {
        this.fieldsAndWeights.put(field, Float.valueOf(1.0f));
        return this;
    }

    public QueryStringQueryBuilder field(String field, float boost) {
        this.checkNegativeBoost(boost);
        this.fieldsAndWeights.put(field, Float.valueOf(boost));
        return this;
    }

    public QueryStringQueryBuilder fields(Map<String, Float> fields) {
        for (float fieldBoost : fields.values()) {
            this.checkNegativeBoost(fieldBoost);
        }
        this.fieldsAndWeights.putAll(fields);
        return this;
    }

    public Map<String, Float> fields() {
        return this.fieldsAndWeights;
    }

    public QueryStringQueryBuilder type(MultiMatchQueryBuilder.Type type) {
        this.type = type;
        return this;
    }

    public QueryStringQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = Float.valueOf(tieBreaker);
        return this;
    }

    public Float tieBreaker() {
        return this.tieBreaker;
    }

    public QueryStringQueryBuilder defaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator == null ? DEFAULT_OPERATOR : defaultOperator;
        return this;
    }

    public Operator defaultOperator() {
        return this.defaultOperator;
    }

    public QueryStringQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public String quoteAnalyzer() {
        return this.quoteAnalyzer;
    }

    public QueryStringQueryBuilder quoteAnalyzer(String quoteAnalyzer) {
        this.quoteAnalyzer = quoteAnalyzer;
        return this;
    }

    public QueryStringQueryBuilder maxDeterminizedStates(int maxDeterminizedStates) {
        this.maxDeterminizedStates = maxDeterminizedStates;
        return this;
    }

    public int maxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    public QueryStringQueryBuilder allowLeadingWildcard(Boolean allowLeadingWildcard) {
        this.allowLeadingWildcard = allowLeadingWildcard;
        return this;
    }

    public Boolean allowLeadingWildcard() {
        return this.allowLeadingWildcard;
    }

    public QueryStringQueryBuilder enablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
        return this;
    }

    public boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public QueryStringQueryBuilder fuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness == null ? DEFAULT_FUZZINESS : fuzziness;
        return this;
    }

    public Fuzziness fuzziness() {
        return this.fuzziness;
    }

    public QueryStringQueryBuilder fuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
        return this;
    }

    public int fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    public QueryStringQueryBuilder fuzzyMaxExpansions(int fuzzyMaxExpansions) {
        this.fuzzyMaxExpansions = fuzzyMaxExpansions;
        return this;
    }

    public int fuzzyMaxExpansions() {
        return this.fuzzyMaxExpansions;
    }

    public QueryStringQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    public QueryStringQueryBuilder phraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
        return this;
    }

    public int phraseSlop() {
        return this.phraseSlop;
    }

    public QueryStringQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public QueryStringQueryBuilder analyzeWildcard(Boolean analyzeWildcard) {
        this.analyzeWildcard = analyzeWildcard;
        return this;
    }

    public Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    public String rewrite() {
        return this.rewrite;
    }

    public QueryStringQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public QueryStringQueryBuilder quoteFieldSuffix(String quoteFieldSuffix) {
        this.quoteFieldSuffix = quoteFieldSuffix;
        return this;
    }

    public String quoteFieldSuffix() {
        return this.quoteFieldSuffix;
    }

    public QueryStringQueryBuilder lenient(Boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public Boolean lenient() {
        return this.lenient;
    }

    public QueryStringQueryBuilder timeZone(String timeZone) {
        this.timeZone = timeZone != null ? ZoneId.of(timeZone) : null;
        return this;
    }

    public QueryStringQueryBuilder timeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public QueryStringQueryBuilder escape(boolean escape) {
        this.escape = escape;
        return this;
    }

    public boolean escape() {
        return this.escape;
    }

    public QueryStringQueryBuilder autoGenerateSynonymsPhraseQuery(boolean value) {
        this.autoGenerateSynonymsPhraseQuery = value;
        return this;
    }

    public boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    public boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    public QueryStringQueryBuilder fuzzyTranspositions(boolean fuzzyTranspositions) {
        this.fuzzyTranspositions = fuzzyTranspositions;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.queryString);
        if (this.defaultField != null) {
            builder.field(DEFAULT_FIELD_FIELD.getPreferredName(), this.defaultField);
        }
        builder.startArray(FIELDS_FIELD.getPreferredName());
        for (Map.Entry<String, Float> fieldEntry : this.fieldsAndWeights.entrySet()) {
            builder.value(fieldEntry.getKey() + "^" + String.valueOf(fieldEntry.getValue()));
        }
        builder.endArray();
        if (this.type != DEFAULT_TYPE) {
            builder.field(TYPE_FIELD.getPreferredName(), this.type.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.tieBreaker != null) {
            builder.field(TIE_BREAKER_FIELD.getPreferredName(), this.tieBreaker);
        }
        if (this.defaultOperator != DEFAULT_OPERATOR) {
            builder.field(DEFAULT_OPERATOR_FIELD.getPreferredName(), this.defaultOperator.name().toLowerCase(Locale.ROOT));
        }
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        if (this.quoteAnalyzer != null) {
            builder.field(QUOTE_ANALYZER_FIELD.getPreferredName(), this.quoteAnalyzer);
        }
        if (this.maxDeterminizedStates != 10000) {
            builder.field(MAX_DETERMINIZED_STATES_FIELD.getPreferredName(), this.maxDeterminizedStates);
        }
        if (this.allowLeadingWildcard != null) {
            builder.field(ALLOW_LEADING_WILDCARD_FIELD.getPreferredName(), this.allowLeadingWildcard);
        }
        if (!this.enablePositionIncrements) {
            builder.field(ENABLE_POSITION_INCREMENTS_FIELD.getPreferredName(), this.enablePositionIncrements);
        }
        if (this.fuzziness != DEFAULT_FUZZINESS) {
            this.fuzziness.toXContent(builder, params);
        }
        if (this.fuzzyPrefixLength != 0) {
            builder.field(FUZZY_PREFIX_LENGTH_FIELD.getPreferredName(), this.fuzzyPrefixLength);
        }
        if (this.fuzzyMaxExpansions != 50) {
            builder.field(FUZZY_MAX_EXPANSIONS_FIELD.getPreferredName(), this.fuzzyMaxExpansions);
        }
        if (this.fuzzyRewrite != null) {
            builder.field(FUZZY_REWRITE_FIELD.getPreferredName(), this.fuzzyRewrite);
        }
        if (this.phraseSlop != 0) {
            builder.field(PHRASE_SLOP_FIELD.getPreferredName(), this.phraseSlop);
        }
        if (this.analyzeWildcard != null) {
            builder.field(ANALYZE_WILDCARD_FIELD.getPreferredName(), this.analyzeWildcard);
        }
        if (this.rewrite != null) {
            builder.field(REWRITE_FIELD.getPreferredName(), this.rewrite);
        }
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.quoteFieldSuffix != null) {
            builder.field(QUOTE_FIELD_SUFFIX_FIELD.getPreferredName(), this.quoteFieldSuffix);
        }
        if (this.lenient != null) {
            builder.field(LENIENT_FIELD.getPreferredName(), this.lenient);
        }
        if (this.timeZone != null) {
            builder.field(TIME_ZONE_FIELD.getPreferredName(), this.timeZone.getId());
        }
        if (this.escape) {
            builder.field(ESCAPE_FIELD.getPreferredName(), this.escape);
        }
        if (!this.autoGenerateSynonymsPhraseQuery) {
            builder.field(GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), this.autoGenerateSynonymsPhraseQuery);
        }
        if (!this.fuzzyTranspositions) {
            builder.field(FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), this.fuzzyTranspositions);
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    public static QueryStringQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String queryString = null;
        String defaultField = null;
        String analyzer = null;
        String quoteAnalyzer = null;
        String queryName = null;
        float boost = 1.0f;
        int maxDeterminizedStates = 10000;
        boolean enablePositionIncrements = true;
        boolean escape = false;
        int fuzzyPrefixLength = 0;
        int fuzzyMaxExpansions = 50;
        int phraseSlop = 0;
        MultiMatchQueryBuilder.Type type = DEFAULT_TYPE;
        Float tieBreaker = null;
        Boolean analyzeWildcard = null;
        Boolean allowLeadingWildcard = null;
        String minimumShouldMatch = null;
        String quoteFieldSuffix = null;
        Boolean lenient = null;
        Operator defaultOperator = DEFAULT_OPERATOR;
        String timeZone = null;
        Fuzziness fuzziness = DEFAULT_FUZZINESS;
        String fuzzyRewrite = null;
        String rewrite = null;
        Map<String, Float> fieldsAndWeights = null;
        boolean autoGenerateSynonymsPhraseQuery = true;
        boolean fuzzyTranspositions = true;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ArrayList<String> fields = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        fields.add(parser.text());
                    }
                    fieldsAndWeights = QueryParserHelper.parseFieldsAndWeights(fields);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[query_string] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryString = parser.text();
                    continue;
                }
                if (DEFAULT_FIELD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    defaultField = parser.text();
                    continue;
                }
                if (DEFAULT_OPERATOR_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    defaultOperator = Operator.fromString(parser.text());
                    continue;
                }
                if (ANALYZER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    analyzer = parser.text();
                    continue;
                }
                if (QUOTE_ANALYZER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    quoteAnalyzer = parser.text();
                    continue;
                }
                if (ALLOW_LEADING_WILDCARD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    allowLeadingWildcard = parser.booleanValue();
                    continue;
                }
                if (MAX_DETERMINIZED_STATES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    maxDeterminizedStates = parser.intValue();
                    continue;
                }
                if (ENABLE_POSITION_INCREMENTS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    enablePositionIncrements = parser.booleanValue();
                    continue;
                }
                if (ESCAPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    escape = parser.booleanValue();
                    continue;
                }
                if (FUZZY_PREFIX_LENGTH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzzyPrefixLength = parser.intValue();
                    continue;
                }
                if (FUZZY_MAX_EXPANSIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzzyMaxExpansions = parser.intValue();
                    continue;
                }
                if (FUZZY_REWRITE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzzyRewrite = parser.textOrNull();
                    continue;
                }
                if (PHRASE_SLOP_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    phraseSlop = parser.intValue();
                    continue;
                }
                if (Fuzziness.FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzziness = Fuzziness.parse(parser);
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    type = MultiMatchQueryBuilder.Type.parse(parser.text(), parser.getDeprecationHandler());
                    continue;
                }
                if (TIE_BREAKER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    tieBreaker = Float.valueOf(parser.floatValue());
                    continue;
                }
                if (ANALYZE_WILDCARD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    analyzeWildcard = parser.booleanValue();
                    continue;
                }
                if (REWRITE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    rewrite = parser.textOrNull();
                    continue;
                }
                if (MINIMUM_SHOULD_MATCH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    minimumShouldMatch = parser.textOrNull();
                    continue;
                }
                if (QUOTE_FIELD_SUFFIX_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    quoteFieldSuffix = parser.textOrNull();
                    continue;
                }
                if (LENIENT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    lenient = parser.booleanValue();
                    continue;
                }
                if (MAX_DETERMINIZED_STATES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    maxDeterminizedStates = parser.intValue();
                    continue;
                }
                if (TIME_ZONE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    try {
                        timeZone = parser.text();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParsingException(parser.getTokenLocation(), "[query_string] time_zone [" + parser.text() + "] is unknown", new Object[0]);
                    }
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (GENERATE_SYNONYMS_PHRASE_QUERY.match(currentFieldName, parser.getDeprecationHandler())) {
                    autoGenerateSynonymsPhraseQuery = parser.booleanValue();
                    continue;
                }
                if (FUZZY_TRANSPOSITIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzzyTranspositions = parser.booleanValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[query_string] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[query_string] unknown token [" + String.valueOf(token) + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (queryString == null) {
            throw new ParsingException(parser.getTokenLocation(), "[query_string] must be provided with a [query]", new Object[0]);
        }
        QueryStringQueryBuilder queryStringQuery = new QueryStringQueryBuilder(queryString);
        if (fieldsAndWeights != null) {
            queryStringQuery.fields(fieldsAndWeights);
        }
        queryStringQuery.defaultField(defaultField);
        queryStringQuery.defaultOperator(defaultOperator);
        queryStringQuery.analyzer(analyzer);
        queryStringQuery.quoteAnalyzer(quoteAnalyzer);
        queryStringQuery.allowLeadingWildcard(allowLeadingWildcard);
        queryStringQuery.maxDeterminizedStates(maxDeterminizedStates);
        queryStringQuery.enablePositionIncrements(enablePositionIncrements);
        queryStringQuery.escape(escape);
        queryStringQuery.fuzzyPrefixLength(fuzzyPrefixLength);
        queryStringQuery.fuzzyMaxExpansions(fuzzyMaxExpansions);
        queryStringQuery.fuzzyRewrite(fuzzyRewrite);
        queryStringQuery.phraseSlop(phraseSlop);
        queryStringQuery.fuzziness(fuzziness);
        queryStringQuery.type(type);
        if (tieBreaker != null) {
            queryStringQuery.tieBreaker(tieBreaker.floatValue());
        }
        queryStringQuery.analyzeWildcard(analyzeWildcard);
        queryStringQuery.rewrite(rewrite);
        queryStringQuery.minimumShouldMatch(minimumShouldMatch);
        queryStringQuery.quoteFieldSuffix(quoteFieldSuffix);
        queryStringQuery.lenient(lenient);
        queryStringQuery.timeZone(timeZone);
        queryStringQuery.boost(boost);
        queryStringQuery.queryName(queryName);
        queryStringQuery.autoGenerateSynonymsPhraseQuery(autoGenerateSynonymsPhraseQuery);
        queryStringQuery.fuzzyTranspositions(fuzzyTranspositions);
        return queryStringQuery;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(QueryStringQueryBuilder other) {
        return Objects.equals(this.queryString, other.queryString) && Objects.equals(this.defaultField, other.defaultField) && Objects.equals(this.fieldsAndWeights, other.fieldsAndWeights) && Objects.equals(this.defaultOperator, other.defaultOperator) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.quoteAnalyzer, other.quoteAnalyzer) && Objects.equals(this.quoteFieldSuffix, other.quoteFieldSuffix) && Objects.equals(this.allowLeadingWildcard, other.allowLeadingWildcard) && Objects.equals(this.enablePositionIncrements, other.enablePositionIncrements) && Objects.equals(this.analyzeWildcard, other.analyzeWildcard) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.fuzzyPrefixLength, other.fuzzyPrefixLength) && Objects.equals(this.fuzzyMaxExpansions, other.fuzzyMaxExpansions) && Objects.equals(this.fuzzyRewrite, other.fuzzyRewrite) && Objects.equals(this.phraseSlop, other.phraseSlop) && Objects.equals(this.type, other.type) && Objects.equals(this.tieBreaker, other.tieBreaker) && Objects.equals(this.rewrite, other.rewrite) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.lenient, other.lenient) && Objects.equals(this.timeZone == null ? null : this.timeZone.getId(), other.timeZone == null ? null : other.timeZone.getId()) && Objects.equals(this.escape, other.escape) && Objects.equals(this.maxDeterminizedStates, other.maxDeterminizedStates) && Objects.equals(this.autoGenerateSynonymsPhraseQuery, other.autoGenerateSynonymsPhraseQuery) && Objects.equals(this.fuzzyTranspositions, other.fuzzyTranspositions);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.queryString, this.defaultField, this.fieldsAndWeights, this.defaultOperator, this.analyzer, this.quoteAnalyzer, this.quoteFieldSuffix, this.allowLeadingWildcard, this.analyzeWildcard, this.enablePositionIncrements, this.fuzziness, this.fuzzyPrefixLength, this.fuzzyMaxExpansions, this.fuzzyRewrite, this.phraseSlop, this.type, this.tieBreaker, this.rewrite, this.minimumShouldMatch, this.lenient, this.timeZone == null ? Integer.valueOf(0) : this.timeZone.getId(), this.escape, this.maxDeterminizedStates, this.autoGenerateSynonymsPhraseQuery, this.fuzzyTranspositions);
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        Query query;
        QueryStringQueryParser queryParser;
        boolean isLenient;
        String rewrittenQueryString;
        String string = rewrittenQueryString = this.escape ? QueryParser.escape((String)this.queryString) : this.queryString;
        if (this.fieldsAndWeights.size() > 0 && this.defaultField != null) {
            throw this.addValidationError("cannot use [fields] parameter in conjunction with [default_field]", null);
        }
        boolean bl = isLenient = this.lenient == null ? context.queryStringLenient() : this.lenient.booleanValue();
        if (this.defaultField != null) {
            queryParser = Regex.isMatchAllPattern(this.defaultField) ? new QueryStringQueryParser(context, this.lenient == null ? true : this.lenient) : new QueryStringQueryParser(context, this.defaultField, isLenient);
        } else if (this.fieldsAndWeights.size() > 0) {
            Map<String, Float> resolvedFields = QueryParserHelper.resolveMappingFields(context, this.fieldsAndWeights);
            queryParser = QueryParserHelper.hasAllFieldsWildcard(this.fieldsAndWeights.keySet()) ? new QueryStringQueryParser(context, resolvedFields, this.lenient == null ? true : this.lenient) : new QueryStringQueryParser(context, resolvedFields, isLenient);
        } else {
            List<String> defaultFields = context.defaultFields();
            if (QueryParserHelper.hasAllFieldsWildcard(defaultFields)) {
                queryParser = new QueryStringQueryParser(context, this.lenient == null ? true : this.lenient);
            } else {
                Map<String, Float> resolvedFields = QueryParserHelper.resolveMappingFields(context, QueryParserHelper.parseFieldsAndWeights(defaultFields));
                queryParser = new QueryStringQueryParser(context, resolvedFields, isLenient);
            }
        }
        if (this.analyzer != null) {
            NamedAnalyzer namedAnalyzer = context.getIndexAnalyzers().get(this.analyzer);
            if (namedAnalyzer == null) {
                throw new QueryShardException((QueryRewriteContext)context, "[query_string] analyzer [" + this.analyzer + "] not found", new Object[0]);
            }
            queryParser.setForceAnalyzer((Analyzer)namedAnalyzer);
        }
        if (this.quoteAnalyzer != null) {
            NamedAnalyzer forceQuoteAnalyzer = context.getIndexAnalyzers().get(this.quoteAnalyzer);
            if (forceQuoteAnalyzer == null) {
                throw new QueryShardException((QueryRewriteContext)context, "[query_string] quote_analyzer [" + this.quoteAnalyzer + "] not found", new Object[0]);
            }
            queryParser.setForceQuoteAnalyzer((Analyzer)forceQuoteAnalyzer);
        }
        queryParser.setDefaultOperator(this.defaultOperator.toQueryParserOperator());
        queryParser.setType(this.type);
        if (this.tieBreaker != null) {
            queryParser.setGroupTieBreaker(this.tieBreaker.floatValue());
        } else {
            queryParser.setGroupTieBreaker(this.type.tieBreaker());
        }
        queryParser.setPhraseSlop(this.phraseSlop);
        queryParser.setQuoteFieldSuffix(this.quoteFieldSuffix);
        queryParser.setAllowLeadingWildcard(this.allowLeadingWildcard == null ? context.queryStringAllowLeadingWildcard() : this.allowLeadingWildcard.booleanValue());
        queryParser.setAnalyzeWildcard(this.analyzeWildcard == null ? context.queryStringAnalyzeWildcard() : this.analyzeWildcard.booleanValue());
        queryParser.setEnablePositionIncrements(this.enablePositionIncrements);
        queryParser.setFuzziness(this.fuzziness);
        queryParser.setFuzzyPrefixLength(this.fuzzyPrefixLength);
        queryParser.setFuzzyMaxExpansions(this.fuzzyMaxExpansions);
        queryParser.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod(this.fuzzyRewrite, LoggingDeprecationHandler.INSTANCE));
        queryParser.setMultiTermRewriteMethod(QueryParsers.parseRewriteMethod(this.rewrite, LoggingDeprecationHandler.INSTANCE));
        queryParser.setTimeZone(this.timeZone);
        queryParser.setDeterminizeWorkLimit(this.maxDeterminizedStates);
        queryParser.setAutoGenerateMultiTermSynonymsPhraseQuery(this.autoGenerateSynonymsPhraseQuery);
        queryParser.setFuzzyTranspositions(this.fuzzyTranspositions);
        try {
            query = queryParser.parse(rewrittenQueryString);
        }
        catch (ParseException e) {
            throw new QueryShardException((QueryRewriteContext)context, "Failed to parse query [" + this.queryString + "]", (Throwable)e, new Object[0]);
        }
        if (query == null) {
            return null;
        }
        ArrayList<Float> boosts = new ArrayList<Float>();
        while (query instanceof BoostQuery) {
            BoostQuery boostQuery = (BoostQuery)query;
            boosts.add(Float.valueOf(boostQuery.getBoost()));
            query = boostQuery.getQuery();
        }
        query = Queries.fixNegativeQueryIfNeeded(query);
        query = Queries.maybeApplyMinimumShouldMatch(query, this.minimumShouldMatch);
        for (int i = boosts.size() - 1; i >= 0; --i) {
            query = new BoostQuery(query, ((Float)boosts.get(i)).floatValue());
        }
        return query;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }
}

