/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;

public interface IndexingOperationListener {
    default public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
        return operation;
    }

    default public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
    }

    default public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
    }

    default public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
        return delete;
    }

    default public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
    }

    default public void postDelete(ShardId shardId, Engine.Delete delete, Exception ex) {
    }

    default public void preBulkOnPrimary(IndexShard indexShard, Supplier<ActionListener<Void>> proceedListenerSupplier) {
    }

    public static final class CompositeListener
    implements IndexingOperationListener {
        private final List<IndexingOperationListener> listeners;
        private final Logger logger;

        public CompositeListener(List<IndexingOperationListener> listeners, Logger logger) {
            this.listeners = listeners;
            this.logger = logger;
        }

        @Override
        public Engine.Index preIndex(ShardId shardId, Engine.Index operation) {
            assert (operation != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.preIndex(shardId, operation);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "preIndex listener [" + String.valueOf(listener) + "] failed", (Throwable)e);
                }
            }
            return operation;
        }

        @Override
        public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
            assert (index != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postIndex(shardId, index, result);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "postIndex listener [" + String.valueOf(listener) + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
            assert (index != null && ex != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postIndex(shardId, index, ex);
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    this.logger.warn(() -> "postIndex listener [" + String.valueOf(listener) + "] failed", (Throwable)inner);
                }
            }
        }

        @Override
        public Engine.Delete preDelete(ShardId shardId, Engine.Delete delete) {
            assert (delete != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.preDelete(shardId, delete);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "preDelete listener [" + String.valueOf(listener) + "] failed", (Throwable)e);
                }
            }
            return delete;
        }

        @Override
        public void postDelete(ShardId shardId, Engine.Delete delete, Engine.DeleteResult result) {
            assert (delete != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postDelete(shardId, delete, result);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "postDelete listener [" + String.valueOf(listener) + "] failed", (Throwable)e);
                }
            }
        }

        @Override
        public void postDelete(ShardId shardId, Engine.Delete delete, Exception ex) {
            assert (delete != null && ex != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postDelete(shardId, delete, ex);
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    this.logger.warn(() -> "postDelete listener [" + String.valueOf(listener) + "] failed", (Throwable)inner);
                }
            }
        }

        @Override
        public void preBulkOnPrimary(IndexShard indexShard, Supplier<ActionListener<Void>> proceedListenerSupplier) {
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.preBulkOnPrimary(indexShard, proceedListenerSupplier);
                }
                catch (Exception e) {
                    this.logger.warn(() -> "preBulkOnPrimary listener [" + String.valueOf(listener) + "] failed", (Throwable)e);
                }
            }
        }
    }
}

