/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.ExecutorNames;
import org.elasticsearch.indices.system.SystemResourceDescriptor;

public class SystemDataStreamDescriptor
implements SystemResourceDescriptor {
    private final String dataStreamName;
    private final String description;
    private final Type type;
    private final ComposableIndexTemplate composableIndexTemplate;
    private final Map<String, ComponentTemplate> componentTemplates;
    private final List<String> allowedElasticProductOrigins;
    private final String origin;
    private final ExecutorNames executorNames;

    public SystemDataStreamDescriptor(String dataStreamName, String description, Type type, ComposableIndexTemplate composableIndexTemplate, Map<String, ComponentTemplate> componentTemplates, List<String> allowedElasticProductOrigins, String origin, ExecutorNames executorNames) {
        this.dataStreamName = Objects.requireNonNull(dataStreamName, "dataStreamName must be specified");
        if (dataStreamName.length() < 2) {
            throw new IllegalArgumentException("system data stream name [" + dataStreamName + "] but must at least 2 characters in length");
        }
        if (dataStreamName.charAt(0) != '.') {
            throw new IllegalArgumentException("system data stream name [" + dataStreamName + "] but must start with the character [.]");
        }
        this.description = Objects.requireNonNull(description, "description must be specified");
        this.type = Objects.requireNonNull(type, "type must be specified");
        this.composableIndexTemplate = Objects.requireNonNull(composableIndexTemplate, "composableIndexTemplate must be provided");
        this.componentTemplates = componentTemplates == null ? Map.of() : Map.copyOf(componentTemplates);
        this.allowedElasticProductOrigins = Objects.requireNonNull(allowedElasticProductOrigins, "allowedElasticProductOrigins must not be null");
        if (type == Type.EXTERNAL && allowedElasticProductOrigins.isEmpty()) {
            throw new IllegalArgumentException("External system data stream without allowed products is not a valid combination");
        }
        this.executorNames = Objects.nonNull(executorNames) ? executorNames : ExecutorNames.DEFAULT_SYSTEM_DATA_STREAM_THREAD_POOLS;
        this.origin = origin;
    }

    public String getDataStreamName() {
        return this.dataStreamName;
    }

    public List<String> getBackingIndexNames(Metadata metadata) {
        DataStream dataStream = metadata.dataStreams().get(this.dataStreamName);
        if (dataStream == null) {
            return Collections.emptyList();
        }
        return Stream.concat(dataStream.getIndices().stream(), dataStream.getFailureIndices().stream()).map(Index::getName).toList();
    }

    @Override
    public List<String> getMatchingIndices(Metadata metadata) {
        return this.getBackingIndexNames(metadata);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public ComposableIndexTemplate getComposableIndexTemplate() {
        return this.composableIndexTemplate;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isAutomaticallyManaged() {
        return true;
    }

    @Override
    public boolean isExternal() {
        return this.type == Type.EXTERNAL;
    }

    public String getBackingIndexPattern() {
        return SystemDataStreamDescriptor.backingIndexPatternForDataStream(this.getDataStreamName());
    }

    private static String backingIndexPatternForDataStream(String dataStream) {
        return ".(migrated-){0,}[fd]s-" + dataStream + "-*";
    }

    @Override
    public List<String> getAllowedElasticProductOrigins() {
        return this.allowedElasticProductOrigins;
    }

    public Map<String, ComponentTemplate> getComponentTemplates() {
        return this.componentTemplates;
    }

    @Override
    public ExecutorNames getThreadPoolNames() {
        return this.executorNames;
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL;

    }
}

