/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.internal.TwoPhaseCollector;

public class AggregatorCollector
implements TwoPhaseCollector {
    final Aggregator[] aggregators;
    final BucketCollector bucketCollector;
    final List<InternalAggregation> internalAggregations;

    public AggregatorCollector(Aggregator[] aggregators, BucketCollector bucketCollector) {
        this.aggregators = aggregators;
        this.bucketCollector = bucketCollector;
        this.internalAggregations = new ArrayList<InternalAggregation>(aggregators.length);
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return this.bucketCollector.getLeafCollector(new AggregationExecutionContext(context, null, null, null));
    }

    public ScoreMode scoreMode() {
        return this.bucketCollector.scoreMode();
    }

    @Override
    public void doPostCollection() throws IOException {
        this.bucketCollector.postCollection();
        for (Aggregator aggregator : this.aggregators) {
            this.internalAggregations.add(aggregator.buildTopLevel());
            aggregator.releaseAggregations();
        }
    }

    public String toString() {
        Object[] aggNames = new String[this.aggregators.length];
        for (int i = 0; i < this.aggregators.length; ++i) {
            aggNames[i] = this.aggregators[i].name();
        }
        return Arrays.toString(aggNames);
    }
}

