/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.blobcache.shared.SharedBlobCacheService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.ByteSizeCachingDirectory;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheKey;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.CacheService;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;

public class SearchableSnapshotIndexEventListener
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SearchableSnapshotIndexEventListener.class);
    @Nullable
    private final CacheService cacheService;
    @Nullable
    private final SharedBlobCacheService<CacheKey> sharedBlobCacheService;

    public SearchableSnapshotIndexEventListener(Settings settings, @Nullable CacheService cacheService, @Nullable SharedBlobCacheService<CacheKey> sharedBlobCacheService) {
        assert (cacheService != null || !DiscoveryNode.canContainData((Settings)settings));
        this.cacheService = cacheService;
        this.sharedBlobCacheService = sharedBlobCacheService;
    }

    public void beforeIndexShardRecovery(IndexShard indexShard, IndexSettings indexSettings, ActionListener<Void> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
        SearchableSnapshotIndexEventListener.ensureSnapshotIsLoaded(indexShard);
        ByteSizeCachingDirectory sizeCachingDirectory = ByteSizeCachingDirectory.unwrapDirectory((Directory)indexShard.store().directory());
        if (sizeCachingDirectory != null) {
            sizeCachingDirectory.markEstimatedSizeAsStale();
        }
        listener.onResponse(null);
    }

    private static void ensureSnapshotIsLoaded(IndexShard indexShard) {
        Store store = indexShard.store();
        SearchableSnapshotDirectory directory = SearchableSnapshotDirectory.unwrapDirectory(store.directory());
        assert (directory != null);
        ListenableFuture preWarmListener = new ListenableFuture();
        boolean success = directory.loadSnapshot(indexShard.recoveryState(), () -> ((Store)store).isClosing(), (ActionListener<Void>)preWarmListener);
        ShardRouting shardRouting = indexShard.routingEntry();
        if (success && shardRouting.isRelocationTarget()) {
            Runnable preWarmCondition = indexShard.addCleanFilesDependency();
            preWarmListener.addListener(ActionListener.wrap(v -> preWarmCondition.run(), e -> {
                logger.warn(() -> Strings.format((String)"pre-warm operation failed for [%s] while it was the target of primary relocation [%s]", (Object[])new Object[]{shardRouting.shardId(), shardRouting}), (Throwable)e);
                preWarmCondition.run();
            }));
        }
        assert (directory.listAll().length > 0) : "expecting directory listing to be non-empty";
        assert (success || indexShard.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "loading snapshot must not be called twice unless we are retrying a peer recovery";
    }

    public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        if (SearchableSnapshotIndexEventListener.shouldEvictCacheFiles(reason) && indexService.getMetadata().isSearchableSnapshot()) {
            IndexSettings indexSettings = indexService.getIndexSettings();
            for (IndexShard indexShard : indexService) {
                ShardId shardId = indexShard.shardId();
                logger.debug("{} marking shard as evicted in searchable snapshots cache (reason: {})", (Object)shardId, (Object)reason);
                if (this.cacheService != null) {
                    this.cacheService.markShardAsEvictedInCache((String)SearchableSnapshots.SNAPSHOT_SNAPSHOT_ID_SETTING.get(indexSettings.getSettings()), (String)SearchableSnapshots.SNAPSHOT_INDEX_NAME_SETTING.get(indexSettings.getSettings()), shardId);
                }
                if (this.sharedBlobCacheService == null) continue;
                this.sharedBlobCacheService.forceEvict(SearchableSnapshots.forceEvictPredicate(shardId, indexSettings.getSettings()));
            }
        }
    }

    private static boolean shouldEvictCacheFiles(IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        return reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED || reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.FAILURE;
    }
}

