/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.GetRoleMappingsResponse;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.authz.RoleMappingMetadata;
import org.elasticsearch.xpack.security.authc.support.mapper.ClusterStateRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class TransportGetRoleMappingsAction
extends HandledTransportAction<GetRoleMappingsRequest, GetRoleMappingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetRoleMappingsAction.class);
    private final NativeRoleMappingStore roleMappingStore;
    private final ClusterStateRoleMapper clusterStateRoleMapper;

    @Inject
    public TransportGetRoleMappingsAction(ActionFilters actionFilters, TransportService transportService, NativeRoleMappingStore nativeRoleMappingStore, ClusterStateRoleMapper clusterStateRoleMapper) {
        super("cluster:admin/xpack/security/role_mapping/get", transportService, actionFilters, GetRoleMappingsRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.roleMappingStore = nativeRoleMappingStore;
        this.clusterStateRoleMapper = clusterStateRoleMapper;
    }

    protected void doExecute(Task task, GetRoleMappingsRequest request, ActionListener<GetRoleMappingsResponse> listener) {
        Set<String> names = request.getNames() == null || request.getNames().length == 0 ? Set.of() : new HashSet<String>(Arrays.asList(request.getNames()));
        this.roleMappingStore.getRoleMappings(names, (ActionListener<List<ExpressionRoleMapping>>)ActionListener.wrap(nativeRoleMappings -> {
            Set<ExpressionRoleMapping> clusterStateRoleMappings = this.clusterStateRoleMapper.getMappings(this.removeReadOnlySuffixIfPresent(names));
            listener.onResponse((Object)this.buildResponse((Collection<ExpressionRoleMapping>)clusterStateRoleMappings, (Collection<ExpressionRoleMapping>)nativeRoleMappings));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private GetRoleMappingsResponse buildResponse(Collection<ExpressionRoleMapping> clusterStateMappings, Collection<ExpressionRoleMapping> nativeMappings) {
        Stream<ExpressionRoleMapping> translatedClusterStateMappings = clusterStateMappings.stream().filter(roleMapping -> {
            if (RoleMappingMetadata.hasFallbackName((ExpressionRoleMapping)roleMapping)) {
                logger.warn("Role mapping retrieved from cluster-state with an ambiguous name. It will be omitted from the API response.This is likely a transient issue during node start-up.");
                return false;
            }
            return true;
        }).map(this::translateClusterStateMapping);
        return new GetRoleMappingsResponse((ExpressionRoleMapping[])Stream.concat(nativeMappings.stream(), translatedClusterStateMappings).toArray(ExpressionRoleMapping[]::new));
    }

    private Set<String> removeReadOnlySuffixIfPresent(Set<String> names) {
        return names.stream().map(ExpressionRoleMapping::removeReadOnlySuffixIfPresent).collect(Collectors.toSet());
    }

    private ExpressionRoleMapping translateClusterStateMapping(ExpressionRoleMapping mapping) {
        HashMap<String, Boolean> metadata = new HashMap<String, Boolean>(mapping.getMetadata());
        if (metadata.put("_read_only", true) != null) {
            logger.error("Metadata field [{}] is reserved and will be overwritten with an internal system value. Rename this field in your role mapping configuration.", (Object)"_read_only");
        }
        metadata.remove("_es_reserved_role_mapping_name");
        return new ExpressionRoleMapping(ExpressionRoleMapping.addReadOnlySuffix((String)mapping.getName()), mapping.getExpression(), mapping.getRoles(), mapping.getRoleTemplates(), metadata, mapping.isEnabled());
    }
}

