/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class ReplaceDataStreamBackingIndexStep
extends ClusterStateActionStep {
    public static final String NAME = "replace-datastream-backing-index";
    private static final Logger logger = LogManager.getLogger(ReplaceDataStreamBackingIndexStep.class);
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;

    public ReplaceDataStreamBackingIndexStep(Step.StepKey key, Step.StepKey nextStepKey, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier) {
        super(key, nextStepKey);
        this.targetIndexNameSupplier = targetIndexNameSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public BiFunction<String, LifecycleExecutionState, String> getTargetIndexNameSupplier() {
        return this.targetIndexNameSupplier;
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        IndexMetadata originalIndexMetadata = clusterState.metadata().index(index);
        if (originalIndexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)NAME, (Object)index.getName());
            return clusterState;
        }
        String originalIndex = index.getName();
        String targetIndexName = this.targetIndexNameSupplier.apply(originalIndex, originalIndexMetadata.getLifecycleExecutionState());
        String policyName = originalIndexMetadata.getLifecyclePolicyName();
        IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(index.getName());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
        DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream == null) {
            String errorMessage = Strings.format((String)"index [%s] is not part of a data stream. stopping execution of lifecycle [%s] until the index is added to a data stream", (Object[])new Object[]{originalIndex, policyName});
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        boolean isFailureStoreWriteIndex = index.equals((Object)dataStream.getWriteFailureIndex());
        if (isFailureStoreWriteIndex || dataStream.getWriteIndex().equals((Object)index)) {
            String errorMessage = Strings.format((String)"index [%s] is the%s write index for data stream [%s], pausing ILM execution of lifecycle [%s] until this index is no longer the write index for the data stream via manual or automated rollover", (Object[])new Object[]{originalIndex, isFailureStoreWriteIndex ? " failure store" : "", dataStream.getName(), policyName});
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        IndexMetadata targetIndexMetadata = clusterState.metadata().index(targetIndexName);
        if (targetIndexMetadata == null) {
            String errorMessage = Strings.format((String)"target index [%s] doesn't exist. stopping execution of lifecycle [%s] for index [%s]", (Object[])new Object[]{targetIndexName, policyName, originalIndex});
            logger.debug(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        DataStream updatedDataStream = dataStream.isFailureStoreIndex(originalIndex) ? dataStream.replaceFailureStoreIndex(index, targetIndexMetadata.getIndex()) : dataStream.replaceBackingIndex(index, targetIndexMetadata.getIndex());
        Metadata.Builder newMetaData = Metadata.builder((Metadata)clusterState.getMetadata()).put(updatedDataStream);
        return ClusterState.builder((ClusterState)clusterState).metadata(newMetaData).build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndexNameSupplier);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceDataStreamBackingIndexStep other = (ReplaceDataStreamBackingIndexStep)obj;
        return super.equals(obj) && Objects.equals(this.targetIndexNameSupplier, other.targetIndexNameSupplier);
    }
}

