/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ToXContent;

public record StreamingUnifiedChatCompletionResults(Flow.Publisher<? extends ChunkedToXContent> publisher) implements InferenceServiceResults
{
    public static final String NAME = "chat_completion_chunk";
    public static final String MODEL_FIELD = "model";
    public static final String OBJECT_FIELD = "object";
    public static final String USAGE_FIELD = "usage";
    public static final String INDEX_FIELD = "index";
    public static final String ID_FIELD = "id";
    public static final String FUNCTION_NAME_FIELD = "name";
    public static final String FUNCTION_ARGUMENTS_FIELD = "arguments";
    public static final String FUNCTION_FIELD = "function";
    public static final String CHOICES_FIELD = "choices";
    public static final String DELTA_FIELD = "delta";
    public static final String CONTENT_FIELD = "content";
    public static final String REFUSAL_FIELD = "refusal";
    public static final String ROLE_FIELD = "role";
    private static final String TOOL_CALLS_FIELD = "tool_calls";
    public static final String FINISH_REASON_FIELD = "finish_reason";
    public static final String COMPLETION_TOKENS_FIELD = "completion_tokens";
    public static final String TOTAL_TOKENS_FIELD = "total_tokens";
    public static final String PROMPT_TOKENS_FIELD = "prompt_tokens";
    public static final String TYPE_FIELD = "type";

    public boolean isStreaming() {
        return true;
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Map<String, Object> asMap() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static class ChatCompletionChunk
    implements ChunkedToXContent {
        private final String id;
        private final List<Choice> choices;
        private final String model;
        private final String object;
        private final Usage usage;

        public String getId() {
            return this.id;
        }

        public List<Choice> getChoices() {
            return this.choices;
        }

        public String getModel() {
            return this.model;
        }

        public String getObject() {
            return this.object;
        }

        public Usage getUsage() {
            return this.usage;
        }

        public ChatCompletionChunk(String id, List<Choice> choices, String model, String object, Usage usage) {
            this.id = id;
            this.choices = choices;
            this.model = model;
            this.object = object;
            this.usage = usage;
        }

        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.ID_FIELD, this.id)), this.choices != null ? ChunkedToXContentHelper.array((String)StreamingUnifiedChatCompletionResults.CHOICES_FIELD, this.choices.iterator(), (ToXContent.Params)params) : Collections.emptyIterator(), ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.MODEL_FIELD, this.model).field(StreamingUnifiedChatCompletionResults.OBJECT_FIELD, this.object)), this.usage != null ? ChunkedToXContentHelper.chunk((b, p) -> b.startObject(StreamingUnifiedChatCompletionResults.USAGE_FIELD).field(StreamingUnifiedChatCompletionResults.COMPLETION_TOKENS_FIELD, this.usage.completionTokens()).field(StreamingUnifiedChatCompletionResults.PROMPT_TOKENS_FIELD, this.usage.promptTokens()).field(StreamingUnifiedChatCompletionResults.TOTAL_TOKENS_FIELD, this.usage.totalTokens()).endObject()) : Collections.emptyIterator(), ChunkedToXContentHelper.endObject()});
        }

        private static Iterator<ToXContent> optionalField(String name, String value) {
            if (value == null) {
                return Collections.emptyIterator();
            }
            return ChunkedToXContentHelper.chunk((b, p) -> b.field(name, value));
        }

        public record Usage(int completionTokens, int promptTokens, int totalTokens) {
        }

        public record Choice(Delta delta, String finishReason, int index) implements ChunkedToXContentObject
        {
            public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
                return Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), this.delta.toXContentChunked(params), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.FINISH_REASON_FIELD, this.finishReason), ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.INDEX_FIELD, this.index)), ChunkedToXContentHelper.endObject()});
            }

            public static class Delta {
                private final String content;
                private final String refusal;
                private final String role;
                private List<ToolCall> toolCalls;

                public Delta(String content, String refusal, String role, List<ToolCall> toolCalls) {
                    this.content = content;
                    this.refusal = refusal;
                    this.role = role;
                    this.toolCalls = toolCalls;
                }

                public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
                    Iterator xContent = Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject((String)StreamingUnifiedChatCompletionResults.DELTA_FIELD), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.CONTENT_FIELD, this.content), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.REFUSAL_FIELD, this.refusal), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.ROLE_FIELD, this.role)});
                    if (this.toolCalls != null && !this.toolCalls.isEmpty()) {
                        xContent = Iterators.concat((Iterator[])new Iterator[]{xContent, ChunkedToXContentHelper.startArray((String)StreamingUnifiedChatCompletionResults.TOOL_CALLS_FIELD), Iterators.flatMap(this.toolCalls.iterator(), t -> t.toXContentChunked(params)), ChunkedToXContentHelper.endArray()});
                    }
                    xContent = Iterators.concat((Iterator[])new Iterator[]{xContent, ChunkedToXContentHelper.endObject()});
                    return xContent;
                }

                public String getContent() {
                    return this.content;
                }

                public String getRefusal() {
                    return this.refusal;
                }

                public String getRole() {
                    return this.role;
                }

                public List<ToolCall> getToolCalls() {
                    return this.toolCalls;
                }

                public static class ToolCall
                implements ChunkedToXContentObject {
                    private final int index;
                    private final String id;
                    public Function function;
                    private final String type;

                    public ToolCall(int index, String id, Function function, String type) {
                        this.index = index;
                        this.id = id;
                        this.function = function;
                        this.type = type;
                    }

                    public int getIndex() {
                        return this.index;
                    }

                    public String getId() {
                        return this.id;
                    }

                    public Function getFunction() {
                        return this.function;
                    }

                    public String getType() {
                        return this.type;
                    }

                    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
                        Iterator content = Iterators.concat((Iterator[])new Iterator[]{ChunkedToXContentHelper.startObject(), ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.INDEX_FIELD, this.index)), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.ID_FIELD, this.id)});
                        if (this.function != null) {
                            content = Iterators.concat((Iterator[])new Iterator[]{content, ChunkedToXContentHelper.startObject((String)StreamingUnifiedChatCompletionResults.FUNCTION_FIELD), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.FUNCTION_ARGUMENTS_FIELD, this.function.getArguments()), ChatCompletionChunk.optionalField(StreamingUnifiedChatCompletionResults.FUNCTION_NAME_FIELD, this.function.getName()), ChunkedToXContentHelper.endObject()});
                        }
                        content = Iterators.concat((Iterator[])new Iterator[]{content, ChunkedToXContentHelper.chunk((b, p) -> b.field(StreamingUnifiedChatCompletionResults.TYPE_FIELD, this.type)), ChunkedToXContentHelper.endObject()});
                        return content;
                    }

                    public static class Function {
                        private final String arguments;
                        private final String name;

                        public Function(String arguments, String name) {
                            this.arguments = arguments;
                            this.name = name;
                        }

                        public String getArguments() {
                            return this.arguments;
                        }

                        public String getName() {
                            return this.name;
                        }
                    }
                }
            }
        }
    }

    public record Results(Deque<ChatCompletionChunk> chunks) implements ChunkedToXContent
    {
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat((Iterator[])new Iterator[]{Iterators.flatMap(this.chunks.iterator(), c -> c.toXContentChunked(params))});
        }
    }
}

