/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.util.Optional;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;

public final class SecuritySettings {
    public static Settings addTransportSettings(Settings settings) {
        Settings.Builder builder = Settings.builder();
        if (NetworkModule.TRANSPORT_TYPE_SETTING.exists(settings)) {
            String transportType = (String)NetworkModule.TRANSPORT_TYPE_SETTING.get(settings);
            if (!"security4".equals(transportType)) {
                throw new IllegalArgumentException("transport type setting [transport.type] must be [security4] but is [" + transportType + "]");
            }
        } else {
            builder.put("transport.type", "security4");
        }
        return builder.build();
    }

    public static Settings addUserSettings(Settings settings) {
        Settings.Builder builder = Settings.builder();
        String authHeaderSettingName = "request.headers.Authorization";
        if (settings.get(authHeaderSettingName) == null) {
            Optional userOptional = (Optional)SecurityField.USER_SETTING.get(settings);
            userOptional.ifPresent(userSetting -> {
                int i = userSetting.indexOf(58);
                if (i < 0 || i == userSetting.length() - 1) {
                    throw new IllegalArgumentException("invalid [" + SecurityField.USER_SETTING.getKey() + "] setting. must be in the form of \"<username>:<password>\"");
                }
                String username = userSetting.substring(0, i);
                String password = userSetting.substring(i + 1);
                builder.put(authHeaderSettingName, UsernamePasswordToken.basicAuthHeaderValue(username, new SecureString(password)));
            });
        }
        return builder.build();
    }
}

