/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Limiter;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class LuceneSourceOperator
extends LuceneOperator {
    private int currentPagePos = 0;
    private int remainingDocs;
    private final Limiter limiter;
    private IntVector.Builder docsBuilder;
    private DoubleVector.Builder scoreBuilder;
    private final LeafCollector leafCollector;
    private final int minPageSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneSourceOperator(BlockFactory blockFactory, int maxPageSize, LuceneSliceQueue sliceQueue, int limit, Limiter limiter, ScoreMode scoreMode) {
        super(blockFactory, maxPageSize, sliceQueue);
        this.minPageSize = Math.max(1, maxPageSize / 2);
        this.remainingDocs = limit;
        this.limiter = limiter;
        int estimatedSize = Math.min(limit, maxPageSize);
        boolean success = false;
        try {
            this.docsBuilder = blockFactory.newIntVectorBuilder(estimatedSize);
            if (scoreMode.needsScores()) {
                this.scoreBuilder = blockFactory.newDoubleVectorBuilder(estimatedSize);
                this.leafCollector = new ScoringCollector();
            } else {
                this.scoreBuilder = null;
                this.leafCollector = new LimitingCollector();
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting || this.limiter.remaining() == 0;
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Page getCheckedOutput() throws IOException {
        if (this.isFinished()) {
            if ($assertionsDisabled) return null;
            if (this.currentPagePos == 0) return null;
            throw new AssertionError(this.currentPagePos);
        }
        long start = System.nanoTime();
        try {
            LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
            if (scorer == null) {
                Page page = null;
                return page;
            }
            int remainingDocsStart = this.remainingDocs = this.limiter.remaining();
            try {
                scorer.scoreNextRange(this.leafCollector, scorer.leafReaderContext().reader().getLiveDocs(), this.maxPageSize - this.currentPagePos);
            }
            catch (CollectionTerminatedException ex) {
                this.doneCollecting = true;
                scorer.markAsDone();
            }
            int collectedDocs = remainingDocsStart - this.remainingDocs;
            int discardedDocs = collectedDocs - this.limiter.tryAccumulateHits(collectedDocs);
            Page page = null;
            if (this.currentPagePos >= this.minPageSize || scorer.isDone() || (this.remainingDocs = this.limiter.remaining()) == 0) {
                block13: {
                    IntVector shard = null;
                    IntVector leaf = null;
                    IntVector docs = null;
                    DoubleVector scores = null;
                    DocBlock docBlock = null;
                    this.currentPagePos -= discardedDocs;
                    try {
                        shard = this.blockFactory.newConstantIntVector(scorer.shardContext().index(), this.currentPagePos);
                        leaf = this.blockFactory.newConstantIntVector(scorer.leafReaderContext().ord, this.currentPagePos);
                        docs = this.buildDocsVector(this.currentPagePos);
                        this.docsBuilder = this.blockFactory.newIntVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                        docBlock = new DocVector(shard, leaf, docs, true).asBlock();
                        shard = null;
                        leaf = null;
                        docs = null;
                        if (this.scoreBuilder == null) {
                            page = new Page(this.currentPagePos, docBlock);
                        } else {
                            scores = this.buildScoresVector(this.currentPagePos);
                            this.scoreBuilder = this.blockFactory.newDoubleVectorBuilder(Math.min(this.remainingDocs, this.maxPageSize));
                            page = new Page(this.currentPagePos, docBlock, scores.asBlock());
                        }
                        if (page != null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (page != null) throw throwable;
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs, docBlock, scores});
                        throw throwable;
                    }
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{shard, leaf, docs, docBlock, scores});
                }
                this.currentPagePos = 0;
            }
            Page page2 = page;
            return page2;
        }
        finally {
            this.processingNanos += System.nanoTime() - start;
        }
    }

    private IntVector buildDocsVector(int upToPositions) {
        IntVector docs = this.docsBuilder.build();
        assert (docs.getPositionCount() >= upToPositions) : docs.getPositionCount() + " < " + upToPositions;
        if (docs.getPositionCount() == upToPositions) {
            return docs;
        }
        try (IntVector intVector = docs;){
            IntVector intVector2;
            block15: {
                IntVector.FixedBuilder slice = this.blockFactory.newIntVectorFixedBuilder(upToPositions);
                try {
                    for (int i = 0; i < upToPositions; ++i) {
                        slice.appendInt(docs.getInt(i));
                    }
                    intVector2 = slice.build();
                    if (slice == null) break block15;
                }
                catch (Throwable throwable) {
                    if (slice != null) {
                        try {
                            slice.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                slice.close();
            }
            return intVector2;
        }
    }

    private DoubleVector buildScoresVector(int upToPositions) {
        DoubleVector scores = this.scoreBuilder.build();
        assert (scores.getPositionCount() >= upToPositions) : scores.getPositionCount() + " < " + upToPositions;
        if (scores.getPositionCount() == upToPositions) {
            return scores;
        }
        try (DoubleVector doubleVector = scores;){
            DoubleVector doubleVector2;
            block15: {
                DoubleVector.Builder slice = this.blockFactory.newDoubleVectorBuilder(upToPositions);
                try {
                    for (int i = 0; i < upToPositions; ++i) {
                        slice.appendDouble(scores.getDouble(i));
                    }
                    doubleVector2 = slice.build();
                    if (slice == null) break block15;
                }
                catch (Throwable throwable) {
                    if (slice != null) {
                        try {
                            slice.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                slice.close();
            }
            return doubleVector2;
        }
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.docsBuilder, this.scoreBuilder});
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", remainingDocs = ").append(this.remainingDocs);
    }

    final class ScoringCollector
    extends LimitingCollector {
        private Scorable scorable;

        ScoringCollector() {
        }

        @Override
        public void setScorer(Scorable scorer) {
            this.scorable = scorer;
        }

        @Override
        public void collect(int doc) throws IOException {
            super.collect(doc);
            LuceneSourceOperator.this.scoreBuilder.appendDouble(this.scorable.score());
        }
    }

    class LimitingCollector
    implements LeafCollector {
        LimitingCollector() {
        }

        public void setScorer(Scorable scorer) {
        }

        public void collect(int doc) throws IOException {
            if (LuceneSourceOperator.this.remainingDocs > 0) {
                --LuceneSourceOperator.this.remainingDocs;
                LuceneSourceOperator.this.docsBuilder.appendInt(doc);
                ++LuceneSourceOperator.this.currentPagePos;
            } else {
                throw new CollectionTerminatedException();
            }
        }
    }

    public static class Factory
    extends LuceneOperator.Factory {
        private final int maxPageSize;
        private final Limiter limiter;

        public Factory(List<? extends ShardContext> contexts, Function<ShardContext, Query> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, int maxPageSize, int limit, boolean scoring) {
            super(contexts, queryFunction, dataPartitioning, taskConcurrency, limit, scoring ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES);
            this.maxPageSize = maxPageSize;
            this.limiter = limit == Integer.MAX_VALUE ? Limiter.NO_LIMIT : new Limiter(limit);
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new LuceneSourceOperator(driverContext.blockFactory(), this.maxPageSize, this.sliceQueue, this.limit, this.limiter, this.scoreMode);
        }

        public int maxPageSize() {
            return this.maxPageSize;
        }

        @Override
        public String describe() {
            return "LuceneSourceOperator[dataPartitioning = " + String.valueOf((Object)this.dataPartitioning) + ", maxPageSize = " + this.maxPageSize + ", limit = " + this.limit + ", scoreMode = " + String.valueOf(this.scoreMode) + "]";
        }
    }
}

