/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentElasticsearchExtension;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.annotations.AnnotationIndex;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.config.MlFilter;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskState;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.annotations.AnnotationPersister;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobRenormalizedResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.persistence.ScheduledEventsQueryBuilder;
import org.elasticsearch.xpack.ml.job.persistence.StateStreamer;
import org.elasticsearch.xpack.ml.job.process.DataCountsReporter;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectCommunicator;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectWorkerExecutorService;
import org.elasticsearch.xpack.ml.job.process.autodetect.JobModelSnapshotUpgrader;
import org.elasticsearch.xpack.ml.job.process.autodetect.ProcessContext;
import org.elasticsearch.xpack.ml.job.process.autodetect.UpdateParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.UpdateProcessMessage;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.AutodetectResultProcessor;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.AutodetectParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.DataLoadParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.FlushJobParams;
import org.elasticsearch.xpack.ml.job.process.autodetect.params.ForecastParams;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.ScoresUpdater;
import org.elasticsearch.xpack.ml.job.process.normalizer.ShortCircuitingRenormalizer;
import org.elasticsearch.xpack.ml.job.snapshot.upgrader.SnapshotUpgradeTask;
import org.elasticsearch.xpack.ml.job.task.JobTask;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.process.NativeStorageProvider;

public class AutodetectProcessManager
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(AutodetectProcessManager.class);
    private final Client client;
    private final ThreadPool threadPool;
    private final JobManager jobManager;
    private final JobResultsProvider jobResultsProvider;
    private final AutodetectProcessFactory autodetectProcessFactory;
    private final NormalizerFactory normalizerFactory;
    private final IndexNameExpressionResolver expressionResolver;
    private final JobResultsPersister jobResultsPersister;
    private final JobDataCountsPersister jobDataCountsPersister;
    private final AnnotationPersister annotationPersister;
    private final NativeStorageProvider nativeStorageProvider;
    private final ConcurrentMap<Long, ProcessContext> processByAllocation = new ConcurrentHashMap<Long, ProcessContext>();
    private volatile int maxAllowedRunningJobs;
    private final NamedXContentRegistry xContentRegistry;
    private final AnomalyDetectionAuditor auditor;
    private volatile boolean upgradeInProgress;
    private volatile boolean resetInProgress;
    private volatile boolean nodeDying;

    public AutodetectProcessManager(Settings settings, Client client, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, AnomalyDetectionAuditor auditor, ClusterService clusterService, JobManager jobManager, JobResultsProvider jobResultsProvider, JobResultsPersister jobResultsPersister, JobDataCountsPersister jobDataCountsPersister, AnnotationPersister annotationPersister, AutodetectProcessFactory autodetectProcessFactory, NormalizerFactory normalizerFactory, NativeStorageProvider nativeStorageProvider, IndexNameExpressionResolver expressionResolver) {
        this.client = client;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.maxAllowedRunningJobs = (Integer)MachineLearning.MAX_OPEN_JOBS_PER_NODE.get(settings);
        this.autodetectProcessFactory = autodetectProcessFactory;
        this.normalizerFactory = normalizerFactory;
        this.expressionResolver = expressionResolver;
        this.jobManager = jobManager;
        this.jobResultsProvider = jobResultsProvider;
        this.jobResultsPersister = jobResultsPersister;
        this.jobDataCountsPersister = jobDataCountsPersister;
        this.annotationPersister = annotationPersister;
        this.auditor = auditor;
        this.nativeStorageProvider = Objects.requireNonNull(nativeStorageProvider);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_OPEN_JOBS_PER_NODE, this::setMaxAllowedRunningJobs);
    }

    void setMaxAllowedRunningJobs(int maxAllowedRunningJobs) {
        this.maxAllowedRunningJobs = maxAllowedRunningJobs;
    }

    public synchronized void closeAllJobsOnThisNode(String reason) {
        int numJobs = this.processByAllocation.size();
        if (numJobs != 0) {
            logger.info("Closing [{}] jobs, because [{}]", (Object)numJobs, (Object)reason);
            for (ProcessContext processContext : this.processByAllocation.values()) {
                JobTask jobTask = processContext.getJobTask();
                this.setJobState(jobTask, JobState.CLOSING, reason);
                jobTask.closeJob(reason);
            }
        }
    }

    public void killProcess(JobTask jobTask, boolean awaitCompletion, String reason) {
        logger.trace(() -> Strings.format((String)"[%s] Killing process: awaitCompletion = [%s]; reason = [%s]", (Object[])new Object[]{jobTask.getJobId(), awaitCompletion, reason}));
        ProcessContext processContext = (ProcessContext)this.processByAllocation.remove(jobTask.getAllocationId());
        if (processContext != null) {
            processContext.newKillBuilder().setAwaitCompletion(awaitCompletion).setFinish(true).setReason(reason).setShouldFinalizeJob(!this.upgradeInProgress && !this.resetInProgress).kill();
        } else {
            logger.trace(() -> "[" + jobTask.getJobId() + "] Marking job task as completed");
            jobTask.markAsCompleted();
        }
    }

    public void killAllProcessesOnThisNode() {
        this.nodeDying = true;
        Iterator iterator = this.processByAllocation.values().iterator();
        while (iterator.hasNext()) {
            ProcessContext processContext = (ProcessContext)iterator.next();
            processContext.newKillBuilder().setAwaitCompletion(false).setFinish(false).setSilent(true).kill();
            iterator.remove();
        }
    }

    public boolean isNodeDying() {
        return this.nodeDying;
    }

    public synchronized void vacateOpenJobsOnThisNode() {
        for (ProcessContext processContext : this.processByAllocation.values()) {
            if (processContext.getState() != ProcessContext.ProcessStateName.RUNNING || !processContext.getJobTask().triggerVacate()) continue;
            this.threadPool.executor("ml_utility").execute(() -> this.closeProcessAndTask(processContext, processContext.getJobTask(), "node is shutting down"));
        }
    }

    public void persistJob(JobTask jobTask, Consumer<Exception> handler) {
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = String.format(Locale.ROOT, "Cannot persist because job [%s] does not have a corresponding autodetect process", jobTask.getJobId());
            logger.debug(message);
            handler.accept((Exception)((Object)ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0])));
            return;
        }
        communicator.persistJob((aVoid, e) -> handler.accept((Exception)e));
    }

    public void processData(JobTask jobTask, AnalysisRegistry analysisRegistry, InputStream input, XContentType xContentType, DataLoadParams params, BiConsumer<DataCounts, Exception> handler) {
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            throw ExceptionsHelper.conflictStatusException((String)("Cannot process data because job [" + jobTask.getJobId() + "] does not have a corresponding autodetect process"), (Object[])new Object[0]);
        }
        communicator.writeToJob(input, analysisRegistry, xContentType, params, handler);
    }

    public void flushJob(JobTask jobTask, FlushJobParams params, ActionListener<FlushAcknowledgement> handler) {
        logger.debug("Flushing job {}", (Object)jobTask.getJobId());
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = String.format(Locale.ROOT, "Cannot flush because job [%s] does not have a corresponding autodetect process", jobTask.getJobId());
            logger.debug(message);
            handler.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0])));
            return;
        }
        communicator.flushJob(params, (flushAcknowledgement, e) -> {
            if (e != null) {
                String msg = String.format(Locale.ROOT, "[%s] exception while flushing job", jobTask.getJobId());
                logger.error(msg);
                handler.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)msg, (Throwable)e)));
            } else {
                handler.onResponse(flushAcknowledgement);
            }
        });
    }

    public void forecastJob(JobTask jobTask, ForecastParams params, Consumer<Exception> handler) {
        String jobId = jobTask.getJobId();
        logger.debug("Forecasting job {}", (Object)jobId);
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = String.format(Locale.ROOT, "Cannot forecast because job [%s] does not have a corresponding autodetect process", jobId);
            logger.debug(message);
            handler.accept((Exception)((Object)ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0])));
            return;
        }
        communicator.forecastJob(params, (aVoid, e) -> {
            if (e == null) {
                handler.accept(null);
            } else {
                String msg = String.format(Locale.ROOT, "[%s] exception while forecasting job", jobId);
                logger.error(msg, (Throwable)e);
                handler.accept((Exception)((Object)ExceptionsHelper.serverError((String)msg, (Throwable)e)));
            }
        });
    }

    public void writeUpdateProcessMessage(final JobTask jobTask, UpdateParams updateParams, final Consumer<Exception> handler) {
        AutodetectCommunicator communicator = this.getOpenAutodetectCommunicator(jobTask);
        if (communicator == null) {
            String message = "Cannot update the job config because job [" + jobTask.getJobId() + "] does not have a corresponding autodetect process";
            logger.debug(message);
            handler.accept((Exception)((Object)ExceptionsHelper.conflictStatusException((String)message, (Object[])new Object[0])));
            return;
        }
        UpdateProcessMessage.Builder updateProcessMessage = new UpdateProcessMessage.Builder();
        updateProcessMessage.setModelPlotConfig(updateParams.getModelPlotConfig());
        updateProcessMessage.setDetectorUpdates(updateParams.getDetectorUpdates());
        final ActionListener eventsListener = ActionListener.wrap(events -> {
            updateProcessMessage.setScheduledEvents(events == null ? null : events.results());
            communicator.writeUpdateProcessMessage(updateProcessMessage.build(), (aVoid, e) -> handler.accept((Exception)e));
        }, handler);
        ActionListener filtersListener = ActionListener.wrap(filters -> {
            updateProcessMessage.setFilters((List<MlFilter>)filters);
            if (updateParams.isUpdateScheduledEvents()) {
                this.jobManager.getJob(jobTask.getJobId(), new ActionListener<Job>(){

                    public void onResponse(Job job) {
                        Optional<Tuple<DataCounts, Tuple<ModelSizeStats, TimingStats>>> stats = AutodetectProcessManager.this.getStatistics(jobTask);
                        DataCounts dataCounts = stats.isPresent() ? (DataCounts)stats.get().v1() : new DataCounts(job.getId());
                        ScheduledEventsQueryBuilder query = new ScheduledEventsQueryBuilder().start(job.earliestValidTimestamp(dataCounts));
                        AutodetectProcessManager.this.jobResultsProvider.scheduledEventsForJob(jobTask.getJobId(), job.getGroups(), query, (ActionListener<QueryPage<ScheduledEvent>>)eventsListener);
                    }

                    public void onFailure(Exception e) {
                        handler.accept(e);
                    }
                });
            } else {
                eventsListener.onResponse(null);
            }
        }, handler);
        Set<String> filterIds = updateParams.extractReferencedFilters();
        if (filterIds.isEmpty()) {
            filtersListener.onResponse(null);
        } else {
            GetFiltersAction.Request getFilterRequest = new GetFiltersAction.Request(String.join((CharSequence)",", filterIds));
            getFilterRequest.setPageParams(new PageParams(0, filterIds.size()));
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)GetFiltersAction.INSTANCE, (ActionRequest)getFilterRequest, (ActionListener)ActionListener.wrap(getFilterResponse -> filtersListener.onResponse((Object)getFilterResponse.getFilters().results()), handler));
        }
    }

    public void upgradeSnapshot(final SnapshotUpgradeTask task, final Consumer<Exception> closeHandler) {
        final String jobId = task.getJobId();
        final String snapshotId = task.getSnapshotId();
        Function<String, SnapshotUpgradeTaskState> failureBuilder = reason -> new SnapshotUpgradeTaskState(SnapshotUpgradeState.FAILED, task.getAllocationId(), reason);
        this.jobManager.getJob(jobId, (ActionListener<Job>)ActionListener.wrap(job -> {
            if (job.getJobVersion() == null) {
                closeHandler.accept((Exception)((Object)ExceptionsHelper.badRequestException((String)("Cannot open job [" + jobId + "] because jobs created prior to version 5.5 are not supported"), (Object[])new Object[0])));
                return;
            }
            this.jobResultsProvider.getAutodetectParams((Job)job, snapshotId, params -> {
                if (params.modelSnapshot() == null) {
                    closeHandler.accept((Exception)((Object)new ElasticsearchStatusException("cannot find snapshot [{}] for job [{}] to upgrade", RestStatus.NOT_FOUND, new Object[]{jobId, snapshotId})));
                    return;
                }
                if (this.resetInProgress) {
                    logger.trace(() -> Strings.format((String)"Aborted upgrading snapshot [%s] for job [%s] as ML feature is being reset", (Object[])new Object[]{snapshotId, jobId}));
                    closeHandler.accept(null);
                    return;
                }
                this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable((Job)job, (AutodetectParams)params){
                    final /* synthetic */ Job val$job;
                    final /* synthetic */ AutodetectParams val$params;
                    {
                        this.val$job = job;
                        this.val$params = autodetectParams;
                    }

                    public void onFailure(Exception e) {
                        closeHandler.accept(e);
                    }

                    protected void doRun() {
                        if (AutodetectProcessManager.this.nodeDying) {
                            logger.info(() -> Strings.format((String)"Aborted upgrading snapshot [%s] for job [%s] as node is dying", (Object[])new Object[]{snapshotId, jobId}));
                            closeHandler.accept(null);
                            return;
                        }
                        if (AutodetectProcessManager.this.resetInProgress) {
                            logger.trace(() -> Strings.format((String)"Aborted upgrading snapshot [%s] for job [%s] as ML feature is being reset", (Object[])new Object[]{snapshotId, jobId}));
                            closeHandler.accept(null);
                            return;
                        }
                        AutodetectProcessManager.this.runSnapshotUpgrade(task, this.val$job, this.val$params, closeHandler);
                    }
                });
            }, e1 -> {
                logger.warn(() -> Strings.format((String)"[%s] [%s] Failed to gather information required to upgrade snapshot job", (Object[])new Object[]{jobId, snapshotId}), (Throwable)e1);
                task.updatePersistentTaskState((PersistentTaskState)failureBuilder.apply(e1.getMessage()), ActionListener.wrap(t -> closeHandler.accept((Exception)e1), e2 -> {
                    logger.warn(() -> Strings.format((String)"[%s] [%s] failed to set task to failed", (Object[])new Object[]{jobId, snapshotId}), (Throwable)e2);
                    closeHandler.accept((Exception)e1);
                }));
            });
        }, closeHandler));
    }

    public void openJob(JobTask jobTask, ClusterState clusterState, TimeValue masterNodeTimeout, BiConsumer<Exception, Boolean> closeHandler) {
        String jobId = jobTask.getJobId();
        if (jobTask.isClosing()) {
            logger.info("Aborting opening of job [{}] as it is being closed", (Object)jobId);
            jobTask.markAsCompleted();
            return;
        }
        logger.info("Opening job [{}]", (Object)jobId);
        ActionListener stateAliasHandler = ActionListener.wrap(r -> this.jobManager.getJob(jobId, (ActionListener<Job>)ActionListener.wrap(job -> this.startProcess(jobTask, (Job)job, closeHandler), e -> closeHandler.accept((Exception)e, true))), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof InvalidAliasNameException) {
                String msg = "Detected a problem with your setup of machine learning, the state index alias [" + AnomalyDetectorsIndex.jobStateIndexWriteAlias() + "] exists as index but must be an alias.";
                logger.error(() -> Strings.format((String)"[%s] %s", (Object[])new Object[]{jobId, msg}), (Throwable)e);
                closeHandler.accept(new IllegalStateException(msg, (Throwable)e), true);
            } else {
                closeHandler.accept((Exception)e, true);
            }
        });
        ActionListener resultsMappingUpdateHandler = ActionListener.wrap(ack -> AnomalyDetectorsIndex.createStateIndexAndAliasIfNecessaryAndWaitForYellow((Client)this.client, (ClusterState)clusterState, (IndexNameExpressionResolver)this.expressionResolver, (TimeValue)masterNodeTimeout, (ActionListener)stateAliasHandler), e -> {
            logger.error(() -> "[" + jobId + "] ML state index alias could not be updated", (Throwable)e);
            closeHandler.accept((Exception)e, true);
        });
        ActionListener annotationsIndexUpdateHandler = ActionListener.wrap(ack -> ElasticsearchMappings.addDocMappingIfMissing((String)AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId), AnomalyDetectorsIndex::wrappedResultsMapping, (Client)this.client, (ClusterState)clusterState, (TimeValue)masterNodeTimeout, (ActionListener)resultsMappingUpdateHandler, (int)1), e -> {
            logger.warn(() -> "[" + jobId + "] ML annotations index could not be updated with latest mappings", (Throwable)e);
            ElasticsearchMappings.addDocMappingIfMissing((String)AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId), AnomalyDetectorsIndex::wrappedResultsMapping, (Client)this.client, (ClusterState)clusterState, (TimeValue)masterNodeTimeout, (ActionListener)resultsMappingUpdateHandler, (int)1);
        });
        AnnotationIndex.createAnnotationsIndexIfNecessaryAndWaitForYellow((Client)this.client, (ClusterState)clusterState, (TimeValue)masterNodeTimeout, (ActionListener)annotationsIndexUpdateHandler);
    }

    private void startProcess(final JobTask jobTask, final Job job, final BiConsumer<Exception, Boolean> closeHandler) {
        if (job.getJobVersion() == null) {
            closeHandler.accept((Exception)((Object)ExceptionsHelper.badRequestException((String)("Cannot open job [" + job.getId() + "] because jobs created prior to version 5.5 are not supported"), (Object[])new Object[0])), true);
            return;
        }
        this.processByAllocation.putIfAbsent(jobTask.getAllocationId(), new ProcessContext(jobTask));
        this.jobResultsProvider.getAutodetectParams(job, params -> this.threadPool.executor("ml_utility").execute((Runnable)new AbstractRunnable((AutodetectParams)params){
            final /* synthetic */ AutodetectParams val$params;
            {
                this.val$params = autodetectParams;
            }

            public void onFailure(Exception e) {
                closeHandler.accept(e, true);
            }

            protected void doRun() {
                ProcessContext processContext = (ProcessContext)AutodetectProcessManager.this.processByAllocation.get(jobTask.getAllocationId());
                if (processContext == null) {
                    logger.debug("Aborted opening job [{}] as it has been closed or killed", (Object)job.getId());
                    return;
                }
                if (processContext.getJobTask().isClosing()) {
                    logger.debug("Aborted opening job [{}] as it is being closed (before starting process)", (Object)job.getId());
                    jobTask.markAsCompleted();
                    return;
                }
                try {
                    if (AutodetectProcessManager.this.createProcessAndSetRunning(processContext, job, this.val$params, closeHandler)) {
                        if (processContext.getJobTask().isClosing()) {
                            logger.debug("Aborted opening job [{}] as it is being closed or killed (after starting process)", (Object)job.getId());
                            AutodetectProcessManager.this.closeProcessAndTask(processContext, jobTask, "job is already closing");
                            return;
                        }
                        processContext.getAutodetectCommunicator().restoreState(this.val$params.modelSnapshot());
                        AutodetectProcessManager.this.setJobState(jobTask, JobState.OPENED, null, (CheckedConsumer<Exception, IOException>)((CheckedConsumer)e -> {
                            if (e != null) {
                                AutodetectProcessManager.logSetJobStateFailure(JobState.OPENED, job.getId(), e);
                                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                                    processContext.newKillBuilder().setAwaitCompletion(false).setFinish(false).kill();
                                    AutodetectProcessManager.this.processByAllocation.remove(jobTask.getAllocationId());
                                }
                            }
                        }));
                    }
                }
                catch (Exception e1) {
                    try {
                        processContext.newKillBuilder().setAwaitCompletion(false).setFinish(false).kill();
                        AutodetectProcessManager.this.processByAllocation.remove(jobTask.getAllocationId());
                    }
                    finally {
                        AutodetectProcessManager.this.setJobState(jobTask, JobState.FAILED, e1.getMessage(), (CheckedConsumer<Exception, IOException>)((CheckedConsumer)e2 -> closeHandler.accept(e1, true)));
                    }
                }
            }
        }), e1 -> {
            logger.warn("Failed to gather information required to open job [" + job.getId() + "]", (Throwable)e1);
            this.setJobState(jobTask, JobState.FAILED, e1.getMessage(), (CheckedConsumer<Exception, IOException>)((CheckedConsumer)e2 -> closeHandler.accept((Exception)e1, true)));
        });
    }

    private void runSnapshotUpgrade(SnapshotUpgradeTask task, Job job, AutodetectParams params, Consumer<Exception> handler) {
        JobModelSnapshotUpgrader jobModelSnapshotUpgrader = new JobModelSnapshotUpgrader(task, job, params, this.threadPool, this.autodetectProcessFactory, this.jobResultsPersister, this.client, this.nativeStorageProvider, handler, () -> !this.nodeDying);
        jobModelSnapshotUpgrader.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createProcessAndSetRunning(ProcessContext processContext, Job job, AutodetectParams params, BiConsumer<Exception, Boolean> handler) throws IOException {
        processContext.tryLock();
        try {
            if (processContext.getState() != ProcessContext.ProcessStateName.NOT_RUNNING) {
                logger.debug("Cannot open job [{}] when its state is [{}]", (Object)job.getId(), (Object)((Object)((Object)processContext.getState())).getClass().getName());
                boolean bl = false;
                return bl;
            }
            if (processContext.getJobTask().isClosing()) {
                logger.debug("Cannot open job [{}] as it is closing", (Object)job.getId());
                processContext.getJobTask().markAsCompleted();
                boolean bl = false;
                return bl;
            }
            AutodetectCommunicator communicator = this.create(processContext.getJobTask(), job, params, handler);
            communicator.writeHeader();
            processContext.setRunning(communicator);
            boolean bl = true;
            return bl;
        }
        finally {
            processContext.unlock();
        }
    }

    AutodetectCommunicator create(JobTask jobTask, Job job, AutodetectParams autodetectParams, BiConsumer<Exception, Boolean> handler) {
        ExecutorService autodetectWorkerExecutor;
        int localMaxAllowedRunningJobs = this.maxAllowedRunningJobs;
        int currentRunningJobs = this.processByAllocation.size();
        if (currentRunningJobs > localMaxAllowedRunningJobs) {
            throw new ElasticsearchStatusException("max running job capacity [" + localMaxAllowedRunningJobs + "] reached", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
        }
        String jobId = jobTask.getJobId();
        this.notifyLoadingSnapshot(jobId, autodetectParams);
        if (autodetectParams.dataCounts().getLatestRecordTimeStamp() != null) {
            String msg;
            if (autodetectParams.modelSnapshot() == null) {
                msg = "No model snapshot could be found for a job with processed records";
                logger.warn("[{}] {}", (Object)jobId, (Object)msg);
                this.auditor.warning(jobId, "No model snapshot could be found for a job with processed records");
            }
            if (autodetectParams.quantiles() == null) {
                msg = "No quantiles could be found for a job with processed records";
                logger.warn("[{}] {}", (Object)jobId, (Object)msg);
                this.auditor.warning(jobId, msg);
            }
        }
        ExecutorService autodetectExecutorService = this.threadPool.executor("ml_job_comms");
        DataCountsReporter dataCountsReporter = new DataCountsReporter(job, autodetectParams.dataCounts(), this.jobDataCountsPersister);
        ScoresUpdater scoresUpdater = new ScoresUpdater(job, this.jobResultsProvider, new JobRenormalizedResultsPersister(job.getId(), this.client), this.normalizerFactory);
        ExecutorService renormalizerExecutorService = this.threadPool.executor("ml_utility");
        ShortCircuitingRenormalizer renormalizer = new ShortCircuitingRenormalizer(jobId, scoresUpdater, renormalizerExecutorService);
        AutodetectProcess process = this.autodetectProcessFactory.createAutodetectProcess(job, autodetectParams, autodetectExecutorService, this.onProcessCrash(jobTask));
        AutodetectResultProcessor processor = new AutodetectResultProcessor(this.client, this.auditor, jobId, renormalizer, this.jobResultsPersister, this.annotationPersister, process, autodetectParams.modelSizeStats(), autodetectParams.timingStats());
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            autodetectWorkerExecutor = this.createAutodetectExecutorService(autodetectExecutorService);
            autodetectExecutorService.submit(processor::process);
        }
        catch (EsRejectedExecutionException e) {
            try {
                IOUtils.close((Closeable)process);
            }
            catch (IOException ioe) {
                logger.error("Can't close autodetect", (Throwable)ioe);
            }
            throw e;
        }
        return new AutodetectCommunicator(job, process, new StateStreamer(this.client), dataCountsReporter, processor, handler, this.xContentRegistry, autodetectWorkerExecutor);
    }

    private void notifyLoadingSnapshot(String jobId, AutodetectParams autodetectParams) {
        ModelSnapshot modelSnapshot = autodetectParams.modelSnapshot();
        StringBuilder msgBuilder = new StringBuilder("Loading model snapshot [");
        if (modelSnapshot == null) {
            msgBuilder.append("N/A");
        } else {
            msgBuilder.append(modelSnapshot.getSnapshotId());
            msgBuilder.append("] with latest_record_timestamp [");
            Date snapshotLatestRecordTimestamp = modelSnapshot.getLatestRecordTimeStamp();
            msgBuilder.append(snapshotLatestRecordTimestamp == null ? "N/A" : XContentElasticsearchExtension.DEFAULT_FORMATTER.format((TemporalAccessor)snapshotLatestRecordTimestamp.toInstant()));
        }
        msgBuilder.append("], job latest_record_timestamp [");
        Date jobLatestRecordTimestamp = autodetectParams.dataCounts().getLatestRecordTimeStamp();
        msgBuilder.append(jobLatestRecordTimestamp == null ? "N/A" : XContentElasticsearchExtension.DEFAULT_FORMATTER.format((TemporalAccessor)jobLatestRecordTimestamp.toInstant()));
        msgBuilder.append("]");
        String msg = msgBuilder.toString();
        logger.info("[{}] {}", (Object)jobId, (Object)msg);
        this.auditor.info(jobId, msg);
    }

    private Consumer<String> onProcessCrash(JobTask jobTask) {
        return reason -> {
            AutodetectCommunicator communicator;
            ProcessContext processContext = (ProcessContext)this.processByAllocation.remove(jobTask.getAllocationId());
            if (processContext != null && (communicator = processContext.getAutodetectCommunicator()) != null) {
                communicator.destroyCategorizationAnalyzer();
            }
            this.setJobState(jobTask, JobState.FAILED, (String)reason);
            try {
                this.nativeStorageProvider.cleanupLocalTmpStorage(jobTask.getDescription());
            }
            catch (IOException e) {
                logger.error(() -> "[" + jobTask.getJobId() + "] Failed to delete temporary files", (Throwable)e);
            }
        };
    }

    private void closeProcessAndTask(ProcessContext processContext, JobTask jobTask, String reason) {
        String jobId = jobTask.getJobId();
        long allocationId = jobTask.getAllocationId();
        boolean jobKilled = false;
        processContext.tryLock();
        try {
            if (!processContext.setDying()) {
                logger.debug("Cannot {} job [{}] as it has been marked as dying", (Object)(jobTask.isVacating() ? "vacate" : "close"), (Object)jobId);
                return;
            }
            boolean bl = jobKilled = !this.processByAllocation.containsKey(allocationId);
            if (jobKilled) {
                logger.debug("[{}] Cleaning up job opened after kill", (Object)jobId);
            } else if (reason == null) {
                logger.info("{} job [{}]", (Object)(jobTask.isVacating() ? "Vacating" : "Closing"), (Object)jobId);
            } else {
                logger.info("{} job [{}], because [{}]", (Object)(jobTask.isVacating() ? "Vacating" : "Closing"), (Object)jobId, (Object)reason);
            }
            AutodetectCommunicator communicator = processContext.getAutodetectCommunicator();
            if (communicator == null) {
                assert (!jobKilled) : "Job " + jobId + " killed before process started yet still had no communicator during cleanup after process started";
                assert (!jobTask.isVacating()) : "Job " + jobId + " was vacated before it had a communicator - should not be possible";
                logger.debug("Job [{}] is being closed before its process is started", (Object)jobId);
                jobTask.markAsCompleted();
                this.processByAllocation.remove(allocationId);
            } else if (jobKilled) {
                communicator.killProcess(true, false, false);
            } else {
                communicator.setVacating(jobTask.isVacating());
                communicator.close();
                this.processByAllocation.remove(allocationId);
            }
        }
        catch (Exception e) {
            ElasticsearchStatusException exception;
            if (e instanceof ElasticsearchStatusException && (exception = (ElasticsearchStatusException)((Object)e)).status() == RestStatus.CONFLICT) {
                logger.trace("[{}] Conflict between kill and {} during autodetect process cleanup - job {} before cleanup started", (Object)jobId, (Object)(jobTask.isVacating() ? "vacate" : "close"), (Object)(jobKilled ? "killed" : "not killed"));
                throw exception;
            }
            String msg = jobKilled ? "Exception cleaning up autodetect process started after kill" : "Exception " + (jobTask.isVacating() ? "vacating" : "closing") + " autodetect process";
            logger.warn("[" + jobId + "] " + msg, (Throwable)e);
            this.setJobState(jobTask, JobState.FAILED, e.getMessage());
            throw ExceptionsHelper.serverError((String)msg, (Throwable)e);
        }
        finally {
            processContext.unlock();
        }
        try {
            this.nativeStorageProvider.cleanupLocalTmpStorage(jobTask.getDescription());
        }
        catch (IOException e) {
            logger.error(() -> "[" + jobId + "] Failed to delete temporary files", (Throwable)e);
        }
    }

    public void closeJob(JobTask jobTask, String reason) {
        String jobId = jobTask.getJobId();
        long allocationId = jobTask.getAllocationId();
        logger.debug("Attempting to close job [{}], because [{}]", (Object)jobId, (Object)reason);
        ProcessContext processContext = (ProcessContext)this.processByAllocation.get(allocationId);
        if (processContext == null) {
            logger.debug("Cannot close job [{}] as it has already been closed or is closing", (Object)jobId);
            return;
        }
        this.closeProcessAndTask(processContext, jobTask, reason);
    }

    int numberOfOpenJobs() {
        return (int)this.processByAllocation.values().stream().filter(p -> p.getState() != ProcessContext.ProcessStateName.DYING).count();
    }

    boolean jobHasActiveAutodetectProcess(JobTask jobTask) {
        return this.getAutodetectCommunicator(jobTask) != null;
    }

    private AutodetectCommunicator getAutodetectCommunicator(JobTask jobTask) {
        return this.processByAllocation.getOrDefault(jobTask.getAllocationId(), new ProcessContext(jobTask)).getAutodetectCommunicator();
    }

    private AutodetectCommunicator getOpenAutodetectCommunicator(JobTask jobTask) {
        ProcessContext processContext = (ProcessContext)this.processByAllocation.get(jobTask.getAllocationId());
        if (processContext != null && processContext.getState() == ProcessContext.ProcessStateName.RUNNING) {
            return processContext.getAutodetectCommunicator();
        }
        return null;
    }

    public boolean hasOpenAutodetectCommunicator(long jobAllocationId) {
        ProcessContext processContext = (ProcessContext)this.processByAllocation.get(jobAllocationId);
        if (processContext != null && processContext.getState() == ProcessContext.ProcessStateName.RUNNING) {
            return processContext.getAutodetectCommunicator() != null;
        }
        return false;
    }

    public Optional<Duration> jobOpenTime(JobTask jobTask) {
        AutodetectCommunicator communicator = this.getAutodetectCommunicator(jobTask);
        if (communicator == null) {
            return Optional.empty();
        }
        return Optional.of(Duration.between(communicator.getProcessStartTime(), ZonedDateTime.now()));
    }

    void setJobState(JobTask jobTask, JobState state, String reason) {
        JobTaskState jobTaskState = new JobTaskState(state, jobTask.getAllocationId(), reason, Instant.now());
        jobTask.updatePersistentTaskState((PersistentTaskState)jobTaskState, ActionListener.wrap(persistentTask -> logger.info("Successfully set job state to [{}] for job [{}]", (Object)state, (Object)jobTask.getJobId()), e -> AutodetectProcessManager.logSetJobStateFailure(state, jobTask.getJobId(), e)));
    }

    private static void logSetJobStateFailure(JobState state, String jobId, Exception e) {
        if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
            logger.debug("Could not set job state to [{}] for job [{}] as it has been closed", (Object)state, (Object)jobId);
        } else {
            logger.error(() -> Strings.format((String)"Could not set job state to [%s] for job [%s]", (Object[])new Object[]{state, jobId}), (Throwable)e);
        }
    }

    void setJobState(JobTask jobTask, JobState state, String reason, CheckedConsumer<Exception, IOException> handler) {
        JobTaskState jobTaskState = new JobTaskState(state, jobTask.getAllocationId(), reason, Instant.now());
        jobTask.updatePersistentTaskState((PersistentTaskState)jobTaskState, ActionListener.wrap(persistentTask -> {
            try {
                handler.accept(null);
            }
            catch (IOException e1) {
                logger.warn("Error while delegating response", (Throwable)e1);
            }
        }, e -> {
            try {
                handler.accept(e);
            }
            catch (IOException e1) {
                logger.warn("Error while delegating exception [" + e.getMessage() + "]", (Throwable)e1);
            }
        }));
    }

    public Optional<Tuple<DataCounts, Tuple<ModelSizeStats, TimingStats>>> getStatistics(JobTask jobTask) {
        AutodetectCommunicator communicator = this.getAutodetectCommunicator(jobTask);
        if (communicator == null) {
            return Optional.empty();
        }
        return Optional.of(new Tuple((Object)communicator.getDataCounts(), (Object)new Tuple((Object)communicator.getModelSizeStats(), (Object)communicator.getTimingStats())));
    }

    ExecutorService createAutodetectExecutorService(ExecutorService executorService) {
        AutodetectWorkerExecutorService autodetectWorkerExecutor = new AutodetectWorkerExecutorService(this.threadPool.getThreadContext());
        executorService.submit(autodetectWorkerExecutor::start);
        return autodetectWorkerExecutor;
    }

    public ByteSizeValue getMinLocalStorageAvailable() {
        return this.nativeStorageProvider.getMinLocalStorageAvailable();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        this.upgradeInProgress = MlMetadata.getMlMetadata((ClusterState)event.state()).isUpgradeMode();
        this.resetInProgress = MlMetadata.getMlMetadata((ClusterState)event.state()).isResetMode();
    }

    public ByteSizeValue getOpenProcessMemoryUsage() {
        long memoryUsedBytes = 0L;
        for (ProcessContext processContext : this.processByAllocation.values()) {
            if (processContext.getState() != ProcessContext.ProcessStateName.RUNNING) continue;
            ModelSizeStats modelSizeStats = processContext.getAutodetectCommunicator().getModelSizeStats();
            ModelSizeStats.AssignmentMemoryBasis basis = modelSizeStats.getAssignmentMemoryBasis();
            memoryUsedBytes += (switch (basis != null ? basis : ModelSizeStats.AssignmentMemoryBasis.MODEL_MEMORY_LIMIT) {
                default -> throw new MatchException(null, null);
                case ModelSizeStats.AssignmentMemoryBasis.MODEL_MEMORY_LIMIT -> Optional.ofNullable(modelSizeStats.getModelBytesMemoryLimit()).orElse(0L);
                case ModelSizeStats.AssignmentMemoryBasis.CURRENT_MODEL_BYTES -> modelSizeStats.getModelBytes();
                case ModelSizeStats.AssignmentMemoryBasis.PEAK_MODEL_BYTES -> Optional.ofNullable(modelSizeStats.getPeakModelBytes()).orElse(modelSizeStats.getModelBytes());
            });
            memoryUsedBytes += Job.PROCESS_MEMORY_OVERHEAD.getBytes();
        }
        return ByteSizeValue.ofBytes((long)memoryUsedBytes);
    }
}

