/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.dataframe;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.UpdateDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.rest.dataframe.RestPutDataFrameAnalyticsAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestPostDataFrameAnalyticsUpdateAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_ml/data_frame/analytics/{" + String.valueOf(DataFrameAnalyticsConfig.ID) + "}/_update"));
    }

    public String getName() {
        return "xpack_ml_post_data_frame_analytics_update_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        UpdateDataFrameAnalyticsAction.Request updateRequest;
        if ((long)restRequest.contentLength() > RestPutDataFrameAnalyticsAction.MAX_REQUEST_SIZE.getBytes()) {
            throw ExceptionsHelper.badRequestException((String)"Request is too large: was [{}b], expected at most [{}]", (Object[])new Object[]{restRequest.contentLength(), RestPutDataFrameAnalyticsAction.MAX_REQUEST_SIZE});
        }
        String id = restRequest.param(DataFrameAnalyticsConfig.ID.getPreferredName());
        try (XContentParser parser = restRequest.contentParser();){
            updateRequest = UpdateDataFrameAnalyticsAction.Request.parseRequest((String)id, (XContentParser)parser);
        }
        updateRequest.ackTimeout(RestUtils.getAckTimeout((RestRequest)restRequest));
        return channel -> client.execute((ActionType)UpdateDataFrameAnalyticsAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

