/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit.integrity;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.repositories.blobstore.testkit.integrity.RepositoryVerifyIntegrityTask;

public class RepositoryVerifyIntegrityResponse
extends ActionResponse {
    private final RepositoryVerifyIntegrityTask.Status finalTaskStatus;
    private final long finalRepositoryGeneration;

    RepositoryVerifyIntegrityResponse(RepositoryVerifyIntegrityTask.Status finalTaskStatus, long finalRepositoryGeneration) {
        this.finalTaskStatus = finalTaskStatus;
        this.finalRepositoryGeneration = finalRepositoryGeneration;
    }

    RepositoryVerifyIntegrityResponse(StreamInput in) throws IOException {
        this.finalRepositoryGeneration = in.readLong();
        this.finalTaskStatus = new RepositoryVerifyIntegrityTask.Status(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.finalRepositoryGeneration);
        this.finalTaskStatus.writeTo(out);
    }

    public long finalRepositoryGeneration() {
        return this.finalRepositoryGeneration;
    }

    public RepositoryVerifyIntegrityTask.Status finalTaskStatus() {
        return this.finalTaskStatus;
    }

    public long originalRepositoryGeneration() {
        return this.finalTaskStatus.repositoryGeneration();
    }
}

