/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.ResultRowSet;

class SearchHitRowSet
extends ResultRowSet<HitExtractor> {
    private final SearchHits hits;
    private final Map<SearchHit, Map<String, SearchHit[]>> flatInnerHits = new HashMap<SearchHit, Map<String, SearchHit[]>>();
    private final String innerHit;
    private final int size;
    private final int[] indexPerLevel;
    private final int remainingLimit;
    private int row = 0;

    SearchHitRowSet(List<HitExtractor> exts, BitSet mask, int sizeRequested, int limit, SearchResponse response) {
        super(exts, mask);
        this.hits = response.getHits().asUnpooled();
        String innerHit = null;
        LinkedHashSet<String> innerHits = new LinkedHashSet<String>();
        for (HitExtractor ex : exts) {
            if (ex.hitName() == null) continue;
            innerHits.add(ex.hitName());
            if (innerHit != null) continue;
            innerHit = ex.hitName();
        }
        int sz = this.hits.getHits().length;
        int maxDepth = 0;
        if (!innerHits.isEmpty()) {
            if (innerHits.size() > 1) {
                throw new SqlIllegalArgumentException("Multi-nested docs not yet supported {}", innerHits);
            }
            maxDepth = 1;
            sz = 0;
            for (SearchHit hit : this.hits) {
                HashMap<String, SearchHit[]> innerHitsPerPath = new HashMap<String, SearchHit[]>(innerHits.size());
                for (String ih : innerHits) {
                    SearchHit[] sh = this.getAllInnerHits(hit, ih);
                    innerHitsPerPath.put(ih, sh);
                    sz += sh.length;
                }
                this.flatInnerHits.put(hit, innerHitsPerPath);
            }
        }
        this.size = limit < 0 ? sz : Math.min(sz, limit);
        this.indexPerLevel = new int[maxDepth + 1];
        this.innerHit = innerHit;
        int remaining = limit < 0 ? limit : limit - this.size;
        this.remainingLimit = this.size < sizeRequested || remaining == 0 ? 0 : remaining;
    }

    public boolean hasRemaining() {
        return this.remainingLimit != 0;
    }

    public int getRemainingLimit() {
        return this.remainingLimit;
    }

    @Override
    protected Object extractValue(HitExtractor e) {
        int extractorLevel = e.hitName() == null ? 0 : 1;
        SearchHit hit = null;
        SearchHit[] sh = this.hits.getHits();
        for (int lvl = 0; lvl <= extractorLevel; ++lvl) {
            if (hit != null) {
                SearchHit[] innerHits = this.flatInnerHits.get(hit).get(this.innerHit);
                sh = innerHits == null ? SearchHits.EMPTY : innerHits;
            }
            hit = sh[this.indexPerLevel[lvl]];
        }
        return e.extract(hit);
    }

    private SearchHit[] getAllInnerHits(SearchHit hit, String path) {
        if (hit == null) {
            return null;
        }
        HashMap<Integer, SearchHit> lhm = new HashMap<Integer, SearchHit>();
        for (Map.Entry entry : hit.getInnerHits().entrySet()) {
            SearchHit[] h;
            int endOfPath = ((String)entry.getKey()).lastIndexOf(95);
            if (endOfPath < 0 || !((String)entry.getKey()).substring(0, endOfPath).equals(path)) continue;
            for (SearchHit element : h = ((SearchHits)entry.getValue()).getHits()) {
                lhm.put(element.getNestedIdentity().getOffset(), element);
            }
        }
        ArrayList sortedList = new ArrayList(lhm.values());
        Collections.sort(sortedList, new NestedHitOffsetComparator(this));
        return (SearchHit[])sortedList.toArray(SearchHit[]::new);
    }

    @Override
    protected boolean doHasCurrent() {
        return this.row < this.size;
    }

    @Override
    protected boolean doNext() {
        if (this.row < this.size - 1) {
            ++this.row;
            int n = this.indexPerLevel.length - 1;
            this.indexPerLevel[n] = this.indexPerLevel[n] + 1;
            SearchHit[] sh = this.hits.getHits();
            for (int lvl = 0; lvl < this.indexPerLevel.length; ++lvl) {
                String path;
                if (this.indexPerLevel[lvl] == sh.length) {
                    this.indexPerLevel[lvl] = 0;
                    int n2 = lvl - 1;
                    this.indexPerLevel[n2] = this.indexPerLevel[n2] + 1;
                    lvl = 0;
                    sh = this.hits.getHits();
                    continue;
                }
                SearchHit h = sh[this.indexPerLevel[lvl]];
                String string = path = lvl == 0 ? this.innerHit : null;
                if (path == null) continue;
                SearchHit[] innerHits = this.flatInnerHits.get(h).get(path);
                sh = innerHits == null ? SearchHits.EMPTY : innerHits;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void doReset() {
        this.row = 0;
        Arrays.fill(this.indexPerLevel, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    private class NestedHitOffsetComparator
    implements Comparator<SearchHit> {
        private NestedHitOffsetComparator(SearchHitRowSet searchHitRowSet) {
        }

        @Override
        public int compare(SearchHit sh1, SearchHit sh2) {
            if (sh1 == null && sh2 == null) {
                return 0;
            }
            if (sh1 == null) {
                return -1;
            }
            if (sh2 == null) {
                return 1;
            }
            return Integer.valueOf(sh1.getNestedIdentity().getOffset()).compareTo(sh2.getNestedIdentity().getOffset());
        }
    }
}

