/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BinaryDateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTrunc;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalDayTime;
import org.elasticsearch.xpack.sql.expression.literal.interval.IntervalYearMonth;

public class DateTruncProcessor
extends BinaryDateTimeProcessor {
    public static final String NAME = "dtrunc";

    public DateTruncProcessor(Processor source1, Processor source2, ZoneId zoneId) {
        super(source1, source2, zoneId);
    }

    public DateTruncProcessor(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Object doProcess(Object truncateTo, Object timestamp) {
        return DateTruncProcessor.process(truncateTo, timestamp, this.zoneId());
    }

    public static Object process(Object truncateTo, Object timestamp, ZoneId zoneId) {
        if (truncateTo == null || timestamp == null) {
            return null;
        }
        if (!(truncateTo instanceof String)) {
            throw new SqlIllegalArgumentException("A string is required; received [{}]", truncateTo);
        }
        DateTrunc.Part truncateDateField = DateTrunc.Part.resolve((String)truncateTo);
        if (truncateDateField == null) {
            List<String> similar = DateTrunc.Part.findSimilar((String)truncateTo);
            if (similar.isEmpty()) {
                throw new InvalidArgumentException("A value of {} or their aliases is required; received [{}]", new Object[]{DateTrunc.Part.values(), truncateTo});
            }
            throw new InvalidArgumentException("Received value [{}] is not valid date part for truncation; did you mean {}?", new Object[]{truncateTo, similar});
        }
        if (!(timestamp instanceof ZonedDateTime || timestamp instanceof IntervalYearMonth || timestamp instanceof IntervalDayTime)) {
            throw new SqlIllegalArgumentException("A date/datetime/interval is required; received [{}]", timestamp);
        }
        if (truncateDateField == DateTrunc.Part.WEEK && (timestamp instanceof IntervalDayTime || timestamp instanceof IntervalYearMonth)) {
            throw new InvalidArgumentException("Truncating intervals is not supported for {} units", new Object[]{truncateTo});
        }
        if (timestamp instanceof ZonedDateTime) {
            return truncateDateField.truncate(((ZonedDateTime)timestamp).withZoneSameInstant(zoneId));
        }
        if (timestamp instanceof IntervalYearMonth) {
            return truncateDateField.truncate((IntervalYearMonth)timestamp);
        }
        return truncateDateField.truncate((IntervalDayTime)timestamp);
    }
}

