/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.plugin;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.eql.action.EqlSearchAction;
import org.elasticsearch.xpack.eql.action.EqlSearchRequest;
import org.elasticsearch.xpack.eql.action.EqlSearchResponse;
import org.elasticsearch.xpack.ql.util.LoggingUtils;

@ServerlessScope(value=Scope.PUBLIC)
public class RestEqlSearchAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(RestEqlSearchAction.class);
    private static final String SEARCH_PATH = "/{index}/_eql/search";

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, SEARCH_PATH), new RestHandler.Route(RestRequest.Method.POST, SEARCH_PATH));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String indices;
        EqlSearchRequest eqlRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            eqlRequest = EqlSearchRequest.fromXContent(parser);
            indices = request.param("index");
            eqlRequest.indices(Strings.splitStringByCommaToArray((String)indices));
            eqlRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)eqlRequest.indicesOptions()));
            if (request.hasParam("wait_for_completion_timeout")) {
                eqlRequest.waitForCompletionTimeout(request.paramAsTime("wait_for_completion_timeout", eqlRequest.waitForCompletionTimeout()));
            }
            if (request.hasParam("keep_alive")) {
                eqlRequest.keepAlive(request.paramAsTime("keep_alive", eqlRequest.keepAlive()));
            }
            eqlRequest.keepOnCompletion(request.paramAsBoolean("keep_on_completion", eqlRequest.keepOnCompletion()));
            eqlRequest.ccsMinimizeRoundtrips(request.paramAsBoolean("ccs_minimize_roundtrips", eqlRequest.ccsMinimizeRoundtrips()));
            eqlRequest.allowPartialSearchResults(request.paramAsBoolean("allow_partial_search_results", eqlRequest.allowPartialSearchResults()));
            eqlRequest.allowPartialSequenceResults(request.paramAsBoolean("allow_partial_sequence_results", eqlRequest.allowPartialSequenceResults()));
        }
        return channel -> {
            RestCancellableNodeClient cancellableClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancellableClient.execute((ActionType)EqlSearchAction.INSTANCE, (ActionRequest)eqlRequest, (ActionListener)new ActionListener<EqlSearchResponse>(this){

                public void onResponse(EqlSearchResponse response) {
                    try {
                        XContentBuilder builder = channel.newBuilder(request.getXContentType(), XContentType.JSON, true);
                        response.toXContent(builder, (ToXContent.Params)request);
                        channel.sendResponse(new RestResponse(RestStatus.OK, builder));
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    IndexNotFoundException infe;
                    Exception finalException = e;
                    if (e instanceof IndexNotFoundException && (infe = (IndexNotFoundException)e).getIndex() != null && infe.getIndex().getName().equals("Unknown index [*,-*]")) {
                        finalException = new IndexNotFoundException(indices, infe.getCause());
                    }
                    LoggingUtils.logOnFailure((Logger)LOGGER, (Throwable)finalException);
                    try {
                        channel.sendResponse(new RestResponse(channel, finalException));
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(finalException);
                        LOGGER.error("failed to send failure response", (Throwable)inner);
                    }
                }
            });
        };
    }

    public String getName() {
        return "eql_search";
    }
}

