/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.netty4.NettyAllocator;

public class Netty4Utils {
    private static final AtomicBoolean isAvailableProcessorsSet = new AtomicBoolean();

    public static void setAvailableProcessors(int availableProcessors) {
        boolean set = Booleans.parseBoolean((String)System.getProperty("es.set.netty.runtime.available.processors", "true"));
        if (!set) {
            return;
        }
        if (isAvailableProcessorsSet.compareAndSet(false, true)) {
            NettyRuntime.setAvailableProcessors((int)availableProcessors);
        } else if (availableProcessors != NettyRuntime.availableProcessors()) {
            String message = String.format(Locale.ROOT, "available processors value [%d] did not match current value [%d]", availableProcessors, NettyRuntime.availableProcessors());
            throw new IllegalStateException(message);
        }
    }

    public static ByteBuf toByteBuf(BytesReference reference) {
        if (reference.hasArray()) {
            return Unpooled.wrappedBuffer((byte[])reference.array(), (int)reference.arrayOffset(), (int)reference.length());
        }
        return Netty4Utils.compositeReferenceToByteBuf(reference);
    }

    private static ByteBuf compositeReferenceToByteBuf(BytesReference reference) {
        BytesRefIterator iterator = reference.iterator();
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(3);
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                buffers.add(Unpooled.wrappedBuffer((byte[])slice.bytes, (int)slice.offset, (int)slice.length));
            }
            if (buffers.size() == 1) {
                return (ByteBuf)buffers.get(0);
            }
            CompositeByteBuf composite = Unpooled.compositeBuffer((int)buffers.size());
            composite.addComponents(true, buffers);
            return composite;
        }
        catch (IOException ex) {
            throw new AssertionError("no IO happens here", ex);
        }
    }

    public static BytesReference toBytesReference(ByteBuf buffer) {
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return BytesArray.EMPTY;
        }
        if (buffer.hasArray()) {
            return new BytesArray(buffer.array(), buffer.arrayOffset() + buffer.readerIndex(), readableBytes);
        }
        ByteBuffer[] byteBuffers = buffer.nioBuffers();
        return BytesReference.fromByteBuffers((ByteBuffer[])byteBuffers);
    }

    public static ReleasableBytesReference toReleasableBytesReference(ByteBuf buffer) {
        return new ReleasableBytesReference(Netty4Utils.toBytesReference(buffer), (RefCounted)Netty4Utils.toRefCounted(buffer));
    }

    static ByteBufRefCounted toRefCounted(ByteBuf buf) {
        return new ByteBufRefCounted(buf);
    }

    public static HttpBody.Full fullHttpBodyFrom(ByteBuf buf) {
        return new HttpBody.ByteRefHttpBody(Netty4Utils.toReleasableBytesReference(buf));
    }

    public static Recycler<BytesRef> createRecycler(Settings settings) {
        Netty4Utils.setAvailableProcessors(EsExecutors.allocatedProcessors((Settings)settings));
        return NettyAllocator.getRecycler();
    }

    public static void safeWriteAndFlush(Channel channel, Object message, ActionListener<Void> listener) {
        DefaultChannelPromise promise = new DefaultChannelPromise(channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        Netty4Utils.addListener((Future<Void>)promise, listener);
        assert (Netty4Utils.assertCorrectPromiseListenerThreading((ChannelPromise)promise));
        channel.writeAndFlush(message, (ChannelPromise)promise);
        if (channel.eventLoop().isShuttingDown()) {
            channel.eventLoop().terminationFuture().addListener(ignored -> promise.tryFailure((Throwable)new TransportException("Cannot send network message, event loop is shutting down.")));
        }
    }

    private static boolean assertCorrectPromiseListenerThreading(ChannelPromise promise) {
        Netty4Utils.addListener((ChannelFuture)promise, future -> {
            EventLoop eventLoop = future.channel().eventLoop();
            assert (eventLoop.inEventLoop() || future.cause() instanceof RejectedExecutionException || eventLoop.isTerminated()) : future.cause();
        });
        return true;
    }

    public static void addListener(Future<Void> future, ActionListener<Void> listener) {
        future.addListener(f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                if (cause instanceof Exception) {
                    Exception exception = (Exception)cause;
                    listener.onFailure(exception);
                } else {
                    listener.onFailure(new Exception(cause));
                }
            }
        });
    }

    @SuppressForbidden(reason="single point for adding listeners that enforces use of ChannelFutureListener")
    public static void addListener(ChannelFuture channelFuture, ChannelFutureListener listener) {
        channelFuture.addListener((GenericFutureListener)listener);
    }

    record ByteBufRefCounted(ByteBuf buffer) implements RefCounted
    {
        public int refCnt() {
            return this.buffer.refCnt();
        }

        public void incRef() {
            this.buffer.retain();
        }

        public boolean tryIncRef() {
            if (!this.hasReferences()) {
                return false;
            }
            try {
                this.buffer.retain();
            }
            catch (RuntimeException e) {
                assert (!this.hasReferences());
                return false;
            }
            return true;
        }

        public boolean decRef() {
            return this.buffer.release();
        }

        public boolean hasReferences() {
            return this.buffer.refCnt() > 0;
        }
    }
}

