/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.support;

import java.io.IOException;
import java.util.function.LongSupplier;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.script.AggregationScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.MissingValues;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.index.fielddata.IndexCartesianPointFieldData;
import org.elasticsearch.xpack.spatial.search.aggregations.support.CartesianPointValuesSource;

public class CartesianPointValuesSourceType
implements Writeable,
ValuesSourceType {
    static CartesianPointValuesSourceType INSTANCE = new CartesianPointValuesSourceType();

    public static CartesianPointValuesSourceType instance() {
        return INSTANCE;
    }

    public ValuesSource getEmpty() {
        return CartesianPointValuesSource.EMPTY;
    }

    public ValuesSource getScript(AggregationScript.LeafFactory script, ValueType scriptValueType) {
        throw new UnsupportedOperationException("point");
    }

    public ValuesSource getField(FieldContext fieldContext, AggregationScript.LeafFactory script) {
        IndexFieldData indexFieldData = fieldContext.indexFieldData();
        if (indexFieldData instanceof IndexCartesianPointFieldData) {
            IndexCartesianPointFieldData pointFieldData = (IndexCartesianPointFieldData)indexFieldData;
            return new CartesianPointValuesSource.Fielddata(pointFieldData);
        }
        throw new IllegalArgumentException("Expected point type on field [" + fieldContext.field() + "], but got [" + fieldContext.fieldType().typeName() + "]");
    }

    public ValuesSource replaceMissing(ValuesSource valuesSource, Object rawMissing, DocValueFormat docValueFormat, LongSupplier nowInMillis) {
        final CartesianPointValuesSource pointValuesSource = (CartesianPointValuesSource)valuesSource;
        final CartesianPoint missing = new CartesianPoint().resetFromString(rawMissing.toString(), false);
        return new CartesianPointValuesSource(this){

            @Override
            public SortedNumericDocValues sortedNumericDocValues(LeafReaderContext context) {
                long xi = XYEncodingUtils.encode((float)((float)missing.getX()));
                long yi = XYEncodingUtils.encode((float)((float)missing.getY()));
                long encoded = yi & 0xFFFFFFFFL | xi << 32;
                return MissingValues.replaceMissing((SortedNumericDocValues)pointValuesSource.sortedNumericDocValues(context), (long)encoded);
            }

            public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
                return MissingValues.replaceMissing((SortedBinaryDocValues)pointValuesSource.bytesValues(context), (BytesRef)new BytesRef((CharSequence)missing.toString()));
            }

            public String toString() {
                return "anon CartesianPointValuesSource of [" + super.toString() + "]";
            }
        };
    }

    public String typeName() {
        return "point";
    }

    public void writeTo(StreamOutput out) throws IOException {
    }
}

